/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.util.BitSet;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Shade3D;
import org.jmol.geodesic.Geodesic;

class Normix3D {
    static final int NORMIX_GEODESIC_LEVEL = 3;
    private static final int normixCount = Geodesic.getVertexCount(3);
    private static final Vector3f[] vertexVectors = Geodesic.getVertexVectors();
    private static final short[][] neighborVertexesArrays = Geodesic.getNeighborVertexesArrays();
    private final Vector3f[] transformedVectors;
    private final byte[] shadeIndexes;
    private final byte[] shadeIndexes2Sided;
    private static final boolean TIMINGS = false;
    private final Matrix3f rotationMatrix = new Matrix3f();
    private final BitSet bsConsidered = new BitSet();
    short[] inverseNormixes;
    private static byte nullShadeIndex = (byte)50;

    Normix3D() {
        this.shadeIndexes = new byte[normixCount];
        this.shadeIndexes2Sided = new byte[normixCount];
        this.transformedVectors = new Vector3f[normixCount];
        int n = normixCount;
        while (--n >= 0) {
            this.transformedVectors[n] = new Vector3f();
        }
    }

    Vector3f[] getTransformedVectors() {
        return this.transformedVectors;
    }

    boolean isDirectedTowardsCamera(short s) {
        return s < 0 || this.transformedVectors[s].z > 0.0f;
    }

    short getNormix(Vector3f vector3f) {
        return this.getNormix(vector3f.x, vector3f.y, vector3f.z, 3);
    }

    Vector3f getVector(short s) {
        return vertexVectors[s];
    }

    short getNormix(double d, double d2, double d3, int n) {
        double d4;
        short s;
        if (d3 >= 0.0) {
            s = 0;
            d4 = d3 - 1.0;
        } else {
            s = 11;
            d4 = d3 - -1.0;
        }
        this.bsConsidered.clear();
        this.bsConsidered.set(s);
        double d5 = d * d + d2 * d2 + d4 * d4;
        for (int i = 0; i <= n; ++i) {
            short[] sArray = neighborVertexesArrays[i];
            int n2 = 6 * s;
            int n3 = n2 + (s < 12 ? 5 : 6);
            while (--n3 >= n2) {
                short s2 = sArray[n3];
                if (this.bsConsidered.get(s2)) continue;
                this.bsConsidered.set(s2);
                Vector3f vector3f = vertexVectors[s2];
                double d6 = (double)vector3f.x - d;
                double d7 = d6 * d6;
                if (d7 >= d5 || (d7 += (d6 = (double)vector3f.y - d2) * d6) >= d5 || (d7 += (d6 = (double)vector3f.z - d3) * d6) >= d5) continue;
                s = s2;
                d5 = d7;
            }
        }
        return s;
    }

    void calculateInverseNormixes() {
        this.inverseNormixes = new short[normixCount];
        int n = normixCount;
        while (--n >= 0) {
            Vector3f vector3f = vertexVectors[n];
            this.inverseNormixes[n] = this.getNormix(-vector3f.x, -vector3f.y, -vector3f.z, 3);
        }
    }

    int getShadeIndex(short s) {
        return s == -10000 || s == 9999 ? nullShadeIndex : (s < 0 ? this.shadeIndexes2Sided[~s] : this.shadeIndexes[s]);
    }

    void setRotationMatrix(Matrix3f matrix3f) {
        this.rotationMatrix.set(matrix3f);
        int n = normixCount;
        while (--n >= 0) {
            Vector3f vector3f = this.transformedVectors[n];
            matrix3f.transform(vertexVectors[n], vector3f);
            float f = vector3f.x;
            float f2 = -vector3f.y;
            float f3 = vector3f.z;
            int n2 = Shade3D.getShadeIndexNormalized(f, f2, f3);
            this.shadeIndexes[n] = (byte)n2;
            this.shadeIndexes2Sided[n] = (byte)(f3 >= 0.0f ? n2 : Shade3D.getShadeIndexNormalized(-f, -f2, -f3));
        }
    }
}

