import timeit
from _typeshed import Incomplete
from collections.abc import Generator
from hmac import compare_digest
from typing import Any

from passlib.utils.compat import JYTHON as JYTHON

__all__ = [
    "JYTHON",
    "sys_bits",
    "unix_crypt_schemes",
    "rounds_cost_values",
    "consteq",
    "saslprep",
    "xor_bytes",
    "render_bytes",
    "is_same_codec",
    "is_ascii_safe",
    "to_bytes",
    "to_unicode",
    "to_native_str",
    "has_crypt",
    "test_crypt",
    "safe_crypt",
    "tick",
    "rng",
    "getrandbytes",
    "getrandstr",
    "generate_password",
    "is_crypt_handler",
    "is_crypt_context",
    "has_rounds_info",
    "has_salt_info",
]

sys_bits: Any
unix_crypt_schemes: list[str]
rounds_cost_values: Any

class SequenceMixin:
    def __getitem__(self, idx): ...
    def __iter__(self): ...
    def __len__(self) -> int: ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...

consteq = compare_digest

def str_consteq(left, right): ...
def saslprep(source, param: str = "value"): ...
def render_bytes(source, *args): ...
def xor_bytes(left, right): ...
def is_same_codec(left, right): ...
def is_ascii_safe(source): ...
def to_bytes(source, encoding: str = "utf-8", param: str = "value", source_encoding: Incomplete | None = None): ...
def to_unicode(source, encoding: str = "utf-8", param: str = "value"): ...
def to_native_str(source, encoding: str = "utf-8", param: str = "value"): ...

has_crypt: bool

def safe_crypt(secret, hash) -> None: ...
def test_crypt(secret, hash): ...

timer = timeit.default_timer
tick = timer
rng: Any

def getrandbytes(rng, count) -> Generator[None, None, Any]: ...
def getrandstr(rng, charset, count) -> Generator[None, None, Any]: ...
def generate_password(size: int = 10, charset=...): ...
def is_crypt_handler(obj): ...
def is_crypt_context(obj): ...
def has_rounds_info(handler): ...
def has_salt_info(handler): ...
