# FT10-transformation

antiX (Debian based) package to make a friendly toolbar and menu with a tint2 panel and jgmenu

## Debian Packaging
This source has been modified for easy .deb package building.
Building has been tested on a debian buster distro (antiX 19.4 base).
Simple instructions below for personal use.

**0. Download source**

Download this source and unpack it (if not already) to a separate folder with easy access.

Example: unpack to `~/ft10-transformation/` folder.

**1. Install build dependencies**

ft10-transformation is mainly a collection of bash scripts. The needed dependencies are usually installed in most distros: `gettext, bash, coreutils, util-linux, sed`

Packaging prerequisites: `build-essential fakeroot devscripts debhelper`

One-liner:
~~~
sudo apt install build-essential fakeroot devscripts debhelper gettext, bash, coreutils, util-linux, sed
~~~

**2. Building .deb package**

The easy way is navigating to the folder that contains the source, open a terminal there, and run:
~~~
debuild -b -uc -us
~~~
It will build the .deb package for your architecture and save it "outside" the folder (one level above).

Example: it will create a `ft10-transformation_0.1.0_all.deb` file

As the program contains mainly bash scripts, it will work on all architectures that contain the dependencies needed for it to work.

**3. Install**

You can install using gdebi, your software-center program or from terminal. Example below:
~~~
sudo apt install /path/to/ft10-transformation_0.1.0_all.deb
~~~

**4. Depenencies**

ft10-transformations needs *yad* for the main dialogs, *skippy-xd* for the task/window selection view, *tint2* as the toolbar, and either *jgmenu* version 4.4.0 or greater (for searching inside folders contained in /usr/share/applications) or the already built and adapted to antiX linux [jgmenu-antix](https://gitlab.com/antix-contribs/jgmenu-antix).

Some launchers also point to antiX's unique desktop-session and desktop-defaults programs, which make it easier to set default browser, terminal, text editor, etc. But these are not required for this program to work. 

Once all dependencies are installed, you should be able to install ft10-transformation.

## How to use

Place the command `ft10-start` in your startup file, as a startup command
~~~
ft10-start &
~~~
and next time you start your linux session, it will configure jgmenu and tint2 with the custom layout brought by ft10-transformation.

You can restore the default configuration running the `ft10-create` command.

You can edit favorite applications in jgmenu launching the `jgmenu-editor.sh` command or from the menu itself.

The jgmenu layouts have been prepared to be able to adapt to the running gtk theme. Try it out running the jgmenu command `jgmenu_run gtktheme` (result not guaranteed)

## Language support

We have done as best as possible to support different languages, but we are limited in our knowledge. Contact the maintainer if you need support for your language.
