#!/bin/bash
################################
# Yad calendar that allows to enter and view events, created for use with antiX Linux
#Version 2- 14/01/2022, by PPC, GPL license, use as you wish, but please keep this atribution lines 

Adicionar_evento(){
# Day without event, add one...
event=$(yad --window-icon="/usr/share/icons/papirus-antix/24x24/apps/calendar.png" --width=800 --form --center --title="$day ..." --field="") && event=${event%|*}
space=" "
text=$day$space$event
echo $text >> $HOME/yad-calendar.txt
exit
}

Editar_evento(){
# Day with existing event, edit it...
entrada=$(grep -h $day $HOME/yad-calendar.txt)
line=($(grep -n $day $HOME/yad-calendar.txt | head -n 1 | cut -d: -f1))
altered_entry=$(yad --width=800 --center --title="$day" --undecorated --button="OK" --form --field="" "$entrada")
#remove last unecessary character
entry=${altered_entry%|*}
#save text into the original line
awk -v line=$line -v texto="$entry" 'NR=='line' {$0='texto'} { print }' $HOME/yad-calendar.txt > $HOME/yad-calendar.txt.TEMP
cp $HOME/yad-calendar.txt.TEMP $HOME/yad-calendar.txt
exit
}

#import functions and make sure that the default config file exists
import -f Adicionar_evento Editar_evento
touch ~/yad-calendar.txt && [ -s ~/yad-calendar.txt ] || echo "28/06/2020 This is how yad-calendar entries work! Add ONLY ONE line per day, starting with the date. If nothing shows up in the calendar, try another date format like dd-mm-yyyy" > $HOME/yad-calendar.txt

#Main part of the script:
#New section: on the top of the month view, display todays event's if any;
today=$(date +%x)
todays_events=$(grep $today $HOME/yad-calendar.txt)
#Draw main window
day=$(yad --calendar --undecorated --geometry=280x90-40-50 --title="antiX-calendar" --text="$todays_events" --details=$HOME/yad-calendar.txt --button="x":1)
if [[ $foo -eq 1 ]]; then
    exit 1
  fi
#If no date selected, just exit
[ -z "$day" ] && exit

#If a date was selected, see if has an event and run the corresponding function
if grep -q $day $HOME/yad-calendar.txt; then
   Editar_evento
   else
   Adicionar_evento
fi
