#!/bin/bash
#Script to manage some basic IceWM toolbar settings
#By PPC, GPL license, 2/2023

        TEXTDOMAINDIR=/usr/share/locale
        TEXTDOMAIN=icewm-manager-gui

###Text shown in the script (for easy localization/edition, it's placed in variables):
main_window_title=$"Basic IceWM Settings Manager"
main_window_text=$"Select what you want to change from the options below. If an option fails to work, please try clicking it again."
clock_field=$"Clock"
clock_on_off=$"Show clock on/off"
clock_12_24h=$"12h/24h time"
clock_seconds=$"Show seconds on clock on/off"
clock_LED=$"Show clock in LED on/off"
sys_info_field=$"System information shown in System Tray"
sys_net=$"Show Network information on System Tray on/off"
sys_ram=$"Show RAM information on System Tray on/off"
sys_cpu=$"Show CPU, RAM and SWAP  information on System Tray on/off"
window_managment_field=$"Window Management"
title_icon=$"Show Application icon on window title bar on/off"
center_win=$"Centre new large windows on/off"
moving_osd=$"Show indication of position when moving windows  on/off"
remember_win=$"Click a Window to memorize its position"
startup_field=$"Auto Start"
add_remove_main_button=$"Add or Remove an application from IceWM start file"
toolbar_settings_field=$"Toolbar generic settings"
auto_hide=$"Auto-hide toolbar on/off"
double_hight=$"Double height toolbar on/off"
top_bottom=$"Toolbar on top/bottom of screen"
names_on_toolbar=$"Show window names on toolbar on/off"
tim=$"Manage quick launch toolbar icons"
show_desktop=$"'Show Desktop' icon on/off"
workspace_toggle=$"Workspace indicator on/off"
workspace_manager=$"Workspace Manager"
menu_field=$"Menu:"
personal_menu_manager=$"Manage Personal Menu entries"
look_feel=$"Look and feel:"
wallpaper=$"Wallpaper"
appearance=$"Appearance"
select_theme=$"Select IceWM Theme"
add_to_desktop=$"Selected app icon to place on the (zzz) Desktop"
add_remove_text=$"Do you want to add or to remove an entry to IceWm's startup? Current startup file"
add_startup_appselect=$"Add application from a list"
add_startup_command=$"Add a (manual) command"
remove_startup=$"Remove an application"
add_startup_confirmation=$"The line was added to the $HOME/.icewm/startup file. It will start automatically the next time you start  antiX using the IceWM desktop"
add_startup_command_title=$"Enter command to be added to IceWM's startup file"
add_startup_command_text=$"Enter command you want to run at IceWM's startup. Note: an ampersand/& will automatically be appended to the end of the command"
remove_startup_text="Select command to be removed from the startup file. Note: all entries with the selected command will be deleted!"
remove_button=$"Remove"
remove_confirmation=$"The line was removed from $HOME/.icewm/startup file. The related application will no longer start automatically the next time you start  antiX using the IceWM desktop"
themes_title=$"IceWM Themes"
select_theme_text=$"Double click its name to select a new Theme:"
current_theme_text=$"The current IceWM Theme is "
keyboard_shortcuts=$"Manage keyboard shortcuts"
warning=$"Warning"
icewm_only_text=$"This script is meant to be run only in an IceWM desktop"
reset_text=$"Reset to default contents"
show_only_used_network_devices=$"Show only used network devices on/off"
collapse=$"Collapse Toolbar button on/off"
weather=$"Show Weather icon on/off"
manualedit=$"Manually edit config files"
personal_menu_toggle=$"Personal sub-menu on/off"
change_time_date=$"Set time and date"
personal_entries_on_the_first_layer=$"Personal entries on the first layer of menu on/off"
run_menu_entry="Run menu entry on/off"
conky=$"Show/hide Conky resource indicator on the desktop"
show_icewm_preferences_menu=$"Icewm Settings in menu on/off"
show_xkill=$"Xkill menu entry on/off"

export add_remove_main_button add_to_desktop add_remove_text  add_startup_appselect add_startup_command add_startup_command_text remove_startup add_startup_confirmation add_startup_command_title add_startup_command_text remove_startup_text remove_button remove_confirmation themes_title select_theme_text current_theme_text warning reset_text
 
#Script variables
file=$HOME/.icewm/prefoverride
#Make sure the prefoverride file exists:
touch $file

###Check if the current desktop is IceWM, if not, exit
desktop=$(wmctrl -m)
if [[ $desktop == *"icewm"* ]]; then
  result="You are running an IceWM desktop"
    else 
   yad --title="$warning" --text="$icewm_only_text" --timeout=10 --no-buttons --center
 exit
fi


toogle_system_info_square_on_system_tray()
{
###Manage the System Info toolbar square that shows information about CPU/RAM/SWAP usage:
###first make sure that it exists in prefoverride, then make sure it's set to 0
file=$HOME/.icewm/prefoverride
text="TaskBarShowCPUStatus="
#Check if string exists in  file, if it does not, add it and make sure it's set to 0 (its 1 be default):
if cat $file | grep ^$text; then
   # echo found, making sure its not commented out
    sed -i "/$text/s/^#//g" $file
else
   # echo not found
    echo ${text}1 >> $file
fi
#Toggle TaskBarShowCPUStatus (if it exists in prefoverride):
if grep -F  "${text}"1 "$file"; then
    sed -i "s/${text}.*/${text}0/" $file
elif grep -F  "${text}"0 "$file"; then
    sed -i "s/${text}.*/${text}1/" $file
 fi
#restart icewm, to see the change:
 icewm -r
#Exit function:
return
}

toogle_RAM_info_square_on_system_tray()
{
###Manage the System Info toolbar square that shows information about CPU/RAM/SWAP usage:
###first make sure that it exists in prefoverride, then make sure it's set to 0
file=$HOME/.icewm/prefoverride
text="TaskBarShowMEMStatus="
#Check if string exists in  file, if it does not, add it and make sure it's set to 0 (its 1 be default):
if cat $file | grep ^$text; then
   # echo found, making sure its not commented out
    sed -i "/$text/s/^#//g" $file
else
   # echo not found
    echo ${text}1 >> $file
fi
#Toggle TaskBarShowMEMStatus:
if grep -F  "${text}"1 "$file"; then
    sed -i "s/${text}.*/${text}0/" $file
elif grep -F  "${text}"0 "$file"; then
    sed -i "s/${text}.*/${text}1/" $file
 fi
#restart icewm, to see the change:
 icewm -r
#Exit function:
return
}

toogle_Network_info_square_on_system_tray()
{
###Manage the System Info toolbar square that shows information about NETWORK usage:
###first make sure that it exists in prefoverride, then make sure it's set to 0
file=$HOME/.icewm/prefoverride
text="TaskBarShowNetStatus="
#Check if string exists in  file, if it does not, add it and make sure it's set to 0 (its 1 be default):
if cat $file | grep ^$text; then
   # echo found, making sure its not commented out
    sed -i "/$text/s/^#//g" $file
else
   # echo not found
    echo ${text}1 >> $file
fi
#Toggle TaskBarShowMEMStatus:
if grep -F  "${text}"1 "$file"; then
    sed -i "s/${text}.*/${text}0/" $file
elif grep -F  "${text}"0 "$file"; then
    sed -i "s/${text}.*/${text}1/" $file
 fi
#restart icewm, to see the change:
 icewm -r
#Exit function:
return
}

toggle_seconds()
{
Show/hide seconds on clock
file=$HOME/.icewm/prefoverride
text="TimeFormat="
#Check if string exists in  file, if it does not, add it and make sure it's set to 0 (its 1 be default):
if cat $file | grep ^$text; then
   # echo found, making sure its not commented out
    sed -i "/$text/s/^#//g" $file
else
   # echo not found, use default values
    echo ${text}%H:%M:%S  >> $file
fi

#Toggle value:
if grep -F  ":%S" "$file"; then
    sed -i "s/\:%S.*/ /" $file
else
    sed -i "s/\:%M.*/:%M:%S/" $file
 fi
 
#restart icewm, to see the change:
 icewm -r

}

toggle12h24h()
{
Show/hide seconds on clock
file=$HOME/.icewm/prefoverride
text="TimeFormat="
#Check if string exists in  file, if it does not, add it and make sure it's set to 0 (its 1 be default):
if cat $file | grep ^$text; then
   # echo found, making sure its not commented out
    sed -i "/$text/s/^#//g" $file
else
   # echo not found, use default values
    echo ${text}%H:%M:%S  >> $file
fi

#Toggle value:
if grep -F  "%H" "$file"; then
	sed -i 's/%H/%l/' $file
   else
    sed -i 's/%l/%H/' $file
 fi
 
#restart icewm, to see the change:
 icewm -r

}

toggle_clock_LED()
{
###first make sure that it exists in prefoverride, then make sure it's set to 0
file=$HOME/.icewm/prefoverride
text="TaskBarClockLeds="
#Check if string exists in  file, if it does not, add it and make sure it's set to 0 (its 1 be default):
if cat $file | grep ^$text; then
   # echo found, making sure its not commented out
    sed -i "/$text/s/^#//g" $file
else
   # echo not found
    echo ${text}1 >> $file
fi
#Toggle TaskBarShowCPUStatus (if it exists in prefoverride):
if grep -F  "${text}"1 "$file"; then
    sed -i "s/${text}.*/${text}0/" $file
elif grep -F  "${text}"0 "$file"; then
    sed -i "s/${text}.*/${text}1/" $file
 fi
#restart icewm, to see the change:
 icewm -r
#Exit function:
return	
}

toggle_clock()
{
###first make sure that it exists in prefoverride, then make sure it's set to 0
file=$HOME/.icewm/prefoverride
text="TaskBarShowClock="
#Check if string exists in  file, if it does not, add it and make sure it's set to 0 (its 1 be default):
if cat $file | grep ^$text; then
   # echo found, making sure its not commented out
    sed -i "/$text/s/^#//g" $file
else
   # echo not found
    echo ${text}1 >> $file
fi
#Toggle TaskBarShowCPUStatus (if it exists in prefoverride):
if grep -F  "${text}"1 "$file"; then
    sed -i "s/${text}.*/${text}0/" $file
elif grep -F  "${text}"0 "$file"; then
    sed -i "s/${text}.*/${text}1/" $file
 fi
#restart icewm, to see the change:
 icewm -r
#Exit function:
return	
}

icon_on_title_bar()
{
file=$HOME/.icewm/prefoverride
text="ShowMenuButtonIcon="
#Check if string exists in  file, if it does not, add it and make sure it's set to 0 (its 1 be default):
if cat $file | grep ^$text; then
   # echo found, making sure its not commented out
    sed -i "/$text/s/^#//g" $file
else
   # echo not found
    echo ${text}1 >> $file
fi
#Toggle TaskBarShowCPUStatus (if it exists in prefoverride):
if grep -F  "${text}"1 "$file"; then
    sed -i "s/${text}.*/${text}0/" $file
elif grep -F  "${text}"0 "$file"; then
    sed -i "s/${text}.*/${text}1/" $file
 fi
#restart icewm, to see the change:
 icewm -r
#Exit function:
return		
	}
	
autohide_toolbar()
{
file=$HOME/.icewm/prefoverride
text="TaskBarAutoHide="
#Check if string exists in  file, if it does not, add it and make sure it's set to 0 (its 1 be default):
if cat $file | grep ^$text; then
   # echo found, making sure its not commented out
    sed -i "/$text/s/^#//g" $file
else
   # echo not found
    echo ${text}0 >> $file
fi
#Toggle TaskBarShowCPUStatus (if it exists in prefoverride):
if grep -F  "${text}"1 "$file"; then
    sed -i "s/${text}.*/${text}0/" $file
elif grep -F  "${text}"0 "$file"; then
    sed -i "s/${text}.*/${text}1/" $file
 fi
#restart icewm, to see the change:
 icewm -r
#Exit function:
return		
	}

doubleheight_toolbar()
{
file=$HOME/.icewm/prefoverride
text="TaskBarDoubleHeight="
#Check if string exists in  file, if it does not, add it and make sure it's set to 0 (its 1 be default):
if cat $file | grep ^$text; then
   # echo found, making sure its not commented out
    sed -i "/$text/s/^#//g" $file
else
   # echo not found
    echo ${text}0 >> $file
fi
#Toggle TaskBarShowCPUStatus (if it exists in prefoverride):
if grep -F  "${text}"1 "$file"; then
    sed -i "s/${text}.*/${text}0/" $file
elif grep -F  "${text}"0 "$file"; then
    sed -i "s/${text}.*/${text}1/" $file
 fi
#restart icewm, to see the change:
 icewm -r
#Exit function:
return		
	}
	
top_toolbar()
{
text="TaskBarAtTop="
file=$HOME/.icewm/prefoverride
#Check if string exists in  file, if it does not, add it and make sure it's set to 0 (its 1 be default):
if cat $file | grep ^$text; then
   # echo found, making sure its not commented out
    sed -i "/$text/s/^#//g" $file
else
   # echo not found
    echo ${text}0 >> $file
fi
#Toggle TaskBarShowCPUStatus (if it exists in prefoverride):
if grep -F  "${text}"1 "$file"; then
    sed -i "s/${text}.*/${text}0/" $file
elif grep -F  "${text}"0 "$file"; then
    sed -i "s/${text}.*/${text}1/" $file
 fi
#restart icewm, to see the change:
 icewm -r
#Exit function:
return		
	}
	
center_large_windows()
{
text="CenterLarge="
file=$HOME/.icewm/prefoverride
#Check if string exists in  file, if it does not, add it and make sure it's set to 0 (its 1 be default):
if cat $file | grep ^$text; then
   # echo found, making sure its not commented out
    sed -i "/$text/s/^#//g" $file
else
   # echo not found
    echo ${text}1 >> $file
fi
#Toggle TaskBarShowCPUStatus (if it exists in prefoverride):
if grep -F  "${text}"1 "$file"; then
    sed -i "s/${text}.*/${text}0/" $file
elif grep -F  "${text}"0 "$file"; then
    sed -i "s/${text}.*/${text}1/" $file
 fi
#restart icewm, to see the change:
 icewm -r
#Exit function:
return		
	}
	
ShowMoveSizeStatus()
{
text="ShowMoveSizeStatus="
file=$HOME/.icewm/prefoverride
#Check if string exists in  file, if it does not, add it and make sure it's set to 0 (its 1 be default):
if cat $file | grep ^$text; then
   # echo found, making sure its not commented out
    sed -i "/$text/s/^#//g" $file
else
   # echo not found
    echo ${text}0 >> $file
fi
#Toggle TaskBarShowCPUStatus (if it exists in prefoverride):
if grep -F  "${text}"1 "$file"; then
    sed -i "s/${text}.*/${text}0/" $file
elif grep -F  "${text}"0 "$file"; then
    sed -i "s/${text}.*/${text}1/" $file
 fi
#restart icewm, to see the change:
 icewm -r
#Exit function:
return		
	}
	
TaskBarShowWorkspaces()
{
text="TaskBarShowWorkspaces="
file=$HOME/.icewm/prefoverride
#Check if string exists in  file, if it does not, add it and make sure it's set to 0 (its 1 be default):
if cat $file | grep ^$text; then
   # echo found, making sure its not commented out
    sed -i "/$text/s/^#//g" $file
else
   # echo not found
    echo ${text}0 >> $file
fi
#Toggle TaskBarShowCPUStatus (if it exists in prefoverride):
if grep -F  "${text}"1 "$file"; then
    sed -i "s/${text}.*/${text}0/" $file
elif grep -F  "${text}"0 "$file"; then
    sed -i "s/${text}.*/${text}1/" $file
 fi
#restart icewm, to see the change:
 icewm -r
#Exit function:
return		
	}
		
TaskBarShowShowDesktopButton()
{
text="TaskBarShowShowDesktopButton="
file=$HOME/.icewm/prefoverride
#Check if string exists in  file, if it does not, add it and make sure it's set to 0 (its 1 be default):
if cat $file | grep ^$text; then
   # echo found, making sure its not commented out
    sed -i "/$text/s/^#//g" $file
else
   # echo not found
    echo ${text}0 >> $file
fi
#Toggle TaskBarShowCPUStatus (if it exists in prefoverride):
if grep -F  "${text}"1 "$file"; then
    sed -i "s/${text}.*/${text}0/" $file
elif grep -F  "${text}"0 "$file"; then
    sed -i "s/${text}.*/${text}1/" $file
 fi
#restart icewm, to see the change:
 icewm -r
#Exit function:
return		
	}	
	
TaskbarButtonWidthDivisor()
{
text="TaskbarButtonWidthDivisor="
file=$HOME/.icewm/prefoverride
#Toggle
if grep -F  "${text}" "$file"; then
    sed -i /$text/d $file
else
	echo TaskbarButtonWidthDivisor=20 >> $file
 fi
#restart icewm, to see the change:
 icewm -r
#Exit function:
return		
	}	
	
Select_Theme()
{
	#Clean up temporary file:
echo "" > /tmp/icewm_themes.list
current_theme=$(cat ~/.icewm/theme| head -n 1| cut -d '=' -f 2  | cut -d "\"" -f 2)
echo $current_theme

#list available icewm themes:
 find /usr/share/icewm/themes/*/default.theme > /tmp/icewm_themes.list
 find ~/.icewm/themes/*/default.theme >> /tmp/icewm_themes.list
 sort /tmp/icewm_themes.list >  /tmp/sorted_icewm_themes.list
 
 cat /tmp/sorted_icewm_themes.list
 
#Parse list:
echo "" > /tmp/icewm_themes.list
 #remove empty lines:
 sed -i '/^\s*$/d' /tmp/icewm_themes.list
while IFS= read -r line; do
  echo "$line"| cut -d '/' -f 6 >> /tmp/icewm_themes.list
done < /tmp/sorted_icewm_themes.list

#Select theme from list
selected_theme=$(yad --no-buttons --window-icon=/usr/share/pixmaps/numix-square/icewm.png --text="${current_theme_text}: $current_theme" --title="$themes_title" --width=600 --height=550 --center --separator=" " --list  --column="$select_theme_text"  < /tmp/icewm_themes.list)

#If a selection was not done, exit
if [ -z "$selected_theme" ]; then exit
fi

#locate file corresponding to the selected Theme name
x=$(echo $selected_theme)
selected_theme_file=$(grep "$x" /tmp/sorted_icewm_themes.list)

#make edition to the config file
echo Theme=\"$selected_theme_file\" > $HOME/.icewm/theme

#restart IceWM
icewm -r
	}	
	
ice_startup()
{
	local add_remove_main_button=$add_remove_main_button
####GUI script to manage IceWM startup (add/remove applications from the start of an OS that uses IceWM as Window Manager)
yad --title="${add_remove_main_button}" --window-icon=/usr/share/pixmaps/numix-square/icewm.png --height=400 --width=550 --center --text=$"\n $add_remove_text $HOME/.icewm/startup):" --button="$add_startup_appselect":1 --button="$add_startup_command":2 --button="$remove_startup":3 --text-info <   ~/.icewm/startup --show-uri --fontname="ubuntu 12"
### wait for a button to be pressed then perform the selected function
main_selection=$?

if [[ $main_selection -eq 1 ]]; then
 selected=$(app-select --select| cut -d '|' -f 5| tail -1)
 #If a selection was not done, exit
	if [ -z "$selected" ]; then exit
	fi
	
	if echo "$selected" | grep 'Overall:'; then  exit
	fi
	
  echo "$selected  &" >> ~/.icewm/startup
  # yad --title="${add_remove_main_button}"  --window-icon=/usr/share/pixmaps/numix-square/icewm.png --fixed --center --text="$add_startup_confirmation" --button=" x "
ice_startup
fi

if [[ $main_selection -eq 2 ]]; then
 selected=$(yad --window-icon=/usr/share/pixmaps/numix-square/icewm.png --title="$add_startup_command_title" --center --width=500 --text="$add_startup_command_text" --form --field ':CE') 
 
# Remove trailing | from the end of the selection:
 selected=${selected::-1}
 
#If a selection was not done, exit
	if [ -z "$selected" ]; then exit
	fi
 
#Check if command already includes "&" in the end, if not, add it
 end_of_content=$(echo $selected| awk 'NF>1{print $NF}')
  if [ $end_of_content = "&" ]; then
   result="command already ends in an &, doing nothing"
   else
   #command did not end in an &, adding it
   selected=$(echo $selected "&")
  fi
 
 echo "$selected" >> ~/.icewm/startup
# yad --title="${add_remove_main_button}"  --window-icon=/usr/share/pixmaps/numix-square/icewm.png --center --text="$add_startup_confirmation" --button=" x "
ice_startup
fi


if [[ $main_selection -eq 3 ]]; then
  #### remove an  entry to startup file:
 #List contents of startup file, removing first line (with /bin/bash) and also any commented line
 cat ~/.icewm/startup| grep -v "#\!/bin/bash" | grep -o '^[^#]*' > /tmp/startuplist
 #clean up temporary file
 echo "" > /tmp/good
 #allow file to be truncated (i.e. append to the end of the line, instead of into a new line)
 truncate -s-1 /tmp/good
 #cicle trough the temporary file's contents and create /temp/good with everything into the same line, separed by "!", so it ca be used by yad drop box
 while read -r line; do
    echo -n ${line}\!  >> /tmp/good
 done < /tmp/startuplist
 #Show yad selection window, so user select what entry will be removed
 selection=$(yad --center --title="$remove_startup"  --window-icon=/usr/share/pixmaps/numix-square/icewm.png --text="${remove_startup_text}\n" --form --field="${remove_button}:CB" < /tmp/good)

 # Remove trailing | from the end of the selection:
 selection=${selection::-1}
 
 #process only untiul the first "&"
 b=${selection%\&*}
 line_number=$(cat ~/.icewm/startup | fgrep -n "$b"| cut -d ':' -f 1 | head -n 1)

#If a selection was not done, exit
	if [ -z "$line_number" ]; then exit
	fi

 #Remove all entries with this contents from the startup file (it's missing the -i flag)
 sed -i "${line_number}d" ~/.icewm/startup
 #yad --title="$remove_startup"  --window-icon=/usr/share/pixmaps/numix-square/icewm.png --fixed --center --text="${remove_confirmation}" --button=" x "
 ice_startup
fi
	}	
	
send_to_desktop()
{
selected=$(app-select --select| cut -d '|' -f 1| tail -1)
 #If a selection was not done, exit
	if [ -z "$selected" ]; then exit
	fi
 cp "$selected"  /"$XDG_DESKTOP_DIR"/
	}		
		

TaskBarShowCollapseButton()
{
text="TaskBarShowCollapseButton="
file=$HOME/.icewm/prefoverride
#Check if string exists in  file, if it does not, add it and make sure it's set to 0 (its 1 be default):
if cat $file | grep ^$text; then
   # echo found, making sure its not commented out
    sed -i "/$text/s/^#//g" $file
else
   # echo not found
    echo TaskBarShowCollapseButton=0 >> $file
fi
#Toggle TaskBarShowCPUStaus (if it exists in prefoverride):
if grep -F  "${text}"1 "$file"; then
    sed -i "s/${text}.*/${text}0/" $file
elif grep -F  "${text}"0 "$file"; then
    sed -i "s/${text}.*/${text}1/" $file
 fi
#restart icewm, to see the change:
 icewm -r
#Exit function:
return		
	}

NetStatusShowOnlyRunning()
{
text="NetStatusShowOnlyRunning="
file=$HOME/.icewm/prefoverride
#Check if string exists in  file, if it does not, add it and make sure it's set to 0 (its 1 be default):
if cat $file | grep ^$text; then
   # echo found, making sure its not commented out
    sed -i "/$text/s/^#//g" $file
else
   # echo not found
    echo NetStatusShowOnlyRunning=0 >> $file
fi
#Toggle TaskBarShowCPUStaus (if it exists in prefoverride):
if grep -F  "${text}"1 "$file"; then
    sed -i "s/${text}.*/${text}0/" $file
elif grep -F  "${text}"0 "$file"; then
    sed -i "s/${text}.*/${text}1/" $file
 fi
#restart icewm, to see the change:
 icewm -r
#Exit function:
return		
	}

wttr()
{
	
cat > "$HOME/.icewm/antix-weather.sh" << 'FILE_TEMPLATE'
#!/bin/bash
geoip="$(wget -O- -q http://geoip.ubuntu.com/lookup)"
area="$(sed -r 's/.*<RegionName>(.*?)<\/RegionName>.*/\1/g' <<< $geoip)"
corrected_area=$(echo "${area// /_}")
 langu=$(locale | grep LANG | cut -d= -f2 | cut -d. -f1)
l1=$(echo $langu |cut -d_ -f1)
WINID=$(wmctrl -lx | grep 'Wtrr.in' | awk 'NR==1{print $1}')
if [ $WINID ]; then  wmctrl -ia $WINID & else roxterm --hide-menubar --title "Wtrr.in" --zoom=0,85 --geometry 130x40 -e bash -c "curl 'http://wttr.in/$corrected_area?lang=$l1'; read -N1;" & fi

FILE_TEMPLATE

file=$HOME/.icewm/toolbar
if cat $file | grep antix-weather.sh; then
   # echo found, remove line
   sed -i "/antix-weather.sh/d" $file
   else
   # echo not found, add line
   echo "prog \"Wttr.in\" /usr/share/icons/papirus-antix/24x24/apps/org.gnome.Weather.png bash $HOME/.icewm/antix-weather.sh"  >> $file
fi
#restart icewm, to see the change:
 icewm -r
#Exit function:
return		

}

show_personal_submenu()
{
#Script to Toggle on/off the "personal menu" submenu on icewm's main menu
file=$HOME/.icewm/menu
line_content=$(grep -Fiw menufile <$file | grep -Fiw personal | grep -Fiw preferences-desktop-user.png)
line_number=$(grep -Fiwn menufile <$file | grep -Fiw personal | grep -Fiw preferences-desktop-user.png|cut -d: -f1)
first_character_in_line=${line_content:0:1}
	if [ "$first_character_in_line" == "#" ]; then #line is commented out already. Uncommententing it
		sed -i '/preferences-desktop-user.png personal/ s/^#//' $file
			else # line exists  and it is not commented, commenting it
			sed -i  "$line_number"' s/^/#/' "$file"
	fi
 #Exit function:
return			
}

show_personal_menu_entries_on_first_layer_of_menu()
{
#Script to Toggle on/off the "personal menu" submenu on icewm's main menu
file=$HOME/.icewm/menu
string="include personal"
line=2
if grep -Fiw "include personal" <$file ; then
  echo found entry, removing it...
  sed -i "/$string/d" $file
else
echo not entry found, adding it...
sed -i "$line i include personal" $file
fi
 #Exit function:
return			
}

Show_run_menu_entry()
{
text="ShowRun="
file=$HOME/.icewm/prefoverride
#Check if string exists in  file, if it does not, add it and make sure it's set to 0 (its 1 be default):
if cat $file | grep ^$text; then
   # echo found, making sure its not commented out
    sed -i "/$text/s/^#//g" $file
else
   # echo not found
    echo ShowRun=0 >> $file
fi
#Toggle TaskBarShowCPUStaus (if it exists in prefoverride):
if grep -F  "${text}"1 "$file"; then
    sed -i "s/${text}.*/${text}0/" $file
elif grep -F  "${text}"0 "$file"; then
    sed -i "s/${text}.*/${text}1/" $file
 fi
#restart icewm, to see the change:
 icewm -r
#Exit function:
return		
	}

Show_preferences_submenu()
{
fulltexton="ShowSettingsMenu=1"
text="ShowSettingsMenu="
file=$HOME/.icewm/preferences
#Check if string exists in  file, if it does not, add it and make sure it's set to 0 (its 1 be default):
if cat $file | grep ^$fulltexton; then
    #echo text found, that means the preferences submenu is on, turning it off:
	sed -i "s/ShowSettingsMenu=1/ShowSettingsMenu=0/g" $file
	sed -i "s/ShowFocusModeMenu=1/ShowFocusModeMenu=0/g" $file
	sed -i "s/ShowThemesMenu=1/ShowThemesMenu=0/g" $file
     #restart icewm, to see the change:
	icewm -r
  else
    #echo not found, that means the preferences submenu is off, turning it on:
	sed -i "s/ShowSettingsMenu=0/ShowSettingsMenu=1/g" $file
	sed -i "s/ShowFocusModeMenu=0/ShowFocusModeMenu=1/g" $file
	sed -i "s/ShowThemesMenu=0/ShowThemesMenu=1/g" $file
	#restart icewm, to see the change:
	icewm -r
fi
#Exit function:
return		
	}
		
show_xkill()
{
#Script to Toggle on/off the "personal menu" submenu on icewm's main menu
file=$HOME/.icewm/menu
string="xkill"
#Check if string exists in  file, if it does not, add it and make sure it's set to 0 (its 1 be default):
if cat $file | grep xkill | grep \#; then
    echo found and it is commented, making sure its not commented out
    line_number=$(cat $file | grep -n prog | grep -n xkill | cut -d ':' -f 1 | head -n 1)
    #uncomment all lines with the text xkill (that can be dangerous, if xkill is contained on a comment, for example)
    sed -i "/xkill/ s/^#//" $file
else
   echo not commented, commenting it
   #comment out line with string- it can be superflous if xkill is contained on a comment, for example:
   sed -i '/xkill/s/^/#/g' $file
  # file=$HOME/.icewm/menu
  # line_number=$(cat $file | grep -n prog | grep -n xkill | cut -d ':' -f 1 | head -n 1)
  # sed -i "${line_number}s/./#&/" $file
fi
 #Note: there's no need to restart icewm to see the change. The menu is updated by icewm automatically, on the fly
 #Exit function:
return			
}		
		
#Export created functions, so they can be used in the GUI:
export -f toogle_system_info_square_on_system_tray toogle_RAM_info_square_on_system_tray toogle_Network_info_square_on_system_tray toggle_seconds toggle12h24h toggle_clock_LED icon_on_title_bar toggle_clock autohide_toolbar doubleheight_toolbar top_toolbar center_large_windows ShowMoveSizeStatus TaskBarShowShowDesktopButton TaskbarButtonWidthDivisor Select_Theme ice_startup TaskBarShowWorkspaces send_to_desktop TaskBarShowCollapseButton NetStatusShowOnlyRunning wttr show_personal_submenu show_personal_menu_entries_on_first_layer_of_menu Show_run_menu_entry Show_preferences_submenu show_xkill



#Main window:
section_title_color="green" # white green red blue grey dark... light...
yad --form --title="$main_window_title"  --window-icon=/usr/share/pixmaps/numix-square/icewm.png --width=900 --height=650 --center --columns=2 --borders=10\
    --text="$main_window_text"  --align=center --align-buttons  --scroll --homogeneous --maximized\
    --field=$"<b>* ${clock_field}:</b>":LBL '' \
        --field="$clock_on_off !!":FBTN "bash -c toggle_clock"  --align-buttons \
		--field="$clock_12_24h !!":FBTN "bash -c toggle12h24h" \
		--field="$clock_seconds !!":FBTN "bash -c toggle_seconds" \
		--field="$reset_text !!":FBTN "bash -c 'sed -i '/^TimeFormat=/d' ~/.icewm/prefoverride &&  icewm -r'" \
		--field="$clock_LED !!":FBTN "bash -c toggle_clock_LED" \
			--field="${change_time_date}!!":FBTN "bash -c  set_time-and_date.sh" \
	--field="<b>* ${sys_info_field}: </b>":LBL '1' \
		--field="$sys_net !!":FBTN "bash -c toogle_Network_info_square_on_system_tray" \
			--field="$show_only_used_network_devices!!":FBTN "bash -c NetStatusShowOnlyRunning" \
		--field="$sys_ram !!":FBTN "bash -c toogle_RAM_info_square_on_system_tray" \
		--field="$sys_cpu !!":FBTN "bash -c toogle_system_info_square_on_system_tray" \
	--field=$"<b>* ${window_managment_field}: </b>":LBL '2' \
		--field="$title_icon !!":FBTN "bash -c icon_on_title_bar" \
		--field="$center_win !!":FBTN "bash -c center_large_windows" \
		--field="$moving_osd !!":FBTN "bash -c ShowMoveSizeStatus" \
		--field="$remember_win !!":FBTN "bash -c 'icewm-remember-settings'" \
	--field=$"<b>* ${startup_field}: </b>":LBL '5' \
		--field=$"${add_remove_main_button}!!":FBTN "bash -c ice_startup" \
	--field=$"<b>* ${toolbar_settings_field}: </b>":LBL '4' \
		--field="${auto_hide}!!":FBTN "bash -c autohide_toolbar" \
		--field="${double_hight}!!":FBTN "bash -c doubleheight_toolbar" \
		--field="${top_bottom}!!":FBTN "bash -c top_toolbar" \
		--field="${names_on_toolbar}!!":FBTN "bash -c TaskbarButtonWidthDivisor" \
		--field="${tim}!!":FBTN "bash -c 'icewm-toolbar-icon-manager.sh || icewm-toolbar-icon-manager'" \
		--field="${show_desktop}!!":FBTN "bash -c TaskBarShowShowDesktopButton" \
		--field="${workspace_toggle}!!":FBTN "bash -c TaskBarShowWorkspaces" \
		--field="${workspace_manager}!!":FBTN "bash -c 'antiX-workspace-manager'" \
			--field="$collapse!!":FBTN "bash -c TaskBarShowCollapseButton" \
			--field="$weather!!":FBTN "bash -c wttr" \
	--field="<b>* ${menu_field} </b>":LBL '5' \
		--field="${personal_menu_manager}!!":FBTN "bash -c 'icewm-quick-personal-menu-manager.sh || icewm-quick-personal-menu-manager'" \
			--field="${personal_menu_toggle}!!":FBTN "bash -c 'show_personal_submenu'" \
			--field="${personal_entries_on_the_first_layer}!!":FBTN "bash -c 'show_personal_menu_entries_on_first_layer_of_menu'" \
			--field="${show_xkill}!!":FBTN "bash -c 'show_xkill'" \
			--field="${run_menu_entry}!!":FBTN "bash -c 'Show_run_menu_entry'" \
			--field="${show_icewm_preferences_menu}!!":FBTN "bash -c 'Show_preferences_submenu'" \
		--field=$"<b>* ${look_feel} </b>":LBL '6' \
		--field="${wallpaper}!!":FBTN "bash -c wallpaper" \
		--field="${appearance}!!":FBTN "bash -c  lxappearance" \
		--field="${select_theme}!!":FBTN "bash -c  Select_Theme" \
		--field="${conky}!!":FBTN "bash -c  conkytoggle.sh" \
		--field="${keyboard_shortcuts}!!":FBTN "bash -c  add-key" \
		--field="${add_to_desktop}!!":FBTN "bash -c  send_to_desktop" \
	--button="$manualedit":"bash -c  'geany $HOME/.icewm/prefoverride $HOME/.icewm/winoptions $HOME/.icewm/preferences $HOME/.icewm/keys $HOME/.icewm/startup $HOME/.icewm/toolbar $HOME/.icewm/menu'" 
#--field=$" ":LBL '40' \
