#!/bin/bash
# choose fonts for individual tint2 details, for use with FT10 transformation Pack for antiX Linux
#by PPC, 1/1/2022, GPL license
        TEXTDOMAINDIR=/usr/share/locale
        TEXTDOMAIN=tint2_fonts

main-font ()
{
FONTE_ATUAL=$(egrep "^task_font =" ~/.config/tint2/tint2rc | cut -d'=' -f2)

while NOVA_FONTE=$( yad --window-icon="/usr/share/icons/antix-numix-bevel/fonts.png" --center --font --title=$"Toolbar and Menu's Font" --fontname="$FONTE_ATUAL"\
					--button='X':1 --button='OK':0)
do
	sed -i "/^task_font =/s/$FONTE_ATUAL/ $NOVA_FONTE/g" ~/.config/tint2/tint2rc
	# reiniciar o tint2
	killall -9 tint2
	tint2 &
	FONTE_ATUAL=$(egrep "^task_font =" ~/.config/tint2/tint2rc | cut -d'=' -f2)
done
}

cpu-ram-font ()
{
	FONTE_ATUAL=$(egrep "^execp_font =" ~/.config/tint2/tint2rc | cut -d'=' -f2| head -n 1)

while NOVA_FONTE=$( yad --window-icon="/usr/share/icons/antix-numix-bevel/fonts.png" --center --font --title=$"CPU and RAM indicator's Font" --fontname="$FONTE_ATUAL"\
					--button='X':1 --button='OK':0)
do
	sed -i "/^execp_font =/s/$FONTE_ATUAL/ $NOVA_FONTE/g" ~/.config/tint2/tint2rc
	# reiniciar o tint2
	killall -9 tint2
	tint2 &
	FONTE_ATUAL=$(egrep "^execp_font =" ~/.config/tint2/tint2rc | cut -d'=' -f2| head -n 1)
done
	}

clock-font ()
{
	FONTE_ATUAL=$(egrep "^time1_font =" ~/.config/tint2/tint2rc | cut -d'=' -f2| head -n 1)

while NOVA_FONTE=$( yad --window-icon="/usr/share/icons/antix-numix-bevel/fonts.png" --center --font --title=$"Clock's Font" --fontname="$FONTE_ATUAL"\
					--button='X':1 --button='OK':0)
do
	sed -i "/^time1_font =/s/$FONTE_ATUAL/ $NOVA_FONTE/g" ~/.config/tint2/tint2rc
	# reiniciar o tint2
	killall -9 tint2
	tint2 &
	FONTE_ATUAL=$(egrep "^time1_font =" ~/.config/tint2/tint2rc | cut -d'=' -f2| head -n 1)
done
}

date-font ()
{
	FONTE_ATUAL=$(egrep "^time2_font =" ~/.config/tint2/tint2rc | cut -d'=' -f2| head -n 1)

while NOVA_FONTE=$( yad --window-icon="/usr/share/icons/antix-numix-bevel/fonts.png" --center --font --title=$"Date's Font" --fontname="$FONTE_ATUAL"\
					--button='X':1 --button='OK':0)
do
	sed -i "/^time2_font =/s/$FONTE_ATUAL/ $NOVA_FONTE/g" ~/.config/tint2/tint2rc
	# reiniciar o tint2
	killall -9 tint2
	tint2 &
	FONTE_ATUAL=$(egrep "^time2_font =" ~/.config/tint2/tint2rc | cut -d'=' -f2| head -n 1)
done
}

export -f main-font cpu-ram-font clock-font date-font

yad --title $"Configure FT10 fonts" --window-icon="/usr/share/icons/antix-numix-bevel/fonts.png" --no-buttons --width=450 --height=300  --center --text-align=center --text="" --form --field $"Menu and toolbar:btn" --field $"CPU and RAM usage indicator:btn" --field $"Clock:btn" --field $"Date in clock:btn" \
    "bash -c main-font" "bash -c cpu-ram-font" "bash -c clock-font" "bash -c date-font"
    
