#!/bin/bash

if [ "$(id -u)" -gt 0 ]; then
	echo "You need to run as root or using sudo"
	exit 1
fi

if [ ! -e /etc/default/grub ] | [ ! -e /etc/grub.d/10_linux ]; then
	echo "GRUB is either not installed or configured in a non-standard manner - The script will abort without making changes"
	exit 1
fi

if [ ! -e /usr/share/grub-init-diversity/original/grub.original ]; then
	echo "backing-up original '/etc/default/grub' config file"
	cat /etc/default/grub > /usr/share/grub-init-diversity/original/grub.original
fi

if [ ! -e /usr/share/grub-init-diversity/original/10_linux.original ]; then
	echo "backing-up original '/etc/grub.d/10_linux' config file"
	cat /etc/grub.d/10_linux > /usr/share/grub-init-diversity/original/10_linux.original
fi

if [ -e /usr/share/grub-init-diversity/original/grub.original ] && [ -e /usr/share/grub-init-diversity/original/10_linux.original ];then
	echo "making changes to the '/etc/default/grub' config file"
	cat /usr/share/grub-init-diversity/original/grub.original | sed "s/GRUB_DEFAULT=0/#GRUB_DEFAULT=0 			#Commented by 'grub-init-diversity' script/g" > /etc/default/grub
	echo "
# Added by 'grub-init-diversity' script
GRUB_DEFAULT=saved
GRUB_SAVEDEFAULT=true
GRUB_DISABLE_SUBMENU=y
	" >> /etc/default/grub
	
	echo "making changes to the '/etc/grub.d/10_linux' config file"
	cat /usr/share/grub-init-diversity/original/10_linux.original | sed -e '/#SUPPORTED_INITS="sysvinit:/d' -e '/SUPPORTED_INITS="sysvinit:/c\SUPPORTED_INITS="sysvinit:/lib/sysvinit/init systemd:/lib/systemd/systemd upstart:/sbin/upstart s6-rc:/lib/s6-rc/s6-rc-init s6-66:/lib/s6-66/s6-66-init openrc:/lib/openrc/openrc-init runit:/lib/runit/runit-init dinit:/lib/dinit/dinit"' > /etc/grub.d/10_linux
fi

## Updating antiX-MX live grub configuration
if [ -e /usr/local/share/live-files/general-files/etc/default/grub ] && [ -e /usr/local/share/live-files/files/etc/grub.d/10_linux ]; then
	echo "found antiX-MX live remastering GRUB configuration - updating for init-diversity"
	echo "backing-up original '/usr/local/share/live-files/general-files/etc/default/grub' config file"
	cat /usr/local/share/live-files/general-files/etc/default/grub > /usr/share/grub-init-diversity/original/grub.live.antix-mx.original
	echo "backing-up original '/usr/local/share/live-files/files/etc/grub.d/10_linux' config file"
	cat /usr/local/share/live-files/files/etc/grub.d/10_linux > /usr/share/grub-init-diversity/original/10_linux.live.antix-mx.original
	echo "making changes to the '/usr/local/share/live-files/general-files/etc/default/grub' config file"
	cat /usr/share/grub-init-diversity/original/grub.live.antix-mx.original | sed "s/GRUB_DEFAULT=0/#GRUB_DEFAULT=0 			#Commented by 'grub-init-diversity' script/g" > /usr/local/share/live-files/general-files/etc/default/grub
	echo "
# Added by 'grub-init-diversity' script
GRUB_DEFAULT=saved
GRUB_SAVEDEFAULT=true
GRUB_DISABLE_SUBMENU=y
	" >> /usr/local/share/live-files/general-files/etc/default/grub
	echo "making changes to the '/usr/local/share/live-files/files/etc/grub.d/10_linux' config file"
	cat /usr/share/grub-init-diversity/original/10_linux.original | sed -e '/#SUPPORTED_INITS="sysvinit:/d' -e '/SUPPORTED_INITS="sysvinit:/c\SUPPORTED_INITS="sysvinit:/lib/sysvinit/init systemd:/lib/systemd/systemd upstart:/sbin/upstart s6-rc:/lib/s6-rc/s6-rc-init s6-66:/lib/s6-66/s6-66-init openrc:/lib/openrc/openrc-init runit:/lib/runit/runit-init dinit:/lib/dinit/dinit"' > /usr/local/share/live-files/files/etc/grub.d/10_linux
fi
	echo 

update-grub
