#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 xmobar
version:              0.50
visibility:           public
id:                   xmobar-0.50-KdEUEuMP2jdJ1HmWmVI5VB
key:                  xmobar-0.50-KdEUEuMP2jdJ1HmWmVI5VB
license:              BSD-3-Clause
maintainer:           Jose A. Ortega Ruiz <jao@gnu.org>
author:               Andrea Rossato and Jose A. Ortega Ruiz
homepage:             https://codeberg.org/xmobar/xmobar
synopsis:             A Minimalistic Text Based Status Bar
description:
    Xmobar is a minimalistic text based status bar.

    Inspired by the Ion3 status bar, it supports similar
    features, like dynamic color management, output templates,
    and extensibility through plugins.

category:             System
abi:                  3fc3dd5ac44bba44cbafb0cfa7da5485
exposed:              True
exposed-modules:
    Xmobar Xmobar.Plugins.Accordion Xmobar.Plugins.Monitors.Common
    Xmobar.Plugins.Monitors.Common.Run
    Xmobar.Plugins.Monitors.Common.Types Xmobar.Plugins.Monitors.Cpu

hidden-modules:
    Paths_xmobar Xmobar.Config.Types Xmobar.Config.Parse
    Xmobar.Config.Template Xmobar.Run.Types Xmobar.Run.Timer
    Xmobar.Run.Template Xmobar.Run.Exec Xmobar.Run.Runnable
    Xmobar.Run.Actions Xmobar.Run.Loop Xmobar.Draw.Boxes
    Xmobar.Draw.Cairo Xmobar.Draw.Types Xmobar.App.Config
    Xmobar.App.Main Xmobar.App.Opts Xmobar.App.Compile
    Xmobar.System.Utils Xmobar.System.StatFS Xmobar.System.Environment
    Xmobar.System.Localize Xmobar.System.Signal Xmobar.System.Kbd
    Xmobar.Text.Ansi Xmobar.Text.Loop Xmobar.Text.Pango
    Xmobar.Text.Swaybar Xmobar.Text.SwaybarClicks Xmobar.Text.Output
    Xmobar.X11.Bitmap Xmobar.X11.CairoSurface Xmobar.X11.ColorCache
    Xmobar.X11.Draw Xmobar.X11.Events Xmobar.X11.Loop Xmobar.X11.Text
    Xmobar.X11.Types Xmobar.X11.Window Xmobar.Plugins.ArchUpdates
    Xmobar.Plugins.Command Xmobar.Plugins.BufferedPipeReader
    Xmobar.Plugins.CommandReader Xmobar.Plugins.Date
    Xmobar.Plugins.EWMH Xmobar.Plugins.HandleReader
    Xmobar.Plugins.QueueReader Xmobar.Plugins.PacmanUpdates
    Xmobar.Plugins.PipeReader Xmobar.Plugins.MarqueePipeReader
    Xmobar.Plugins.StdinReader Xmobar.Plugins.XMonadLog
    Xmobar.Plugins.Kbd Xmobar.Plugins.Locks Xmobar.Plugins.NotmuchMail
    Xmobar.Plugins.Monitors Xmobar.Plugins.Monitors.Batt
    Xmobar.Plugins.Monitors.Batt.Common
    Xmobar.Plugins.Monitors.Common.Output
    Xmobar.Plugins.Monitors.Common.Parsers
    Xmobar.Plugins.Monitors.Common.Files
    Xmobar.Plugins.Monitors.CoreTemp Xmobar.Plugins.Monitors.K10Temp
    Xmobar.Plugins.Monitors.Cpu.Common Xmobar.Plugins.Monitors.CpuFreq
    Xmobar.Plugins.Monitors.Disk Xmobar.Plugins.Monitors.Disk.Common
    Xmobar.Plugins.Monitors.Load Xmobar.Plugins.Monitors.Load.Common
    Xmobar.Plugins.Monitors.Mem Xmobar.Plugins.Monitors.MultiCoreTemp
    Xmobar.Plugins.Monitors.MultiCpu Xmobar.Plugins.Monitors.Net
    Xmobar.Plugins.Monitors.Net.Common Xmobar.Plugins.Monitors.Swap
    Xmobar.Plugins.Monitors.Thermal Xmobar.Plugins.Monitors.ThermalZone
    Xmobar.Plugins.Monitors.Top Xmobar.Plugins.Monitors.Top.Common
    Xmobar.Plugins.Monitors.Uptime Xmobar.Plugins.Monitors.Bright
    Xmobar.Plugins.Monitors.CatInt Xmobar.X11.XRender
    Xmobar.Plugins.Mail Xmobar.Plugins.MBox
    Xmobar.Plugins.Monitors.Wireless Xmobar.Plugins.Monitors.MPD
    Xmobar.Plugins.Monitors.Volume Xmobar.Plugins.Monitors.Alsa
    Xmobar.Plugins.DateZone Xmobar.Plugins.Monitors.Mpris
    Xmobar.System.DBus Xmobar.X11.XPMFile
    Xmobar.Plugins.Monitors.Weather Xmobar.Plugins.Monitors.Batt.Linux
    Xmobar.Plugins.Monitors.Cpu.Linux
    Xmobar.Plugins.Monitors.Disk.Linux
    Xmobar.Plugins.Monitors.Load.Linux
    Xmobar.Plugins.Monitors.Mem.Linux Xmobar.Plugins.Monitors.Net.Linux
    Xmobar.Plugins.Monitors.Swap.Linux
    Xmobar.Plugins.Monitors.Top.Linux
    Xmobar.Plugins.Monitors.Uptime.Linux

import-dirs:          /usr/lib/ghc-9.4.8/site-local/xmobar-0.50
library-dirs:         /usr/lib/ghc-9.4.8/site-local/xmobar-0.50
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/xmobar-0.50
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.4.8/xmobar-0.50
hs-libraries:         HSxmobar-0.50-KdEUEuMP2jdJ1HmWmVI5VB
extra-libraries:      Xrandr Xrender Xpm
depends:
    X11-1.10.3-1fch9sEthm2E7hyJAmNZGG
    X11-xft-0.3.4-7EOEODn6h0FJtsC0jDGIEN
    aeson-2.1.2.1-LDc25PpdH5WHlLB8Mcp2Rh
    alsa-core-0.5.0.1-JLPmRcHiZRx1HOkmXNRClE
    alsa-mixer-0.3.0.1-64d7bL5FCNwLOsX9HNe40u
    async-2.2.5-3On0Vdlc3urBKBpRPAboKf base-4.17.2.1
    bytestring-0.11.5.3 cairo-0.13.11.0-8p1gj7cpTx252PbxcrySBl
    cereal-0.5.8.3-H9MXf6i1TMkEAfnsx4oYbT
    colour-2.3.6-FTsVzFO6Wyw8llPA3Znwfg containers-0.6.7
    dbus-1.3.3-6MX7GlJrcW6D0V0iAYWOVf directory-1.3.7.1
    extensible-exceptions-0.1.1.4-AGheGT2ZUDiCzp52FHEfjQ
    extra-1.7.16-EVqIvjfjup2KjWh1SyzBng filepath-1.4.2.2
    hinotify-0.4.2-8A1dSQxRdzP3XgH6XktXiz
    http-client-tls-0.3.6.4-7DkM39Tk1JBGY5QMDEdKA0
    http-conduit-2.3.9.1-H6NXeShDOM53I77DK4Tqij
    http-types-0.12.4-AKSPjJIqePQLPw819bUb23
    libmpd-0.10.0.1-BQE09E3WSUk2ITzThHOALU mtl-2.2.2
    netlink-1.1.1.0-EtwuQcOdMkCK92FWbMUZBF
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    pango-0.13.11.0-BeoU4VzZu7mDvuj3KyrBj9 parsec-3.1.16.1
    parsec-numbers-0.1.0-IKvzIVbeZPOFD4DHi1QStS process-1.6.18.0
    regex-compat-0.95.2.2-XQpODnagAHFJ9GlOSqau8 stm-2.5.1.0 time-1.12.2
    timezone-olson-0.2.1-BTp5R7q1AJdEnV7pV8RSLq
    timezone-series-0.1.13-21o0dMYZobR86i3h6j9FWj transformers-0.5.6.2
    unix-2.7.3 utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15

haddock-interfaces:
    /usr/share/doc/x86_64-linux-ghc-9.4.8/xmobar-0.50/html/xmobar.haddock

haddock-html:         /usr/share/doc/x86_64-linux-ghc-9.4.8/xmobar-0.50/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

