/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkStatisticsImageFilter_h
#define sitkStatisticsImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class StatisticsImageFilter
\brief Compute min, max, variance and mean of an Image .

StatisticsImageFilter computes the minimum, maximum, sum, sum of squares, mean, variance sigma of an image. The filter needs all of its input image. It behaves as a filter with an input and output. Thus it can be inserted in a pipeline with other filters and the statistics will only be recomputed if a downstream filter changes.

This filter is automatically multi-threaded and can stream its input when NumberOfStreamDivisions is set to more than one. Statistics are independently computed for each streamed and threaded region then merged.

Internally a compensated summation algorithm is used for the accumulation of intensities to improve accuracy for large images.

\sa itk::StatisticsImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT StatisticsImageFilter : public ImageFilter {
    public:
      using Self = StatisticsImageFilter;

      /** Destructor */
      virtual ~StatisticsImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      StatisticsImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;

     /**
      * Return the computed Minimum.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     double GetMinimum() const { return this->m_Minimum; };

     /**
      * Return the computed Maximum.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     double GetMaximum() const { return this->m_Maximum; };

     /**
      * Return the computed Mean.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     double GetMean() const { return this->m_Mean; };

     /**
      * Return the computed Standard Deviation.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     double GetSigma() const { return this->m_Sigma; };

     /**
      * Return the computed Variance.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     double GetVariance() const { return this->m_Variance; };

     /**
      * Return the compute Sum.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     double GetSum() const { return this->m_Sum; };


      /** Name of this class */
      std::string GetName() const { return std::string ("StatisticsImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      void Execute ( const Image & image );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = void (Self::*)( const Image * image );
      template <class TImageType> void ExecuteInternal ( const Image * image );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /* Docs */
      double m_Minimum{0.0};
      /* Docs */
      double m_Maximum{0.0};
      /* Docs */
      double m_Mean{0.0};
      /* Docs */
      double m_Sigma{0.0};
      /* Docs */
      double m_Variance{0.0};
      /* Docs */
      double m_Sum{0.0};


    };


}
#endif
