#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-DozJd6s1m7mJVSIS5QfdXF
key:                  postgrest-10.0.0-DozJd6s1m7mJVSIS5QfdXF
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  213856ab38e03e1fee3b7a882aac1782
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-DozJd6s1m7mJVSIS5QfdXF
depends:
    HTTP-4000.4.1-3BKWylAoIulCWc1PZ3yKLf
    Ranged-sets-0.5.0-2qnAhbcxwSF4bOCzgRVcCj
    aeson-2.1.2.1-8PRfz0Kg6mwK2TOn7o5BkY
    auto-update-0.1.6-6p9WtkRlBuKIzMPB6rfz9b base-4.17.2.1
    base64-bytestring-1.2.1.0-3xTWh9pwP9a781vByOHbcb
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-5qBt9JHinkAC9eq4HZukmL
    cassava-0.5.4.0-9WBeRaIMqCIdf1QZnjRxY
    configurator-pg-0.2.10-5RNoA8JiU6D7eJ3NvoYdAr containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-GZOZqzUDn152OuhEYvht8s directory-1.3.7.1
    either-5.0.3-6YhoCpctKpCIYHZXObBGFo
    gitrev-1.3.1-A894QJs696v2EtFduMnCKp
    hasql-1.5.0.5-15nW3CSpiMADsfx1zsZ5OZ
    hasql-dynamic-statements-0.3.1.1-CPbnViR90IgIPbdUII4QRS
    hasql-notifications-0.2.0.5-7XU5UpTH0NZHQ2jrlq7bG
    hasql-pool-0.5.2.2-IO9X6LX7fpn7zzaZxk2iYC
    hasql-transaction-1.0.1.1-kdpHSBTvJsAGRaIbE8p5X
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-LjVNkNK1odX2A9i2Pb0dvD
    insert-ordered-containers-0.2.5.3-ChPeyTwNAbm5TQw3IMLp13
    interpolatedstring-perl6-1.0.2-77O6u7ID6LWGup2Bfy4gUu
    jose-0.10-Dn7Db4hf0Mn2ljeUxMubim lens-5.3.1-2DX9LGrXssTCTVwrYJIT9U
    lens-aeson-1.2.3-9vbNNujLvg4EP2OIjenOBG mtl-2.2.2
    network-3.1.4.0-KmVGd8MQrab5lGMy9eMLcZ
    network-uri-2.6.4.2-KCWNlmsAWh8C1z4az19KdT
    optparse-applicative-0.18.1.0-HXqK0jqM8QFKV9KXEnSs2h
    parsec-3.1.16.1 protolude-0.3.5-16yldWNWK0Y6xL0ZnPh3iY
    regex-tdfa-1.3.2.4-JO7YM3YKT70AKRnIA3I8ji
    retry-0.9.3.1-3oaSTMBi5XY9d9qmyArNfa
    scientific-0.3.8.0-EXhuQ5hLYhTAI3vGh5jV7S
    swagger2-2.8.10-B69XLMz7YNo3iV9FNIbdJS text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-8Q4WKXtMGLf6eJrIPiNhPJ
    vault-0.3.1.5-JWFH5uVYj1g2AV12B7kmv5
    vector-0.13.2.0-CUNHeeGRzA0LijhekAuhMC
    wai-3.2.4-JYES4h2pzGv7ciJ8Xc4lzy
    wai-cors-0.2.7-IgaG4bWiSTrD1ECAaMGg6t
    wai-extra-3.1.17-5emoYZ3ehHQ79dkWHgvuDI
    wai-logger-2.5.0-1shugMQFILSJQM99T2XUdJ
    warp-3.3.30-1d6vGs6WRyG5v9ZRSP283B

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

