#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-Ln1N1Vt8Ftl1NODVePO1Z
key:                  postgrest-10.0.0-Ln1N1Vt8Ftl1NODVePO1Z
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  24d97230750d2385f201d1821fe4934c
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-Ln1N1Vt8Ftl1NODVePO1Z
depends:
    HTTP-4000.4.1-8eWOBVuGRcwFzWqphjtg9S
    Ranged-sets-0.5.0-9TvSmgPjv3EEujl28HSQHH
    aeson-2.1.2.1-FurzwiqHIOZ8NUBnR3RWtD
    auto-update-0.1.6-IPReOllVJUUEXDbKduBovj base-4.17.2.1
    base64-bytestring-1.2.1.0-L7UKPnwJMRGuk8q2bdjAR bytestring-0.11.5.3
    case-insensitive-1.2.1.0-4gOYP47XUTf2S4ZStIaMwN
    cassava-0.5.4.0-391lkqfzPfs7pPMPjoIcy7
    configurator-pg-0.2.10-J3eBuIDNbuBEpU2Pe087E0 containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-GZOZqzUDn152OuhEYvht8s directory-1.3.7.1
    either-5.0.3-4PnIfFw6dvu3zYJXsq2Evv
    gitrev-1.3.1-A894QJs696v2EtFduMnCKp
    hasql-1.5.0.5-5rTKcu2cQNFGB5C16XcIkr
    hasql-dynamic-statements-0.3.1.1-JsZUUwuPwzmQxIwFjTAQ6
    hasql-notifications-0.2.0.5-5sRloaDnb6oHc31Y59tif
    hasql-pool-0.5.2.2-GBF72JFeDPA724Td4rMaB0
    hasql-transaction-1.0.1.1-JtzMCiZTqkVBLD0QYHXxMe
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-GK6adOlCgtYAucedrAKKtY
    insert-ordered-containers-0.2.5.3-AKAxmeM4CY6IHW9JvpdJUz
    interpolatedstring-perl6-1.0.2-9d8NWZ10Xpw6sV0CF3Zbj7
    jose-0.10-79m42vld0ig7FPdUXwr9i9 lens-5.3.1-3xUapfELCfEGdnQj2vbjr4
    lens-aeson-1.2.3-BW1mcU1f11q567dd3xDW0F mtl-2.2.2
    network-3.1.4.0-Lt9YSaQDSdWKRzslp3ePNQ
    network-uri-2.6.4.2-DUv5vSA1kyG9zefYf8rGu8
    optparse-applicative-0.18.1.0-AciOqB5cZ6TCe3A10FCF62
    parsec-3.1.16.1 protolude-0.3.5-5kSe9d6DoazLvyNJNWqsRh
    regex-tdfa-1.3.2.4-GBJv531HDPIL53gZ8aHH9h
    retry-0.9.3.1-ITCygoa8KUID6QKqbOm6c3
    scientific-0.3.8.0-FY8DXpomWvN257bBgIbNZf
    swagger2-2.8.10-JiyhWd6mVaCDcgukdCh3s9 text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-3ZBRQjn1NdW5zFXXpEAC63
    vault-0.3.1.5-LD9Z0Bth56RKweBL8MUoee
    vector-0.13.2.0-7SsYBYYt4xiG1AFztZAEHX
    wai-3.2.4-CIVco2ayREfJFzYRTWBCXQ
    wai-cors-0.2.7-LdEIeLVhEZBEzF1hR5Wh66
    wai-extra-3.1.17-EFvkiH00LqbKdu2SUpgx1K
    wai-logger-2.5.0-AqJtOCehZXW6ZPKAqiSLNO
    warp-3.3.30-6jAAQmCNqVPCrkpQFBPtLx

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

