#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-ExeopGmFUmrywil26NkIc
key:                  postgrest-10.0.0-ExeopGmFUmrywil26NkIc
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  240dcde306098aa9f3926215e043d6fc
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-ExeopGmFUmrywil26NkIc
depends:
    HTTP-4000.4.1-KuyjCR7HUT5I1dJUpIuPzp
    Ranged-sets-0.5.0-65ivqHGBiKJ2jlKKGMW1f4
    aeson-2.1.2.1-H1ahbkp4Y7o4mfa4dlXJ2M
    auto-update-0.1.6-HKV8yfepyWgCevlFKWcKk7 base-4.17.2.1
    base64-bytestring-1.2.1.0-Chm70B0PYm3wQkrmM5U2R bytestring-0.11.5.3
    case-insensitive-1.2.1.0-9IA4WijhX2tEdiCE9R9PFI
    cassava-0.5.4.0-lfuqYmKT2FMdjygGYhLT
    configurator-pg-0.2.10-3fTuKeoMzAS72FsLD01LnL containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-GZOZqzUDn152OuhEYvht8s directory-1.3.7.1
    either-5.0.3-HXtFFr9kLDs49xVYcVohuw
    gitrev-1.3.1-A894QJs696v2EtFduMnCKp
    hasql-1.5.0.5-6rAplKwKOWEK6b3SC7utEJ
    hasql-dynamic-statements-0.3.1.1-9yOKfvKbVRSBwBJrRKf4Gr
    hasql-notifications-0.2.0.5-FSSCT5SZdyZ8sjjZbcvW3p
    hasql-pool-0.5.2.2-JbwNubxUIqf3d2gzgKZ8kB
    hasql-transaction-1.0.1.1-JxqPWcF2KyYAWQ7AGRbs4X
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-72uTcx8GQYQBxIirpABdKe
    insert-ordered-containers-0.2.5.3-3YA0M8wNbekFvSM18N7qz9
    interpolatedstring-perl6-1.0.2-FTzk1ysIaQpBT4iqJ56FrQ
    jose-0.10-7BJpqCQrqEWCBLGHlGz9uf lens-5.3.1-LjfZJ7QVgZYGOTr5fwppHy
    lens-aeson-1.2.3-HyA7yQZms3yrmtCQ5x1yL mtl-2.2.2
    network-3.1.4.0-Ds1jGwhI6OBB7cQ3449UkE
    network-uri-2.6.4.2-BUyFg1hFmM35dSD0y76h3W
    optparse-applicative-0.18.1.0-7a3VGVGHpDh9ZqkU0lCBOm
    parsec-3.1.16.1 protolude-0.3.5-8zt3SO2KipNJ9P2oGvKtJa
    regex-tdfa-1.3.2.4-AgU3y541UJt54VHrJKPJKs
    retry-0.9.3.1-1jXGIMEnKhF55TJ4jJFxn4
    scientific-0.3.8.0-6uPUyX2SLNQ5uEuI9iq9EK
    swagger2-2.8.10-Er0jj7KMet4GYkwflRgfPM text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-L0GY6JfHBKC8QjVdSVYiO8
    vault-0.3.1.5-IMEMFFEePP0AkwAGAJ7sH7
    vector-0.13.2.0-LTUcBi4LXgv7CSERMHHzQp
    wai-3.2.4-2RuDDCSyjKH9NHQ2ys4bpm
    wai-cors-0.2.7-9wDwrb8sjGB7PYuhONMUfa
    wai-extra-3.1.17-BOGNBmJPxlN8bDCz83zWJn
    wai-logger-2.5.0-i74QSdALuFJGpDWDmpn9m
    warp-3.3.30-GcJT2PwZyNwL2mET1dh8pP

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

