#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-JJPxT3l6kIX4No23EVljPX
key:                  postgrest-10.0.0-JJPxT3l6kIX4No23EVljPX
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  3123997c257dc6fd89a69b794237c29b
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-JJPxT3l6kIX4No23EVljPX
depends:
    HTTP-4000.4.1-3l2nQR5K1y1GlvXAnTn661
    Ranged-sets-0.5.0-JwQYTuF6fKq4cWgjKn11Q5
    aeson-2.1.2.1-JD8QPsoBF4NC1qVY6ch6us
    auto-update-0.1.6-ARNMBZbC1LCJY0SUtxZcSf base-4.17.2.1
    base64-bytestring-1.2.1.0-3xTWh9pwP9a781vByOHbcb
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-LsX0nU5KPAoJUeisZm5xEf
    cassava-0.5.4.0-2EwfR9DgOd81pSJygy17qc
    configurator-pg-0.2.10-ChnHLm1cpOlBlHotaiwlFD containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-GZOZqzUDn152OuhEYvht8s directory-1.3.7.1
    either-5.0.3-AM3UF2TrU5o772ZgVRvSWL
    gitrev-1.3.1-A894QJs696v2EtFduMnCKp
    hasql-1.5.0.5-Hu0Rd0XRc0Y8AIDMPNecQe
    hasql-dynamic-statements-0.3.1.1-B3XmLWgoodk6C4UguSWnaO
    hasql-notifications-0.2.0.5-9iuWrzYl7sEGV5K1zwNa58
    hasql-pool-0.5.2.2-lv40aIcJkzFQLaqeopgNu
    hasql-transaction-1.0.1.1-9un9JWpER87LFjoaHqrXyk
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-BvZSYA7IliCW0EQtF31VI
    insert-ordered-containers-0.2.5.3-FteEgKmOrlWKJTzg9pbnhM
    interpolatedstring-perl6-1.0.2-242G412myCn9dEUoW2cnLD
    jose-0.10-I3hUcd4p9LaIRZGe8C9Q85 lens-5.3.1-JV4NgTTRRUD4MjO8VGr2iB
    lens-aeson-1.2.3-D0DRwcgBUcGKRkEDKjhh8N mtl-2.2.2
    network-3.1.4.0-IWANZy3yTdDGDiy7NHyKoQ
    network-uri-2.6.4.2-37qi4fIAhTC8owHWseusWs
    optparse-applicative-0.18.1.0-7qc0weJVpOv49HyNgUQM9q
    parsec-3.1.16.1 protolude-0.3.5-KkRCP7iK6IDEIOHHx8QNKg
    regex-tdfa-1.3.2.4-3mQpNHZ3wNn6ZSjGfWeBtc
    retry-0.9.3.1-Hj02Yf7jpGA9J5KJhTc9My
    scientific-0.3.8.0-JrlaAXGfnydA9ZtLsuTElg
    swagger2-2.8.10-5gDOdyfb8j0Eahp6r9IWhA text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-ASGEyX3xTBf3ZK5sYSGlF8
    vault-0.3.1.5-1VSHZfUriLZ36tLfRqtE3c
    vector-0.13.2.0-L6HpF7nmtGm1K7R40olL6U
    wai-3.2.4-9ouRC0VqvifDMOi7kU9fdU
    wai-cors-0.2.7-F7hkJgNAQx3BIKLPMlhdb3
    wai-extra-3.1.17-8ibmlHiRh9ZHcEXjBa7mIp
    wai-logger-2.5.0-FdMtwpC5XD8C4YEVb9xtOk
    warp-3.3.30-6ekQ3avvbuT5j5432YK3Fy

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

