/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.serde;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.externalize.RelJson;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.SqlLibrary;
import org.apache.calcite.sql.fun.SqlLibraryOperatorTableFactory;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.util.JsonBuilder;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.function.PPLBuiltinOperators;
import org.opensearch.sql.opensearch.storage.serde.OpenSearchRelInputTranslator;

public class RelJsonSerializer {
    private final RelOptCluster cluster;
    public static final String EXPR = "expr";
    public static final String FIELD_TYPES = "fieldTypes";
    public static final String ROW_TYPE = "rowType";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<LinkedHashMap<String, Object>> TYPE_REF = new TypeReference<LinkedHashMap<String, Object>>(){};
    private static final SqlOperatorTable pplSqlOperatorTable = SqlOperatorTables.chain(PPLBuiltinOperators.instance(), SqlStdOperatorTable.instance(), SqlLibraryOperatorTableFactory.INSTANCE.getOperatorTable(SqlLibrary.MYSQL, SqlLibrary.BIG_QUERY, SqlLibrary.SPARK, SqlLibrary.POSTGRESQL));

    public RelJsonSerializer(RelOptCluster cluster) {
        this.cluster = cluster;
    }

    public String serialize(RexNode rexNode, RelDataType relDataType, Map<String, ExprType> fieldTypes) {
        try {
            JsonBuilder jsonBuilder = new JsonBuilder();
            RelJson relJson = RelJson.create().withJsonBuilder(jsonBuilder);
            String rexNodeJson = jsonBuilder.toJsonString(relJson.toJson(rexNode));
            String rowTypeJson = jsonBuilder.toJsonString(relJson.toJson((Object)relDataType));
            Map<String, String> envelope = Map.of(EXPR, rexNodeJson, FIELD_TYPES, fieldTypes, ROW_TYPE, rowTypeJson);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ObjectOutputStream objectOutput = new ObjectOutputStream(output);
            objectOutput.writeObject(envelope);
            objectOutput.flush();
            return Base64.getEncoder().encodeToString(output.toByteArray());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to serialize RexNode: " + String.valueOf(rexNode), e);
        }
    }

    public Map<String, Object> deserialize(String struct) {
        Map objectMap = null;
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(Base64.getDecoder().decode(struct));
            ObjectInputStream objectInput = new ObjectInputStream(input);
            objectMap = (Map)objectInput.readObject();
            Map fieldTypes = (Map)objectMap.get(FIELD_TYPES);
            RelJson relJson = RelJson.create();
            Map rowTypeMap = mapper.readValue((String)objectMap.get(ROW_TYPE), TYPE_REF);
            RelDataType rowType = relJson.toType(this.cluster.getTypeFactory(), rowTypeMap);
            OpenSearchRelInputTranslator inputTranslator = new OpenSearchRelInputTranslator(rowType);
            relJson = relJson.withInputTranslator(inputTranslator).withOperatorTable(pplSqlOperatorTable);
            Map exprMap = mapper.readValue((String)objectMap.get(EXPR), TYPE_REF);
            RexNode rexNode = relJson.toRex(this.cluster, (Object)exprMap);
            return Map.of(EXPR, rexNode, FIELD_TYPES, fieldTypes, ROW_TYPE, rowType);
        }
        catch (Exception e) {
            if (objectMap == null) {
                throw new IllegalStateException("Failed to deserialize RexNode due to object map is null", e);
            }
            throw new IllegalStateException("Failed to deserialize RexNode and its required structure: " + String.valueOf(objectMap.get(EXPR)), e);
        }
    }

    @Generated
    public RelOptCluster getCluster() {
        return this.cluster;
    }

    static {
        mapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    }
}

