/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.aggregation.dsl;

import java.util.List;
import org.apache.commons.lang3.tuple.Triple;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.DateHistogramValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.HistogramValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.opensearch.search.aggregations.bucket.missing.MissingOrder;
import org.opensearch.search.aggregations.support.ValueType;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.sql.ast.expression.SpanUnit;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.span.SpanExpression;
import org.opensearch.sql.opensearch.data.type.OpenSearchDateType;
import org.opensearch.sql.opensearch.storage.script.aggregation.dsl.AggregationBuilderHelper;
import org.opensearch.sql.opensearch.storage.serde.ExpressionSerializer;
import shaded.com.google.common.collect.ImmutableList;

public class BucketAggregationBuilder {
    private final AggregationBuilderHelper helper;

    public BucketAggregationBuilder(ExpressionSerializer serializer) {
        this.helper = new AggregationBuilderHelper(serializer);
    }

    public List<CompositeValuesSourceBuilder<?>> build(List<Triple<NamedExpression, SortOrder, MissingOrder>> groupList) {
        ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
        for (Triple<NamedExpression, SortOrder, MissingOrder> groupPair : groupList) {
            resultBuilder.add(this.buildCompositeValuesSourceBuilder(groupPair.getLeft(), groupPair.getMiddle(), groupPair.getRight()));
        }
        return resultBuilder.build();
    }

    private CompositeValuesSourceBuilder<?> buildCompositeValuesSourceBuilder(NamedExpression expr, SortOrder sortOrder, MissingOrder missingOrder) {
        if (expr.getDelegated() instanceof SpanExpression) {
            SpanExpression spanExpr = (SpanExpression)expr.getDelegated();
            return BucketAggregationBuilder.buildHistogram(expr.getName(), spanExpr.getField().toString(), spanExpr.getValue().valueOf().doubleValue(), spanExpr.getUnit(), missingOrder);
        }
        CompositeValuesSourceBuilder sourceBuilder = ((TermsValuesSourceBuilder)((TermsValuesSourceBuilder)new TermsValuesSourceBuilder(expr.getName()).missingBucket(true)).missingOrder(missingOrder)).order(sortOrder);
        if (expr.getDelegated().type() instanceof OpenSearchDateType && List.of(ExprCoreType.TIMESTAMP, ExprCoreType.TIME, ExprCoreType.DATE).contains(((OpenSearchDateType)expr.getDelegated().type()).getExprCoreType()) || List.of(ExprCoreType.TIMESTAMP, ExprCoreType.TIME, ExprCoreType.DATE).contains(expr.getDelegated().type())) {
            sourceBuilder.userValuetypeHint(ValueType.LONG);
        }
        return this.helper.build(expr.getDelegated(), arg_0 -> ((CompositeValuesSourceBuilder)sourceBuilder).field(arg_0), arg_0 -> ((CompositeValuesSourceBuilder)sourceBuilder).script(arg_0));
    }

    public static CompositeValuesSourceBuilder<?> buildHistogram(String name, String field, Double value, SpanUnit unit, MissingOrder missingOrder) {
        switch (unit) {
            case NONE: {
                return ((HistogramValuesSourceBuilder)((HistogramValuesSourceBuilder)new HistogramValuesSourceBuilder(name).field(field)).interval(value.doubleValue()).missingBucket(true)).missingOrder(missingOrder);
            }
            case UNKNOWN: {
                throw new IllegalStateException("Invalid span unit");
            }
        }
        return BucketAggregationBuilder.buildDateHistogram(name, field, value.intValue(), unit, missingOrder);
    }

    public static CompositeValuesSourceBuilder<?> buildDateHistogram(String name, String field, Integer value, SpanUnit unit, MissingOrder missingOrder) {
        String spanValue = value + unit.getName();
        switch (unit) {
            case MILLISECOND: 
            case MS: 
            case SECOND: 
            case S: 
            case MINUTE: 
            case m: 
            case HOUR: 
            case H: 
            case DAY: 
            case D: {
                return ((DateHistogramValuesSourceBuilder)((DateHistogramValuesSourceBuilder)((DateHistogramValuesSourceBuilder)new DateHistogramValuesSourceBuilder(name).field(field)).missingBucket(true)).missingOrder(missingOrder)).fixedInterval(new DateHistogramInterval(spanValue));
            }
        }
        return ((DateHistogramValuesSourceBuilder)((DateHistogramValuesSourceBuilder)((DateHistogramValuesSourceBuilder)new DateHistogramValuesSourceBuilder(name).field(field)).missingBucket(true)).missingOrder(missingOrder)).calendarInterval(new DateHistogramInterval(spanValue));
    }
}

