/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.rewriter.subquery.rewriter;

import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import java.util.ArrayDeque;
import java.util.Deque;

public class SubqueryAliasRewriter
extends MySqlASTVisitorAdapter {
    private final Deque<Table> tableScope = new ArrayDeque<Table>();
    private int aliasSuffix = 0;
    private static final String DOT = ".";

    @Override
    public boolean visit(MySqlSelectQueryBlock query) {
        SQLTableSource from = query.getFrom();
        if (from instanceof SQLExprTableSource) {
            SQLExprTableSource expr = (SQLExprTableSource)from;
            String tableName = expr.getExpr().toString().replaceAll(" ", "");
            if (expr.getAlias() != null) {
                this.tableScope.push(new Table(tableName, expr.getAlias()));
            } else {
                expr.setAlias(this.createAlias(tableName));
                this.tableScope.push(new Table(tableName, expr.getAlias()));
            }
        }
        return true;
    }

    @Override
    public boolean visit(SQLIdentifierExpr expr) {
        if (!this.tableScope.isEmpty() && (this.inSelect(expr) || this.inWhere(expr) || this.inSubquery(expr))) {
            this.rewrite(this.tableScope.peek(), expr);
        }
        return true;
    }

    @Override
    public boolean visit(SQLAllColumnExpr expr) {
        if (!this.tableScope.isEmpty() && this.inSelect(expr)) {
            ((SQLSelectItem)expr.getParent()).setExpr(this.createIdentifierExpr(this.tableScope.peek()));
        }
        return true;
    }

    private boolean inSelect(SQLIdentifierExpr expr) {
        return expr.getParent() instanceof SQLSelectItem;
    }

    private boolean inSelect(SQLAllColumnExpr expr) {
        return expr.getParent() instanceof SQLSelectItem;
    }

    private boolean inWhere(SQLIdentifierExpr expr) {
        return expr.getParent() instanceof SQLBinaryOpExpr && !this.isESTable((SQLBinaryOpExpr)expr.getParent());
    }

    private boolean isESTable(SQLBinaryOpExpr expr) {
        return expr.getOperator() == SQLBinaryOperator.Divide && expr.getParent() instanceof SQLExprTableSource;
    }

    private boolean inSubquery(SQLIdentifierExpr expr) {
        return expr.getParent() instanceof SQLInSubQueryExpr;
    }

    @Override
    public void endVisit(MySqlSelectQueryBlock query) {
        if (!this.tableScope.isEmpty()) {
            this.tableScope.pop();
        }
    }

    private void rewrite(Table table, SQLIdentifierExpr expr) {
        String tableAlias = table.getAlias();
        String tableName = table.getName();
        String exprName = expr.getName();
        if (exprName.startsWith(tableName + DOT) || exprName.startsWith(tableAlias + DOT)) {
            expr.setName(exprName.replace(tableName + DOT, tableAlias + DOT));
        } else {
            expr.setName(String.join((CharSequence)DOT, tableAlias, exprName));
        }
    }

    private SQLIdentifierExpr createIdentifierExpr(Table table) {
        String newIdentifierName = String.join((CharSequence)DOT, table.getAlias(), "*");
        return new SQLIdentifierExpr(newIdentifierName);
    }

    private String createAlias(String alias) {
        return String.format("%s_%d", alias, this.next());
    }

    private Integer next() {
        return this.aliasSuffix++;
    }

    private static class Table {
        private final String name;
        private final String alias;

        public String getName() {
            return this.name;
        }

        public String getAlias() {
            return this.alias;
        }

        Table(String name, String alias) {
            this.name = name;
            this.alias = alias;
        }
    }
}

