/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.planner.physical.node.scroll;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.histogram.Histogram;
import org.opensearch.search.aggregations.bucket.terms.Terms;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.opensearch.search.aggregations.metrics.Percentile;
import org.opensearch.search.aggregations.metrics.Percentiles;
import org.opensearch.sql.legacy.expression.domain.BindingTuple;
import org.opensearch.sql.legacy.query.planner.physical.node.scroll.BindingTupleRow;
import shaded.com.google.common.annotations.VisibleForTesting;

public class SearchAggregationResponseHelper {
    public static List<BindingTupleRow> populateSearchAggregationResponse(Aggregations aggs) {
        List<Map<String, Object>> flatten2 = SearchAggregationResponseHelper.flatten(aggs);
        List<BindingTupleRow> bindingTupleList = flatten2.stream().map(BindingTuple::from).map(bindingTuple -> new BindingTupleRow((BindingTuple)bindingTuple)).collect(Collectors.toList());
        return bindingTupleList;
    }

    @VisibleForTesting
    public static List<Map<String, Object>> flatten(Aggregations aggregations) {
        List aggregationList = aggregations.asList();
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        HashMap<String, Double> resultMap = new HashMap<String, Double>();
        for (Aggregation aggregation : aggregationList) {
            List<Map<String, Object>> internalBucketList;
            if (aggregation instanceof Terms) {
                for (Terms.Bucket bucket : ((Terms)aggregation).getBuckets()) {
                    internalBucketList = SearchAggregationResponseHelper.flatten(bucket.getAggregations());
                    SearchAggregationResponseHelper.fillResultListWithInternalBucket(resultList, internalBucketList, aggregation.getName(), bucket.getKey());
                }
                continue;
            }
            if (aggregation instanceof NumericMetricsAggregation.SingleValue) {
                resultMap.put(aggregation.getName(), ((NumericMetricsAggregation.SingleValue)aggregation).value());
                continue;
            }
            if (aggregation instanceof Percentiles) {
                Percentiles percentiles = (Percentiles)aggregation;
                resultMap.putAll(StreamSupport.stream(percentiles.spliterator(), false).collect(Collectors.toMap(percentile -> String.format("%s_%s", percentiles.getName(), percentile.getPercent()), Percentile::getValue, (v1, v2) -> {
                    throw new IllegalArgumentException(String.format("Duplicate key for values %s and %s", v1, v2));
                }, HashMap::new)));
                continue;
            }
            if (aggregation instanceof Histogram) {
                for (Terms.Bucket bucket : ((Histogram)aggregation).getBuckets()) {
                    internalBucketList = SearchAggregationResponseHelper.flatten(bucket.getAggregations());
                    SearchAggregationResponseHelper.fillResultListWithInternalBucket(resultList, internalBucketList, aggregation.getName(), bucket.getKeyAsString());
                }
                continue;
            }
            throw new RuntimeException("unsupported aggregation type " + aggregation.getType());
        }
        if (!resultMap.isEmpty()) {
            resultList.add(resultMap);
        }
        return resultList;
    }

    private static void fillResultListWithInternalBucket(List<Map<String, Object>> resultList, List<Map<String, Object>> internalBucketList, final String aggregationName, final Object bucketKey) {
        if (internalBucketList.isEmpty()) {
            resultList.add((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put(aggregationName, bucketKey);
                }
            });
        } else {
            for (Map<String, Object> map : internalBucketList) {
                map.put(aggregationName, bucketKey);
            }
            resultList.addAll(internalBucketList);
        }
    }
}

