/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.domain;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.sql.legacy.antlr.semantic.types.Type;
import org.opensearch.sql.legacy.antlr.semantic.types.base.OpenSearchDataType;
import org.opensearch.sql.legacy.antlr.semantic.types.special.Product;
import org.opensearch.sql.legacy.executor.format.Schema;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableMap;

public class ColumnTypeProvider {
    private final List<Schema.Type> typeList;
    private static final Map<OpenSearchDataType, Schema.Type> TYPE_MAP = new ImmutableMap.Builder<OpenSearchDataType, Schema.Type>().put(OpenSearchDataType.SHORT, Schema.Type.SHORT).put(OpenSearchDataType.LONG, Schema.Type.LONG).put(OpenSearchDataType.INTEGER, Schema.Type.INTEGER).put(OpenSearchDataType.FLOAT, Schema.Type.FLOAT).put(OpenSearchDataType.DOUBLE, Schema.Type.DOUBLE).put(OpenSearchDataType.KEYWORD, Schema.Type.KEYWORD).put(OpenSearchDataType.TEXT, Schema.Type.TEXT).put(OpenSearchDataType.STRING, Schema.Type.TEXT).put(OpenSearchDataType.DATE, Schema.Type.DATE).put(OpenSearchDataType.BOOLEAN, Schema.Type.BOOLEAN).put(OpenSearchDataType.UNKNOWN, Schema.Type.DOUBLE).build();
    public static final Schema.Type COLUMN_DEFAULT_TYPE = Schema.Type.DOUBLE;

    public ColumnTypeProvider(Type type2) {
        this.typeList = this.convertOutputColumnType(type2);
    }

    public ColumnTypeProvider() {
        this.typeList = new ArrayList<Schema.Type>();
    }

    public Schema.Type get(int index) {
        if (this.typeList.isEmpty()) {
            return COLUMN_DEFAULT_TYPE;
        }
        return this.typeList.get(index);
    }

    private List<Schema.Type> convertOutputColumnType(Type type2) {
        if (type2 instanceof Product) {
            List<Type> types = ((Product)type2).getTypes();
            return types.stream().map(t2 -> this.convertType((Type)t2)).collect(Collectors.toList());
        }
        if (type2 instanceof OpenSearchDataType) {
            return ImmutableList.of(this.convertType(type2));
        }
        return ImmutableList.of(COLUMN_DEFAULT_TYPE);
    }

    private Schema.Type convertType(Type type2) {
        try {
            return TYPE_MAP.getOrDefault(type2, COLUMN_DEFAULT_TYPE);
        }
        catch (Exception e) {
            return COLUMN_DEFAULT_TYPE;
        }
    }
}

