/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.window;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.expression.Expression;

public class WindowDefinition {
    private final List<Expression> partitionByList;
    private final List<Pair<Sort.SortOption, Expression>> sortList;

    public List<Pair<Sort.SortOption, Expression>> getAllSortItems() {
        ArrayList<Pair<Sort.SortOption, Expression>> allSorts = new ArrayList<Pair<Sort.SortOption, Expression>>();
        this.partitionByList.forEach(expr -> allSorts.add(ImmutablePair.of(Sort.SortOption.DEFAULT_ASC, expr)));
        allSorts.addAll(this.sortList);
        return allSorts;
    }

    @Generated
    public WindowDefinition(List<Expression> partitionByList, List<Pair<Sort.SortOption, Expression>> sortList) {
        this.partitionByList = partitionByList;
        this.sortList = sortList;
    }

    @Generated
    public List<Expression> getPartitionByList() {
        return this.partitionByList;
    }

    @Generated
    public List<Pair<Sort.SortOption, Expression>> getSortList() {
        return this.sortList;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WindowDefinition)) {
            return false;
        }
        WindowDefinition other = (WindowDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Expression> this$partitionByList = this.getPartitionByList();
        List<Expression> other$partitionByList = other.getPartitionByList();
        if (this$partitionByList == null ? other$partitionByList != null : !((Object)this$partitionByList).equals(other$partitionByList)) {
            return false;
        }
        List<Pair<Sort.SortOption, Expression>> this$sortList = this.getSortList();
        List<Pair<Sort.SortOption, Expression>> other$sortList = other.getSortList();
        return !(this$sortList == null ? other$sortList != null : !((Object)this$sortList).equals(other$sortList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WindowDefinition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        List<Expression> $partitionByList = this.getPartitionByList();
        result2 = result2 * 59 + ($partitionByList == null ? 43 : ((Object)$partitionByList).hashCode());
        List<Pair<Sort.SortOption, Expression>> $sortList = this.getSortList();
        result2 = result2 * 59 + ($sortList == null ? 43 : ((Object)$sortList).hashCode());
        return result2;
    }

    @Generated
    public String toString() {
        return "WindowDefinition(partitionByList=" + String.valueOf(this.getPartitionByList()) + ", sortList=" + String.valueOf(this.getSortList()) + ")";
    }
}

