/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.aggregation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.aggregation.AggregationState;
import org.opensearch.sql.expression.aggregation.Aggregator;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.utils.ExpressionUtils;

public class StdDevAggregator
extends Aggregator<StdDevState> {
    private final boolean isSampleStdDev;

    public static Aggregator stddevPopulation(List<Expression> arguments2, ExprCoreType returnType) {
        return new StdDevAggregator(false, arguments2, returnType);
    }

    public static Aggregator stddevSample(List<Expression> arguments2, ExprCoreType returnType) {
        return new StdDevAggregator(true, arguments2, returnType);
    }

    public StdDevAggregator(Boolean isSampleStdDev, List<Expression> arguments2, ExprCoreType returnType) {
        super(isSampleStdDev != false ? BuiltinFunctionName.STDDEV_SAMP.getName() : BuiltinFunctionName.STDDEV_POP.getName(), arguments2, returnType);
        this.isSampleStdDev = isSampleStdDev;
    }

    @Override
    public StdDevState create() {
        return new StdDevState(this.isSampleStdDev);
    }

    @Override
    protected StdDevState iterate(ExprValue value, StdDevState state) {
        state.evaluate(value);
        return state;
    }

    public String toString() {
        return StringUtils.format("%s(%s)", this.isSampleStdDev ? "stddev_samp" : "stddev_pop", ExpressionUtils.format(this.getArguments()));
    }

    protected static class StdDevState
    implements AggregationState {
        private final StandardDeviation standardDeviation;
        private final List<Double> values = new ArrayList<Double>();

        public StdDevState(boolean isSampleStdDev) {
            this.standardDeviation = new StandardDeviation(isSampleStdDev);
        }

        public void evaluate(ExprValue value) {
            this.values.add(value.doubleValue());
        }

        @Override
        public ExprValue result() {
            return this.values.size() == 0 ? ExprNullValue.of() : ExprValueUtils.doubleValue(this.standardDeviation.evaluate(this.values.stream().mapToDouble(d -> d).toArray()));
        }
    }
}

