/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.udf.udaf;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.sql.calcite.udf.UserDefinedAggFunction;
import org.opensearch.sql.common.antlr.SyntaxCheckException;
import org.opensearch.sql.common.patterns.BrainLogParser;
import org.opensearch.sql.common.patterns.PatternUtils;
import shaded.com.google.common.collect.ImmutableMap;

public class LogPatternAggFunction
implements UserDefinedAggFunction<LogParserAccumulator> {
    private int bufferLimit = 100000;
    private int maxSampleCount = 10;
    private int variableCountThreshold = 5;
    private double thresholdPercentage = 0.3f;

    @Override
    public LogParserAccumulator init() {
        return new LogParserAccumulator();
    }

    @Override
    public Object result(LogParserAccumulator acc) {
        if (acc.size() == 0) {
            return null;
        }
        return acc.value(this.maxSampleCount, this.variableCountThreshold, this.thresholdPercentage);
    }

    @Override
    public LogParserAccumulator add(LogParserAccumulator acc, Object ... values2) {
        throw new SyntaxCheckException("Unsupported function signature for pattern aggregate. Valid parameters include (field: required string), (max_sample_count: required integer), (buffer_limit: required integer), [variable_count_threshold: optional integer], [frequency_threshold_percentage: optional double]");
    }

    public LogParserAccumulator add(LogParserAccumulator acc, String field, int maxSampleCount, int bufferLimit, BigDecimal thresholdPercentage, int variableCountThreshold) {
        return this.add(acc, field, maxSampleCount, bufferLimit, thresholdPercentage.doubleValue(), variableCountThreshold);
    }

    public LogParserAccumulator add(LogParserAccumulator acc, String field, int maxSampleCount, int bufferLimit, double thresholdPercentage, int variableCountThreshold) {
        if (Objects.isNull(field)) {
            return acc;
        }
        this.bufferLimit = bufferLimit;
        this.maxSampleCount = maxSampleCount;
        this.variableCountThreshold = variableCountThreshold;
        this.thresholdPercentage = thresholdPercentage;
        acc.evaluate(field);
        if (bufferLimit > 0 && acc.size() == bufferLimit) {
            acc.partialMerge(maxSampleCount, variableCountThreshold, thresholdPercentage);
            acc.clearBuffer();
        }
        return acc;
    }

    public LogParserAccumulator add(LogParserAccumulator acc, String field, int maxSampleCount, int bufferLimit, int variableCountThreshold) {
        return this.add(acc, field, maxSampleCount, bufferLimit, this.thresholdPercentage, variableCountThreshold);
    }

    public LogParserAccumulator add(LogParserAccumulator acc, String field, int maxSampleCount, int bufferLimit, BigDecimal thresholdPercentage) {
        return this.add(acc, field, maxSampleCount, bufferLimit, thresholdPercentage.doubleValue(), this.variableCountThreshold);
    }

    public LogParserAccumulator add(LogParserAccumulator acc, String field, int maxSampleCount, int bufferLimit) {
        return this.add(acc, field, maxSampleCount, bufferLimit, this.thresholdPercentage, this.variableCountThreshold);
    }

    public static class LogParserAccumulator
    implements UserDefinedAggFunction.Accumulator {
        private final List<String> logMessages;
        public Map<String, Map<String, Object>> patternGroupMap = new HashMap<String, Map<String, Object>>();

        public int size() {
            return this.logMessages.size();
        }

        public LogParserAccumulator() {
            this.logMessages = new ArrayList<String>();
        }

        public void evaluate(String value) {
            this.logMessages.add(value);
        }

        public void clearBuffer() {
            this.logMessages.clear();
        }

        public void partialMerge(Object ... argList) {
            if (this.logMessages.isEmpty()) {
                return;
            }
            assert (argList.length == 3) : "partialMerge of LogParserAccumulator requires 3 parameters";
            int maxSampleCount = (Integer)argList[0];
            BrainLogParser logParser = new BrainLogParser((Integer)argList[1], ((Double)argList[2]).floatValue());
            Map<String, Map<String, Object>> partialPatternGroupMap = logParser.parseAllLogPatterns(this.logMessages, maxSampleCount);
            this.patternGroupMap = PatternUtils.mergePatternGroups(this.patternGroupMap, partialPatternGroupMap, maxSampleCount);
        }

        @Override
        public Object value(Object ... argList) {
            this.partialMerge(argList);
            this.clearBuffer();
            return this.patternGroupMap.values().stream().sorted(Comparator.comparing(m4 -> (Long)m4.get("pattern_count"), Comparator.nullsLast(Comparator.reverseOrder()))).map(m4 -> {
                String pattern = (String)m4.get("pattern");
                Long count = (Long)m4.get("pattern_count");
                List sampleLogs = (List)m4.get("sample_logs");
                HashMap<String, List<String>> tokensMap = new HashMap<String, List<String>>();
                PatternUtils.ParseResult parseResult = PatternUtils.parsePattern(pattern, PatternUtils.WILDCARD_PATTERN);
                for (String sampleLog : sampleLogs) {
                    PatternUtils.extractVariables(parseResult, sampleLog, tokensMap, "<*");
                }
                return ImmutableMap.of("pattern", parseResult.toTokenOrderString("<*"), "pattern_count", count, "tokens", tokensMap);
            }).collect(Collectors.toList());
        }
    }
}

