/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.plan;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rex.RexNode;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LogicalSystemLimit
extends Sort {
    private final SystemLimitType type;

    private LogicalSystemLimit(SystemLimitType type2, RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelCollation collation, @Nullable RexNode offset, @Nullable RexNode fetch) {
        this(type2, cluster, traitSet, Collections.emptyList(), input, collation, offset, fetch);
    }

    private LogicalSystemLimit(SystemLimitType type2, RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelNode input, RelCollation collation, @Nullable RexNode offset, @Nullable RexNode fetch) {
        super(cluster, traitSet, hints, input, collation, offset, fetch);
        assert (traitSet.containsIfApplicable(Convention.NONE));
        this.type = type2;
    }

    public static LogicalSystemLimit create(SystemLimitType type2, RelNode input, RexNode fetch) {
        return LogicalSystemLimit.create(type2, input, input.getTraitSet().getCollation(), null, fetch);
    }

    public static LogicalSystemLimit create(SystemLimitType type2, RelNode input, RelCollation collation, @Nullable RexNode offset, @Nullable RexNode fetch) {
        RelOptCluster cluster = input.getCluster();
        collation = RelCollationTraitDef.INSTANCE.canonize(collation);
        RelTraitSet traitSet = input.getTraitSet().replace(Convention.NONE).replace(collation);
        return new LogicalSystemLimit(type2, cluster, traitSet, input, collation, offset, fetch);
    }

    @Override
    public Sort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, @Nullable RexNode offset, @Nullable RexNode fetch) {
        return new LogicalSystemLimit(this.type, this.getCluster(), traitSet, this.hints, newInput, newCollation, offset, fetch);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        pw.item("type", (Object)this.type);
        return pw;
    }

    @Generated
    public SystemLimitType getType() {
        return this.type;
    }

    public static enum SystemLimitType {
        QUERY_SIZE_LIMIT;

    }
}

