/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model.action;

import java.io.IOException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.UUIDs;
import org.opensearch.commons.alerting.model.action.ActionExecutionPolicy;
import org.opensearch.commons.alerting.model.action.PerExecutionActionScope;
import org.opensearch.commons.alerting.model.action.Throttle;
import org.opensearch.commons.notifications.model.BaseModel;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.script.Script;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 :2\u00020\u0001:\u0001:B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004BO\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\"0!J\t\u0010#\u001a\u00020\u0006H\u00c6\u0003J\t\u0010$\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\t\u0010&\u001a\u00020\tH\u00c6\u0003J\t\u0010'\u001a\u00020\fH\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\t\u0010)\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010*\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003J_\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00062\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00c6\u0001J\u0013\u0010,\u001a\u00020\f2\b\u0010-\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010.\u001a\u00020/H\u00d6\u0001J\t\u00100\u001a\u00020\u0006H\u00d6\u0001J\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u0002022\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006;"}, d2={"Lorg/opensearch/commons/alerting/model/action/Action;", "Lorg/opensearch/commons/notifications/model/BaseModel;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "name", "", "destinationId", "subjectTemplate", "Lorg/opensearch/script/Script;", "messageTemplate", "throttleEnabled", "", "throttle", "Lorg/opensearch/commons/alerting/model/action/Throttle;", "id", "actionExecutionPolicy", "Lorg/opensearch/commons/alerting/model/action/ActionExecutionPolicy;", "(Ljava/lang/String;Ljava/lang/String;Lorg/opensearch/script/Script;Lorg/opensearch/script/Script;ZLorg/opensearch/commons/alerting/model/action/Throttle;Ljava/lang/String;Lorg/opensearch/commons/alerting/model/action/ActionExecutionPolicy;)V", "getActionExecutionPolicy", "()Lorg/opensearch/commons/alerting/model/action/ActionExecutionPolicy;", "getDestinationId", "()Ljava/lang/String;", "getId", "getMessageTemplate", "()Lorg/opensearch/script/Script;", "getName", "getSubjectTemplate", "getThrottle", "()Lorg/opensearch/commons/alerting/model/action/Throttle;", "getThrottleEnabled", "()Z", "asTemplateArg", "", "", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "common-utils"})
@SourceDebugExtension(value={"SMAP\nAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Action.kt\norg/opensearch/commons/alerting/model/action/Action\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n1#2:188\n*E\n"})
public final class Action
implements BaseModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final String destinationId;
    @Nullable
    private final Script subjectTemplate;
    @NotNull
    private final Script messageTemplate;
    private final boolean throttleEnabled;
    @Nullable
    private final Throttle throttle;
    @NotNull
    private final String id;
    @Nullable
    private final ActionExecutionPolicy actionExecutionPolicy;
    @NotNull
    public static final String ID_FIELD = "id";
    @NotNull
    public static final String NAME_FIELD = "name";
    @NotNull
    public static final String DESTINATION_ID_FIELD = "destination_id";
    @NotNull
    public static final String SUBJECT_TEMPLATE_FIELD = "subject_template";
    @NotNull
    public static final String MESSAGE_TEMPLATE_FIELD = "message_template";
    @NotNull
    public static final String THROTTLE_ENABLED_FIELD = "throttle_enabled";
    @NotNull
    public static final String THROTTLE_FIELD = "throttle";
    @NotNull
    public static final String ACTION_EXECUTION_POLICY_FIELD = "action_execution_policy";
    @NotNull
    public static final String MUSTACHE = "mustache";
    @NotNull
    public static final String SUBJECT = "subject";
    @NotNull
    public static final String MESSAGE = "message";
    @NotNull
    public static final String MESSAGE_ID = "messageId";

    public Action(@NotNull String name, @NotNull String destinationId, @Nullable Script subjectTemplate, @NotNull Script messageTemplate, boolean throttleEnabled, @Nullable Throttle throttle, @NotNull String id, @Nullable ActionExecutionPolicy actionExecutionPolicy) {
        Intrinsics.checkNotNullParameter(name, NAME_FIELD);
        Intrinsics.checkNotNullParameter(destinationId, "destinationId");
        Intrinsics.checkNotNullParameter(messageTemplate, "messageTemplate");
        Intrinsics.checkNotNullParameter(id, ID_FIELD);
        this.name = name;
        this.destinationId = destinationId;
        this.subjectTemplate = subjectTemplate;
        this.messageTemplate = messageTemplate;
        this.throttleEnabled = throttleEnabled;
        this.throttle = throttle;
        this.id = id;
        this.actionExecutionPolicy = actionExecutionPolicy;
        if (this.subjectTemplate != null && !Intrinsics.areEqual(this.subjectTemplate.getLang(), MUSTACHE)) {
            boolean $i$a$-require-Action$42 = false;
            String $i$a$-require-Action$42 = "subject_template must be a mustache script";
            throw new IllegalArgumentException($i$a$-require-Action$42.toString());
        }
        if (!Intrinsics.areEqual(this.messageTemplate.getLang(), MUSTACHE)) {
            boolean $i$a$-require-Action$52 = false;
            String $i$a$-require-Action$52 = "message_template must be a mustache script";
            throw new IllegalArgumentException($i$a$-require-Action$52.toString());
        }
        ActionExecutionPolicy actionExecutionPolicy2 = this.actionExecutionPolicy;
        if ((actionExecutionPolicy2 != null ? actionExecutionPolicy2.getActionExecutionScope() : null) instanceof PerExecutionActionScope && !(this.throttle == null)) {
            boolean bl = false;
            String string = "Throttle is currently not supported for per execution action scope";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ Action(String string, String string2, Script script, Script script2, boolean bl, Throttle throttle, String string3, ActionExecutionPolicy actionExecutionPolicy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            String string4 = UUIDs.base64UUID();
            Intrinsics.checkNotNullExpressionValue(string4, "base64UUID(...)");
            string3 = string4;
        }
        if ((n & 0x80) != 0) {
            actionExecutionPolicy = null;
        }
        this(string, string2, script, script2, bl, throttle, string3, actionExecutionPolicy);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getDestinationId() {
        return this.destinationId;
    }

    @Nullable
    public final Script getSubjectTemplate() {
        return this.subjectTemplate;
    }

    @NotNull
    public final Script getMessageTemplate() {
        return this.messageTemplate;
    }

    public final boolean getThrottleEnabled() {
        return this.throttleEnabled;
    }

    @Nullable
    public final Throttle getThrottle() {
        return this.throttle;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @Nullable
    public final ActionExecutionPolicy getActionExecutionPolicy() {
        return this.actionExecutionPolicy;
    }

    public Action(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter(sin, "sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue(string, "readString(...)");
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue(string2, "readString(...)");
        Script script = (Script)sin.readOptionalWriteable(Script::new);
        Script script2 = new Script(sin);
        boolean bl = sin.readBoolean();
        Throttle throttle = (Throttle)sin.readOptionalWriteable(Throttle::new);
        String string3 = sin.readString();
        Intrinsics.checkNotNullExpressionValue(string3, "readString(...)");
        this(string, string2, script, script2, bl, throttle, string3, (ActionExecutionPolicy)sin.readOptionalWriteable(ActionExecutionPolicy::new));
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(params, "params");
        XContentBuilder xContentBuilder = builder.startObject().field(ID_FIELD, this.id).field(NAME_FIELD, this.name).field(DESTINATION_ID_FIELD, this.destinationId).field(MESSAGE_TEMPLATE_FIELD, (ToXContent)this.messageTemplate).field(THROTTLE_ENABLED_FIELD, this.throttleEnabled);
        if (this.subjectTemplate != null) {
            xContentBuilder.field(SUBJECT_TEMPLATE_FIELD, (ToXContent)this.subjectTemplate);
        }
        if (this.throttle != null) {
            xContentBuilder.field(THROTTLE_FIELD, (ToXContent)this.throttle);
        }
        if (this.actionExecutionPolicy != null) {
            xContentBuilder.field(ACTION_EXECUTION_POLICY_FIELD, (ToXContent)this.actionExecutionPolicy);
        }
        XContentBuilder xContentBuilder2 = xContentBuilder.endObject();
        Intrinsics.checkNotNullExpressionValue(xContentBuilder2, "endObject(...)");
        return xContentBuilder2;
    }

    @NotNull
    public final Map<String, Object> asTemplateArg() {
        Pair[] pairArray = new Pair[]{TuplesKt.to(ID_FIELD, this.id), TuplesKt.to(NAME_FIELD, this.name), TuplesKt.to(DESTINATION_ID_FIELD, this.destinationId), TuplesKt.to(THROTTLE_ENABLED_FIELD, this.throttleEnabled)};
        return MapsKt.mapOf(pairArray);
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter(out, "out");
        out.writeString(this.name);
        out.writeString(this.destinationId);
        if (this.subjectTemplate != null) {
            out.writeBoolean(true);
            this.subjectTemplate.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        this.messageTemplate.writeTo(out);
        out.writeBoolean(this.throttleEnabled);
        if (this.throttle != null) {
            out.writeBoolean(true);
            this.throttle.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeString(this.id);
        if (this.actionExecutionPolicy != null) {
            out.writeBoolean(true);
            this.actionExecutionPolicy.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final String component2() {
        return this.destinationId;
    }

    @Nullable
    public final Script component3() {
        return this.subjectTemplate;
    }

    @NotNull
    public final Script component4() {
        return this.messageTemplate;
    }

    public final boolean component5() {
        return this.throttleEnabled;
    }

    @Nullable
    public final Throttle component6() {
        return this.throttle;
    }

    @NotNull
    public final String component7() {
        return this.id;
    }

    @Nullable
    public final ActionExecutionPolicy component8() {
        return this.actionExecutionPolicy;
    }

    @NotNull
    public final Action copy(@NotNull String name, @NotNull String destinationId, @Nullable Script subjectTemplate, @NotNull Script messageTemplate, boolean throttleEnabled, @Nullable Throttle throttle, @NotNull String id, @Nullable ActionExecutionPolicy actionExecutionPolicy) {
        Intrinsics.checkNotNullParameter(name, NAME_FIELD);
        Intrinsics.checkNotNullParameter(destinationId, "destinationId");
        Intrinsics.checkNotNullParameter(messageTemplate, "messageTemplate");
        Intrinsics.checkNotNullParameter(id, ID_FIELD);
        return new Action(name, destinationId, subjectTemplate, messageTemplate, throttleEnabled, throttle, id, actionExecutionPolicy);
    }

    public static /* synthetic */ Action copy$default(Action action, String string, String string2, Script script, Script script2, boolean bl, Throttle throttle, String string3, ActionExecutionPolicy actionExecutionPolicy, int n, Object object) {
        if ((n & 1) != 0) {
            string = action.name;
        }
        if ((n & 2) != 0) {
            string2 = action.destinationId;
        }
        if ((n & 4) != 0) {
            script = action.subjectTemplate;
        }
        if ((n & 8) != 0) {
            script2 = action.messageTemplate;
        }
        if ((n & 0x10) != 0) {
            bl = action.throttleEnabled;
        }
        if ((n & 0x20) != 0) {
            throttle = action.throttle;
        }
        if ((n & 0x40) != 0) {
            string3 = action.id;
        }
        if ((n & 0x80) != 0) {
            actionExecutionPolicy = action.actionExecutionPolicy;
        }
        return action.copy(string, string2, script, script2, bl, throttle, string3, actionExecutionPolicy);
    }

    @NotNull
    public String toString() {
        return "Action(name=" + this.name + ", destinationId=" + this.destinationId + ", subjectTemplate=" + this.subjectTemplate + ", messageTemplate=" + this.messageTemplate + ", throttleEnabled=" + this.throttleEnabled + ", throttle=" + this.throttle + ", id=" + this.id + ", actionExecutionPolicy=" + this.actionExecutionPolicy + ")";
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + this.destinationId.hashCode();
        result2 = result2 * 31 + (this.subjectTemplate == null ? 0 : this.subjectTemplate.hashCode());
        result2 = result2 * 31 + this.messageTemplate.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.throttleEnabled);
        result2 = result2 * 31 + (this.throttle == null ? 0 : this.throttle.hashCode());
        result2 = result2 * 31 + this.id.hashCode();
        result2 = result2 * 31 + (this.actionExecutionPolicy == null ? 0 : this.actionExecutionPolicy.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Action)) {
            return false;
        }
        Action action = (Action)other;
        if (!Intrinsics.areEqual(this.name, action.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.destinationId, action.destinationId)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.subjectTemplate, action.subjectTemplate)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.messageTemplate, action.messageTemplate)) {
            return false;
        }
        if (this.throttleEnabled != action.throttleEnabled) {
            return false;
        }
        if (!Intrinsics.areEqual(this.throttle, action.throttle)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.id, action.id)) {
            return false;
        }
        return Intrinsics.areEqual(this.actionExecutionPolicy, action.actionExecutionPolicy);
    }

    @JvmStatic
    @NotNull
    public static final Action parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @JvmStatic
    @NotNull
    public static final Action readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/opensearch/commons/alerting/model/action/Action$Companion;", "", "()V", "ACTION_EXECUTION_POLICY_FIELD", "", "DESTINATION_ID_FIELD", "ID_FIELD", "MESSAGE", "MESSAGE_ID", "MESSAGE_TEMPLATE_FIELD", "MUSTACHE", "NAME_FIELD", "SUBJECT", "SUBJECT_TEMPLATE_FIELD", "THROTTLE_ENABLED_FIELD", "THROTTLE_FIELD", "parse", "Lorg/opensearch/commons/alerting/model/action/Action;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "readFrom", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "common-utils"})
    @SourceDebugExtension(value={"SMAP\nAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Action.kt\norg/opensearch/commons/alerting/model/action/Action$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n1#2:188\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Action parse(@NotNull XContentParser xcp) throws IOException {
            Script script;
            String string;
            Intrinsics.checkNotNullParameter(xcp, "xcp");
            String id = UUIDs.base64UUID();
            String name = null;
            String destinationId = null;
            Script subjectTemplate = null;
            Script messageTemplate = null;
            boolean throttleEnabled = false;
            Throttle throttle = null;
            ActionExecutionPolicy actionExecutionPolicy = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block20: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block34: {
                    fieldName = xcp.currentName();
                    xcp.nextToken();
                    String string2 = fieldName;
                    if (string2 == null) break block34;
                    int n = -1;
                    switch (string2.hashCode()) {
                        case 1483442986: {
                            if (string2.equals(Action.THROTTLE_FIELD)) {
                                n = 1;
                            }
                            break;
                        }
                        case 68621746: {
                            if (string2.equals(Action.MESSAGE_TEMPLATE_FIELD)) {
                                n = 2;
                            }
                            break;
                        }
                        case 1703539500: {
                            if (string2.equals(Action.THROTTLE_ENABLED_FIELD)) {
                                n = 3;
                            }
                            break;
                        }
                        case 912984812: {
                            if (string2.equals(Action.DESTINATION_ID_FIELD)) {
                                n = 4;
                            }
                            break;
                        }
                        case 3373707: {
                            if (string2.equals(Action.NAME_FIELD)) {
                                n = 5;
                            }
                            break;
                        }
                        case -1536902611: {
                            if (string2.equals(Action.SUBJECT_TEMPLATE_FIELD)) {
                                n = 6;
                            }
                            break;
                        }
                        case 3355: {
                            if (string2.equals(Action.ID_FIELD)) {
                                n = 7;
                            }
                            break;
                        }
                        case 1671021346: {
                            if (string2.equals(Action.ACTION_EXECUTION_POLICY_FIELD)) {
                                n = 8;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 7: {
                            id = xcp.text();
                            continue block20;
                        }
                        case 5: {
                            Intrinsics.checkNotNullExpressionValue(xcp.textOrNull(), "textOrNull(...)");
                            continue block20;
                        }
                        case 4: {
                            Intrinsics.checkNotNullExpressionValue(xcp.textOrNull(), "textOrNull(...)");
                            continue block20;
                        }
                        case 6: {
                            subjectTemplate = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : Script.parse((XContentParser)xcp, (String)Action.MUSTACHE);
                            continue block20;
                        }
                        case 2: {
                            Intrinsics.checkNotNullExpressionValue(Script.parse((XContentParser)xcp, (String)Action.MUSTACHE), "parse(...)");
                            continue block20;
                        }
                        case 1: {
                            throttle = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : Throttle.Companion.parse(xcp);
                            continue block20;
                        }
                        case 3: {
                            throttleEnabled = xcp.booleanValue();
                            continue block20;
                        }
                        case 8: {
                            actionExecutionPolicy = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : ActionExecutionPolicy.Companion.parse(xcp);
                            continue block20;
                        }
                    }
                }
                throw new IllegalStateException("Unexpected field: " + fieldName + ", while parsing action");
            }
            if (throttleEnabled && throttle == null) {
                boolean bl = false;
                String string3 = "Action throttle enabled but not set throttle value";
                throw new IllegalArgumentException(string3.toString());
            }
            String string4 = name;
            if (string4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException(Action.NAME_FIELD);
                string4 = null;
            }
            if ((string = destinationId) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("destinationId");
                string = null;
            }
            if ((script = messageTemplate) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("messageTemplate");
                script = null;
            }
            String string5 = id;
            if (string5 == null) {
                String string6 = "Required value was null.";
                throw new IllegalArgumentException(string6.toString());
            }
            ActionExecutionPolicy actionExecutionPolicy2 = actionExecutionPolicy;
            String string7 = string5;
            Throttle throttle2 = throttle;
            boolean bl = throttleEnabled;
            Script script2 = script;
            Script script3 = subjectTemplate;
            String string8 = string;
            String string9 = string4;
            return new Action(string9, string8, script3, script2, bl, throttle2, string7, actionExecutionPolicy2);
        }

        @JvmStatic
        @NotNull
        public final Action readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter(sin, "sin");
            return new Action(sin);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

