/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.OperatorNotReadyException;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsOutputSignerUsingSecureRandom;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.io.DigestOutputStream;

class DSAOutputSigner<T extends Parameters>
extends FipsOutputSignerUsingSecureRandom<T> {
    private final DSA dsa;
    private final Digest digest;
    private final T parameter;
    private final Initializer initializer;
    private final boolean ready;

    DSAOutputSigner(DSA dSA, Digest digest, T t2, Initializer initializer) {
        this(false, dSA, digest, t2, initializer);
    }

    DSAOutputSigner(boolean bl, DSA dSA, Digest digest, T t2, Initializer initializer) {
        this.ready = bl;
        this.dsa = dSA;
        this.digest = digest;
        this.parameter = t2;
        this.initializer = initializer;
    }

    @Override
    public T getParameters() {
        return this.parameter;
    }

    @Override
    public UpdateOutputStream getSigningStream() {
        if (!this.ready) {
            throw new OperatorNotReadyException("Signer requires a SecureRandom to be attached before use");
        }
        return new DigestOutputStream(this.digest);
    }

    @Override
    public byte[] getSignature() throws PlainInputProcessingException {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        try {
            return this.encode(this.dsa.generateSignature(byArray));
        }
        catch (Exception exception) {
            throw new PlainInputProcessingException("Unable to create signature: " + exception.getMessage(), exception);
        }
    }

    @Override
    public int getSignature(byte[] byArray, int n) throws PlainInputProcessingException {
        byte[] byArray2 = this.getSignature();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    private byte[] encode(BigInteger[] bigIntegerArray) throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(bigIntegerArray[0]));
        aSN1EncodableVector.add(new ASN1Integer(bigIntegerArray[1]));
        return new DERSequence(aSN1EncodableVector).getEncoded("DER");
    }

    @Override
    public DSAOutputSigner<T> withSecureRandom(SecureRandom secureRandom) {
        this.initializer.initialize(this.dsa, secureRandom);
        return new DSAOutputSigner<T>(true, this.dsa, this.digest, this.parameter, this.initializer);
    }

    static interface Initializer {
        public void initialize(DSA var1, SecureRandom var2);
    }
}

