/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunctionalOperator;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.MapSqlType;
import org.apache.calcite.sql.type.MultisetSqlType;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;

public class SqlUnnestOperator
extends SqlFunctionalOperator {
    public final boolean withOrdinality;
    public static final String ORDINALITY_COLUMN_NAME = "ORDINALITY";
    public static final String MAP_KEY_COLUMN_NAME = "KEY";
    public static final String MAP_VALUE_COLUMN_NAME = "VALUE";

    public SqlUnnestOperator(boolean withOrdinality) {
        super("UNNEST", SqlKind.UNNEST, 200, true, null, null, OperandTypes.repeat(SqlOperandCountRanges.from(1), OperandTypes.SCALAR_OR_RECORD_COLLECTION_OR_MAP));
        this.withOrdinality = withOrdinality;
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        for (Integer operand : Util.range(opBinding.getOperandCount())) {
            RelDataType type2 = opBinding.getOperandType(operand);
            if (type2.getSqlTypeName() == SqlTypeName.ANY) {
                return ((RelDataTypeFactory.Builder)builder).add("$unnest", SqlTypeName.ANY).nullable(true).build();
            }
            if (type2.isStruct()) {
                type2 = type2.getFieldList().get(0).getType();
            }
            assert (type2 instanceof ArraySqlType || type2 instanceof MultisetSqlType || type2 instanceof MapSqlType);
            if (type2 instanceof MapSqlType) {
                MapSqlType mapType = (MapSqlType)type2;
                ((RelDataTypeFactory.Builder)builder).add(MAP_KEY_COLUMN_NAME, mapType.getKeyType());
                ((RelDataTypeFactory.Builder)builder).add(MAP_VALUE_COLUMN_NAME, mapType.getValueType());
                continue;
            }
            RelDataType componentType = Objects.requireNonNull(type2.getComponentType(), "componentType");
            if (!SqlUnnestOperator.allowAliasUnnestItems(opBinding) && componentType.isStruct()) {
                ((RelDataTypeFactory.Builder)builder).addAll(componentType.getFieldList());
                continue;
            }
            ((RelDataTypeFactory.Builder)builder).add(SqlUtil.deriveAliasFromOrdinal(operand), componentType);
        }
        if (this.withOrdinality) {
            ((RelDataTypeFactory.Builder)builder).add(ORDINALITY_COLUMN_NAME, SqlTypeName.INTEGER);
        }
        return builder.build();
    }

    private static boolean allowAliasUnnestItems(SqlOperatorBinding operatorBinding) {
        return operatorBinding instanceof SqlCallBinding && ((SqlCallBinding)operatorBinding).getValidator().config().conformance().allowAliasUnnestItems();
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        if (call.operandCount() == 1 && call.getOperandList().get(0).getKind() == SqlKind.SELECT) {
            writer.keyword(this.getName());
            ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        } else {
            super.unparse(writer, call, leftPrec, rightPrec);
        }
        if (this.withOrdinality) {
            writer.keyword("WITH ORDINALITY");
        }
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return false;
    }
}

