/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import java.util.Locale;
import org.locationtech.jts.operation.buffer.BufferParameters;

public class BufferStyle {
    private int quadrantSegments = 8;
    private int endCapStyle = 1;
    private int joinStyle = 1;
    private int side = 0;

    public BufferStyle(String style) {
        String[] parameters2;
        block44: for (String parameter : parameters2 = style.toLowerCase(Locale.ROOT).split(" ")) {
            if (parameter == null || parameter.isEmpty()) continue;
            String[] keyValue = parameter.split("=");
            if (keyValue.length != 2) {
                throw new IllegalArgumentException("Invalid buffer style: " + style);
            }
            String key = keyValue[0];
            String value = keyValue[1];
            switch (key) {
                case "quad_segs": {
                    try {
                        this.quadrantSegments = Integer.parseInt(value);
                        continue block44;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid buffer style: " + style);
                    }
                }
                case "endcap": {
                    switch (value) {
                        case "round": {
                            this.endCapStyle = 1;
                            continue block44;
                        }
                        case "flat": {
                            this.endCapStyle = 2;
                            continue block44;
                        }
                        case "square": {
                            this.endCapStyle = 3;
                            continue block44;
                        }
                    }
                    throw new IllegalArgumentException("Invalid buffer style: " + style);
                }
                case "join": {
                    switch (value) {
                        case "round": {
                            this.joinStyle = 1;
                            continue block44;
                        }
                        case "mitre": {
                            this.joinStyle = 2;
                            continue block44;
                        }
                        case "bevel": {
                            this.joinStyle = 3;
                            continue block44;
                        }
                    }
                    throw new IllegalArgumentException("Invalid buffer style: " + style);
                }
                case "side": {
                    switch (value) {
                        case "left": {
                            ++this.side;
                            continue block44;
                        }
                        case "right": {
                            --this.side;
                            continue block44;
                        }
                        case "both": {
                            this.side = 0;
                            continue block44;
                        }
                    }
                    throw new IllegalArgumentException("Invalid buffer style: " + style);
                }
            }
        }
    }

    public double asSidedDistance(double distance) {
        return this.side != 0 ? distance * (double)this.side : distance;
    }

    public BufferParameters asBufferParameters() {
        BufferParameters params = new BufferParameters();
        params.setQuadrantSegments(this.quadrantSegments);
        params.setEndCapStyle(this.endCapStyle);
        params.setJoinStyle(this.joinStyle);
        params.setSingleSided(this.side != 0);
        return params;
    }
}

