/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.Spaces;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCallBinding;
import org.apache.calcite.rex.RexCopier;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLambda;
import org.apache.calcite.rex.RexLambdaRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.calcite.rex.RexWindowExclusion;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.MapSqlType;
import org.apache.calcite.sql.type.MultisetSqlType;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Sarg;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimeWithTimeZoneString;
import org.apache.calcite.util.TimestampString;
import org.apache.calcite.util.TimestampWithTimeZoneString;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.locationtech.jts.geom.Geometry;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.base.Verify;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableRangeSet;
import shaded.com.google.common.collect.Range;
import shaded.com.google.common.collect.TreeRangeSet;

public class RexBuilder {
    public static final SqlSpecialOperator GET_OPERATOR = new SqlSpecialOperator("_get", SqlKind.OTHER_FUNCTION);
    private static final BigDecimal INT_MIN = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal INT_MAX = BigDecimal.valueOf(Integer.MAX_VALUE);
    protected final RelDataTypeFactory typeFactory;
    private final RexLiteral booleanTrue;
    private final RexLiteral booleanFalse;
    private final RexLiteral charEmpty;
    private final RexLiteral constantNull;
    private final SqlStdOperatorTable opTab = SqlStdOperatorTable.instance();

    public RexBuilder(RelDataTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
        this.booleanTrue = this.makeLiteral(Boolean.TRUE, typeFactory.createSqlType(SqlTypeName.BOOLEAN), SqlTypeName.BOOLEAN);
        this.booleanFalse = this.makeLiteral(Boolean.FALSE, typeFactory.createSqlType(SqlTypeName.BOOLEAN), SqlTypeName.BOOLEAN);
        this.charEmpty = this.makeLiteral(new NlsString("", null, null), typeFactory.createSqlType(SqlTypeName.CHAR, 0), SqlTypeName.CHAR);
        this.constantNull = this.makeLiteral(null, typeFactory.createSqlType(SqlTypeName.NULL), SqlTypeName.NULL);
    }

    public List<RexNode> identityProjects(RelDataType rowType) {
        return Util.transform(rowType.getFieldList(), input -> new RexInputRef(input.getIndex(), input.getType()));
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public SqlStdOperatorTable getOpTab() {
        return this.opTab;
    }

    public RexNode makeFieldAccess(RexNode expr, String fieldName, boolean caseSensitive) {
        RelDataType type2 = expr.getType();
        RelDataTypeField field = type2.getField(fieldName, caseSensitive, false);
        if (field == null) {
            throw new AssertionError((Object)("Type '" + type2 + "' has no field '" + fieldName + "'"));
        }
        return this.makeFieldAccessInternal(expr, field);
    }

    public RexNode makeFieldAccess(RexNode expr, int i) {
        RelDataType type2 = expr.getType();
        List<RelDataTypeField> fields2 = type2.getFieldList();
        if (i < 0 || i >= fields2.size()) {
            throw new AssertionError((Object)("Field ordinal " + i + " is invalid for  type '" + type2 + "'"));
        }
        return this.makeFieldAccessInternal(expr, fields2.get(i));
    }

    private RexNode makeFieldAccessInternal(RexNode expr, RelDataTypeField field) {
        if (expr instanceof RexRangeRef) {
            RexRangeRef range = (RexRangeRef)expr;
            if (field.getIndex() < 0) {
                return this.makeCall(field.getType(), (SqlOperator)GET_OPERATOR, ImmutableList.of(expr, this.makeLiteral(field.getName())));
            }
            return new RexInputRef(range.getOffset() + field.getIndex(), field.getType());
        }
        return new RexFieldAccess(expr, field);
    }

    public RexNode makeCall(RelDataType returnType, SqlOperator op, List<RexNode> exprs) {
        return this.makeCall(SqlParserPos.ZERO, returnType, op, exprs);
    }

    public RexNode makeCall(SqlParserPos pos, RelDataType returnType, SqlOperator op, List<RexNode> exprs) {
        return new RexCall(pos, returnType, op, exprs);
    }

    public RexNode makeCall(SqlOperator op, List<? extends RexNode> exprs) {
        return this.makeCall(SqlParserPos.ZERO, op, exprs);
    }

    public RexNode makeCall(SqlParserPos pos, SqlOperator op, List<? extends RexNode> exprs) {
        RelDataType type2 = this.deriveReturnType(op, exprs);
        return new RexCall(pos, type2, op, exprs);
    }

    public final RexNode makeCall(SqlOperator op, RexNode ... exprs) {
        return this.makeCall(SqlParserPos.ZERO, op, exprs);
    }

    public final RexNode makeCall(SqlParserPos pos, SqlOperator op, RexNode ... exprs) {
        return this.makeCall(pos, op, ImmutableList.copyOf(exprs));
    }

    public RelDataType deriveReturnType(SqlOperator op, List<? extends RexNode> exprs) {
        return op.inferReturnType(new RexCallBinding(this.typeFactory, op, exprs, ImmutableList.of()));
    }

    public RexNode addAggCall(AggregateCall aggCall, int groupCount, List<AggregateCall> aggCalls, Map<AggregateCall, RexNode> aggCallMapping, IntPredicate isNullable) {
        RexNode rex;
        if (aggCall.getAggregation() instanceof SqlCountAggFunction && !aggCall.isDistinct()) {
            List<Integer> args2 = aggCall.getArgList();
            List<Integer> nullableArgs = RexBuilder.nullableArgs(args2, isNullable);
            aggCall = aggCall.withArgList(nullableArgs);
        }
        if ((rex = aggCallMapping.get(aggCall)) == null) {
            int index = aggCalls.size() + groupCount;
            aggCalls.add(aggCall);
            rex = this.makeInputRef(aggCall.getType(), index);
            aggCallMapping.put(aggCall, rex);
        }
        return rex;
    }

    @Deprecated
    public RexNode addAggCall(AggregateCall aggCall, int groupCount, List<AggregateCall> aggCalls, Map<AggregateCall, RexNode> aggCallMapping, @Nullable List<RelDataType> aggArgTypes) {
        return this.addAggCall(aggCall, groupCount, aggCalls, aggCallMapping, (int i) -> ((RelDataType)Objects.requireNonNull(aggArgTypes, "aggArgTypes").get(aggCall.getArgList().indexOf(i))).isNullable());
    }

    @Deprecated
    public RexNode addAggCall(AggregateCall aggCall, int groupCount, boolean indicator, List<AggregateCall> aggCalls, Map<AggregateCall, RexNode> aggCallMapping, @Nullable List<RelDataType> aggArgTypes) {
        Preconditions.checkArgument(!indicator, "indicator is deprecated, use GROUPING function instead");
        return this.addAggCall(aggCall, groupCount, aggCalls, aggCallMapping, aggArgTypes);
    }

    private static List<Integer> nullableArgs(List<Integer> list0, IntPredicate isNullable) {
        return list0.stream().filter(isNullable::test).collect(ImmutableList.toImmutableList());
    }

    @Deprecated
    public RexNode makeOver(RelDataType type2, SqlAggFunction operator, List<RexNode> exprs, List<RexNode> partitionKeys, ImmutableList<RexFieldCollation> orderKeys, RexWindowBound lowerBound, RexWindowBound upperBound, boolean rows, boolean allowPartial, boolean nullWhenCountZero, boolean distinct2) {
        return this.makeOver(type2, operator, exprs, partitionKeys, orderKeys, lowerBound, upperBound, rows, allowPartial, nullWhenCountZero, distinct2, false);
    }

    public RexNode makeOver(RelDataType type2, SqlAggFunction operator, List<RexNode> exprs, List<RexNode> partitionKeys, ImmutableList<RexFieldCollation> orderKeys, RexWindowBound lowerBound, RexWindowBound upperBound, boolean rows, boolean allowPartial, boolean nullWhenCountZero, boolean distinct2, boolean ignoreNulls) {
        return this.makeOver(type2, operator, exprs, partitionKeys, orderKeys, lowerBound, upperBound, RexWindowExclusion.EXCLUDE_NO_OTHER, rows, allowPartial, nullWhenCountZero, distinct2, ignoreNulls);
    }

    public RexNode makeOver(RelDataType type2, SqlAggFunction operator, List<RexNode> exprs, List<RexNode> partitionKeys, ImmutableList<RexFieldCollation> orderKeys, RexWindowBound lowerBound, RexWindowBound upperBound, RexWindowExclusion exclude, boolean rows, boolean allowPartial, boolean nullWhenCountZero, boolean distinct2, boolean ignoreNulls) {
        RelDataType bigintType;
        RexWindow window = this.makeWindow(partitionKeys, orderKeys, lowerBound, upperBound, rows, exclude);
        RexNode result2 = new RexOver(type2, operator, exprs, window, distinct2, ignoreNulls);
        if (nullWhenCountZero) {
            bigintType = this.typeFactory.createSqlType(SqlTypeName.BIGINT);
            result2 = this.makeCall((SqlOperator)SqlStdOperatorTable.CASE, this.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexOver(bigintType, SqlStdOperatorTable.COUNT, exprs, window, distinct2, ignoreNulls), this.makeLiteral(BigDecimal.ZERO, bigintType, SqlTypeName.DECIMAL)), this.ensureType(type2, new RexOver(this.typeFactory.createTypeWithNullability(type2, false), operator, exprs, window, distinct2, ignoreNulls), false), this.makeNullLiteral(type2));
        }
        if (!allowPartial) {
            Preconditions.checkArgument(rows, "DISALLOW PARTIAL over RANGE");
            bigintType = this.typeFactory.createSqlType(SqlTypeName.BIGINT);
            result2 = this.makeCall((SqlOperator)SqlStdOperatorTable.CASE, this.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexOver(bigintType, SqlStdOperatorTable.COUNT, ImmutableList.of(), window, distinct2, ignoreNulls), this.makeLiteral(BigDecimal.valueOf(2L), bigintType, SqlTypeName.DECIMAL)), result2, this.constantNull);
        }
        return result2;
    }

    public RexWindow makeWindow(List<RexNode> partitionKeys, ImmutableList<RexFieldCollation> orderKeys, RexWindowBound lowerBound, RexWindowBound upperBound, boolean rows) {
        return this.makeWindow(partitionKeys, orderKeys, lowerBound, upperBound, rows, RexWindowExclusion.EXCLUDE_NO_OTHER);
    }

    public RexWindow makeWindow(List<RexNode> partitionKeys, ImmutableList<RexFieldCollation> orderKeys, RexWindowBound lowerBound, RexWindowBound upperBound, boolean rows, RexWindowExclusion exclude) {
        if (orderKeys.isEmpty() && !rows) {
            lowerBound = RexWindowBounds.UNBOUNDED_PRECEDING;
            upperBound = RexWindowBounds.UNBOUNDED_FOLLOWING;
        }
        if (lowerBound.isUnboundedPreceding() && upperBound.isUnboundedFollowing()) {
            rows = false;
        }
        return new RexWindow(partitionKeys, orderKeys, lowerBound, upperBound, rows, exclude);
    }

    @Deprecated
    public RexLiteral constantNull() {
        return this.constantNull;
    }

    public RexNode makeCorrel(RelDataType type2, CorrelationId id) {
        return new RexCorrelVariable(id, type2);
    }

    public RexNode makeNewInvocation(RelDataType type2, List<RexNode> exprs) {
        return new RexCall(type2, SqlStdOperatorTable.NEW, exprs);
    }

    public RexNode makeCast(RelDataType type2, RexNode exp) {
        return this.makeCast(type2, exp, false, false, this.constantNull);
    }

    public RexNode makeCast(SqlParserPos pos, RelDataType type2, RexNode exp) {
        return this.makeCast(pos, type2, exp, false, false, this.constantNull);
    }

    @Deprecated
    public RexNode makeCast(RelDataType type2, RexNode exp, boolean matchNullability) {
        return this.makeCast(type2, exp, matchNullability, false, this.constantNull);
    }

    public RexNode makeCast(SqlParserPos pos, RelDataType type2, RexNode exp, boolean matchNullability, boolean safe) {
        return this.makeCast(pos, type2, exp, matchNullability, safe, this.constantNull);
    }

    public RexNode makeCast(RelDataType type2, RexNode exp, boolean matchNullability, boolean safe) {
        return this.makeCast(type2, exp, matchNullability, safe, this.constantNull);
    }

    public RexNode makeCast(RelDataType type2, RexNode exp, boolean matchNullability, boolean safe, RexLiteral format) {
        return this.makeCast(SqlParserPos.ZERO, type2, exp, matchNullability, safe, format);
    }

    public RexNode makeCast(SqlParserPos pos, RelDataType type2, RexNode exp, boolean matchNullability, boolean safe, RexLiteral format) {
        SqlTypeName sqlType = type2.getSqlTypeName();
        if (exp instanceof RexLiteral) {
            RexLiteral literal = (RexLiteral)exp;
            Comparable value = literal.getValueAs(Comparable.class);
            SqlTypeName typeName = literal.getTypeName();
            if (exp.getType().getSqlTypeName() == SqlTypeName.BOOLEAN && SqlTypeUtil.isExactNumeric(type2)) {
                return this.makeCastBooleanToExact(type2, exp);
            }
            if (this.canRemoveCastFromLiteral(type2, value, typeName)) {
                block0 : switch (typeName) {
                    case INTERVAL_YEAR: 
                    case INTERVAL_YEAR_MONTH: 
                    case INTERVAL_MONTH: 
                    case INTERVAL_DAY: 
                    case INTERVAL_DAY_HOUR: 
                    case INTERVAL_DAY_MINUTE: 
                    case INTERVAL_DAY_SECOND: 
                    case INTERVAL_HOUR: 
                    case INTERVAL_HOUR_MINUTE: 
                    case INTERVAL_HOUR_SECOND: 
                    case INTERVAL_MINUTE: 
                    case INTERVAL_MINUTE_SECOND: 
                    case INTERVAL_SECOND: {
                        assert (value instanceof BigDecimal);
                        typeName = type2.getSqlTypeName();
                        switch (typeName) {
                            case BIGINT: 
                            case INTEGER: 
                            case SMALLINT: 
                            case TINYINT: 
                            case DOUBLE: 
                            case FLOAT: 
                            case REAL: 
                            case DECIMAL: {
                                BigDecimal value2 = (BigDecimal)value;
                                BigDecimal multiplier = RexBuilder.baseUnit((SqlTypeName)literal.getTypeName()).multiplier;
                                BigDecimal divider = literal.getTypeName().getEndUnit().multiplier;
                                value = value2.multiply(multiplier).divide(divider, 0, RoundingMode.HALF_DOWN);
                                break;
                            }
                        }
                        switch (typeName) {
                            case INTEGER: {
                                typeName = SqlTypeName.BIGINT;
                                break block0;
                            }
                        }
                        break;
                    }
                }
                RexLiteral literal2 = this.makeLiteral(value, type2, typeName);
                if (type2.isNullable() && !literal2.getType().isNullable() && matchNullability) {
                    return this.makeAbstractCast(pos, type2, literal2, safe, format);
                }
                return literal2;
            }
        } else {
            if (SqlTypeUtil.isExactNumeric(type2) && SqlTypeUtil.isInterval(exp.getType())) {
                return this.makeCastIntervalToExact(pos, type2, exp);
            }
            if (sqlType == SqlTypeName.BOOLEAN && SqlTypeUtil.isExactNumeric(exp.getType())) {
                return this.makeCastExactToBoolean(type2, exp);
            }
            if (exp.getType().getSqlTypeName() == SqlTypeName.BOOLEAN && SqlTypeUtil.isExactNumeric(type2)) {
                return this.makeCastBooleanToExact(type2, exp);
            }
        }
        return this.makeAbstractCast(pos, type2, exp, safe, format);
    }

    protected static TimeUnit baseUnit(SqlTypeName unit) {
        if (unit.isYearMonth()) {
            return TimeUnit.MONTH;
        }
        return TimeUnit.MILLISECOND;
    }

    boolean canRemoveCastFromLiteral(RelDataType toType, @Nullable Comparable value, SqlTypeName fromTypeName) {
        if (value == null) {
            return true;
        }
        SqlTypeName sqlType = toType.getSqlTypeName();
        if (sqlType == SqlTypeName.MEASURE) {
            return false;
        }
        if (!RexLiteral.valueMatchesType(value, sqlType, false)) {
            return false;
        }
        if (toType.getSqlTypeName() != fromTypeName && (SqlTypeFamily.DATETIME.getTypeNames().contains((Object)fromTypeName) || SqlTypeFamily.INTERVAL_DAY_TIME.getTypeNames().contains((Object)fromTypeName) || SqlTypeFamily.INTERVAL_YEAR_MONTH.getTypeNames().contains((Object)fromTypeName))) {
            return false;
        }
        if (value instanceof NlsString) {
            int length = ((NlsString)value).getValue().length();
            switch (toType.getSqlTypeName()) {
                case CHAR: {
                    return SqlTypeUtil.comparePrecision(toType.getPrecision(), length) == 0;
                }
                case VARCHAR: {
                    return SqlTypeUtil.comparePrecision(toType.getPrecision(), length) >= 0;
                }
            }
            throw new AssertionError(toType);
        }
        if (value instanceof ByteString) {
            int length = ((ByteString)value).length();
            switch (toType.getSqlTypeName()) {
                case BINARY: {
                    return SqlTypeUtil.comparePrecision(toType.getPrecision(), length) == 0;
                }
                case VARBINARY: {
                    return SqlTypeUtil.comparePrecision(toType.getPrecision(), length) >= 0;
                }
            }
            throw new AssertionError(toType);
        }
        if (toType.getSqlTypeName() == SqlTypeName.DECIMAL && fromTypeName.getFamily() == SqlTypeFamily.NUMERIC) {
            BigDecimal decimalValue = (BigDecimal)value;
            return SqlTypeUtil.canBeRepresentedExactly(decimalValue, toType);
        }
        if (SqlTypeName.INT_TYPES.contains((Object)sqlType)) {
            BigDecimal decimalValue = (BigDecimal)value;
            try {
                long l = decimalValue.longValueExact();
                switch (sqlType) {
                    case TINYINT: {
                        return l >= -128L && l <= 127L;
                    }
                    case SMALLINT: {
                        return l >= -32768L && l <= 32767L;
                    }
                    case INTEGER: {
                        return l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE;
                    }
                }
                return true;
            }
            catch (ArithmeticException ex) {
                return false;
            }
        }
        return true;
    }

    private RexNode makeCastExactToBoolean(RelDataType toType, RexNode exp) {
        return this.makeCall(toType, (SqlOperator)SqlStdOperatorTable.NOT_EQUALS, ImmutableList.of(exp, this.makeZeroLiteral(exp.getType())));
    }

    private RexNode makeCastBooleanToExact(RelDataType toType, RexNode exp) {
        RexNode casted = this.makeCall((SqlOperator)SqlStdOperatorTable.CASE, exp, this.makeExactLiteral(BigDecimal.ONE, toType), this.makeZeroLiteral(toType));
        if (!exp.getType().isNullable()) {
            return casted;
        }
        return this.makeCall(toType, (SqlOperator)SqlStdOperatorTable.CASE, ImmutableList.of(this.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, exp), casted, this.makeNullLiteral(toType)));
    }

    private RexNode makeCastIntervalToExact(SqlParserPos pos, RelDataType toType, RexNode exp) {
        TimeUnit endUnit = exp.getType().getSqlTypeName().getEndUnit();
        TimeUnit baseUnit = RexBuilder.baseUnit(exp.getType().getSqlTypeName());
        BigDecimal multiplier = baseUnit.multiplier;
        BigDecimal divider = endUnit.multiplier;
        RexNode value = this.multiplyDivide(pos, this.decodeIntervalOrDecimal(pos, exp), multiplier, divider);
        return this.ensureType(pos, toType, value, false);
    }

    public RexNode multiplyDivide(RexNode e, BigDecimal multiplier, BigDecimal divider) {
        return this.multiplyDivide(SqlParserPos.ZERO, e, multiplier, divider);
    }

    public RexNode multiplyDivide(SqlParserPos pos, RexNode e, BigDecimal multiplier, BigDecimal divider) {
        assert (multiplier.signum() > 0);
        assert (divider.signum() > 0);
        switch (multiplier.compareTo(divider)) {
            case 0: {
                return e;
            }
            case 1: {
                return this.makeCall(pos, (SqlOperator)SqlStdOperatorTable.MULTIPLY, e, this.makeExactLiteral(multiplier.divide(divider, RoundingMode.UNNECESSARY)));
            }
            case -1: {
                return this.makeCall(pos, (SqlOperator)SqlStdOperatorTable.DIVIDE_INTEGER, e, this.makeExactLiteral(divider.divide(multiplier, RoundingMode.UNNECESSARY)));
            }
        }
        throw new AssertionError((Object)(multiplier + "/" + divider));
    }

    public RexNode encodeIntervalOrDecimal(RexNode value, RelDataType type2, boolean checkOverflow) {
        return this.encodeIntervalOrDecimal(SqlParserPos.ZERO, value, type2, checkOverflow);
    }

    public RexNode encodeIntervalOrDecimal(SqlParserPos pos, RexNode value, RelDataType type2, boolean checkOverflow) {
        RelDataType bigintType = this.typeFactory.createSqlType(SqlTypeName.BIGINT);
        RexNode cast = this.ensureType(pos, bigintType, value, true);
        return this.makeReinterpretCast(pos, type2, cast, this.makeLiteral(checkOverflow));
    }

    public RexNode decodeIntervalOrDecimal(RexNode node) {
        return this.decodeIntervalOrDecimal(SqlParserPos.ZERO, node);
    }

    public RexNode decodeIntervalOrDecimal(SqlParserPos pos, RexNode node) {
        assert (SqlTypeUtil.isDecimal(node.getType()) || SqlTypeUtil.isInterval(node.getType()));
        RelDataType bigintType = this.typeFactory.createSqlType(SqlTypeName.BIGINT);
        return this.makeReinterpretCast(pos, this.matchNullability(bigintType, node), node, this.makeLiteral(false));
    }

    @Deprecated
    public RexNode makeAbstractCast(RelDataType type2, RexNode exp) {
        return this.makeAbstractCast(type2, exp, false);
    }

    public RexNode makeAbstractCast(RelDataType type2, RexNode exp, boolean safe) {
        return this.makeAbstractCast(SqlParserPos.ZERO, type2, exp, safe);
    }

    public RexNode makeAbstractCast(SqlParserPos pos, RelDataType type2, RexNode exp, boolean safe) {
        SqlFunction operator = safe ? SqlLibraryOperators.SAFE_CAST : SqlStdOperatorTable.CAST;
        return new RexCall(pos, type2, operator, ImmutableList.of(exp));
    }

    public RexNode makeAbstractCast(RelDataType type2, RexNode exp, boolean safe, RexLiteral format) {
        return this.makeAbstractCast(SqlParserPos.ZERO, type2, exp, safe, format);
    }

    public RexNode makeAbstractCast(SqlParserPos pos, RelDataType type2, RexNode exp, boolean safe, RexLiteral format) {
        SqlFunction operator;
        SqlFunction sqlFunction = operator = safe ? SqlLibraryOperators.SAFE_CAST : SqlStdOperatorTable.CAST;
        if (format.isNull()) {
            return new RexCall(pos, type2, operator, ImmutableList.of(exp));
        }
        return new RexCall(pos, type2, operator, ImmutableList.of(exp, format));
    }

    public RexNode makeReinterpretCast(RelDataType type2, RexNode exp, RexNode checkOverflow) {
        return this.makeReinterpretCast(SqlParserPos.ZERO, type2, exp, checkOverflow);
    }

    public RexNode makeReinterpretCast(SqlParserPos pos, RelDataType type2, RexNode exp, RexNode checkOverflow) {
        ImmutableList<RexNode> args2 = checkOverflow.isAlwaysTrue() ? ImmutableList.of(exp, checkOverflow) : ImmutableList.of(exp);
        return new RexCall(pos, type2, SqlStdOperatorTable.REINTERPRET, args2);
    }

    public RexNode makeNullable(RexNode exp) {
        return this.makeNullable(exp, true);
    }

    public RexNode makeNotNull(RexNode exp) {
        return this.makeNullable(exp, false);
    }

    public RexNode makeNullable(RexNode exp, boolean nullability) {
        RelDataType type2 = exp.getType();
        if (type2.isNullable() == nullability) {
            return exp;
        }
        RelDataType type22 = this.typeFactory.createTypeWithNullability(type2, nullability);
        return this.makeAbstractCast(SqlParserPos.ZERO, type22, exp, false);
    }

    public RexNode makeRangeReference(RelNode input) {
        return new RexRangeRef(input.getRowType(), 0);
    }

    public RexRangeRef makeRangeReference(RelDataType type2, int offset, boolean nullable) {
        if (nullable && !type2.isNullable()) {
            type2 = this.typeFactory.createTypeWithNullability(type2, nullable);
        }
        return new RexRangeRef(type2, offset);
    }

    public RexInputRef makeInputRef(RelDataType type2, int i) {
        type2 = SqlTypeUtil.addCharsetAndCollation(type2, this.typeFactory);
        return new RexInputRef(i, type2);
    }

    public RexInputRef makeInputRef(RelNode input, int i) {
        return this.makeInputRef(input.getRowType().getFieldList().get(i).getType(), i);
    }

    public RexPatternFieldRef makePatternFieldRef(String alpha, RelDataType type2, int i) {
        type2 = SqlTypeUtil.addCharsetAndCollation(type2, this.typeFactory);
        return new RexPatternFieldRef(alpha, i, type2);
    }

    public RexLocalRef makeLocalRef(RelDataType type2, int i) {
        type2 = SqlTypeUtil.addCharsetAndCollation(type2, this.typeFactory);
        return new RexLocalRef(i, type2);
    }

    public RexLiteral makeFlag(Enum flag) {
        return this.makeLiteral((Comparable)((Object)Objects.requireNonNull(flag, "flag")), this.typeFactory.createSqlType(SqlTypeName.SYMBOL), SqlTypeName.SYMBOL);
    }

    protected RexLiteral makeLiteral(@Nullable Comparable o, RelDataType type2, SqlTypeName typeName) {
        type2 = this.typeFactory.createTypeWithNullability(type2, o == null);
        switch (typeName) {
            case CHAR: {
                assert (o instanceof NlsString);
                NlsString nlsString = (NlsString)o;
                if (nlsString.getCollation() != null && nlsString.getCharset() != null && Objects.equals(nlsString.getCharset(), type2.getCharset()) && Objects.equals(nlsString.getCollation(), type2.getCollation())) break;
                assert (type2.getSqlTypeName() == SqlTypeName.CHAR || type2.getSqlTypeName() == SqlTypeName.VARCHAR);
                Charset charset = Objects.requireNonNull(type2.getCharset(), "type.getCharset()");
                SqlCollation collation = Objects.requireNonNull(type2.getCollation(), "type.getCollation()");
                o = new NlsString(nlsString.getValue(), charset.name(), collation);
                break;
            }
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: {
                assert (o instanceof TimeString);
                int p = type2.getPrecision();
                if (p == -1) {
                    p = 0;
                }
                o = ((TimeString)o).round(p);
                break;
            }
            case TIME_TZ: {
                assert (o instanceof TimeWithTimeZoneString);
                int p = type2.getPrecision();
                if (p == -1) {
                    p = 0;
                }
                o = ((TimeWithTimeZoneString)o).round(p);
                break;
            }
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                assert (o instanceof TimestampString);
                int p = type2.getPrecision();
                if (p == -1) {
                    p = 0;
                }
                o = ((TimestampString)o).round(p);
                break;
            }
            case TIMESTAMP_TZ: {
                assert (o instanceof TimestampWithTimeZoneString);
                int p = type2.getPrecision();
                if (p == -1) {
                    p = 0;
                }
                o = ((TimestampWithTimeZoneString)o).round(p);
                break;
            }
            case DECIMAL: {
                if (o == null || type2.getScale() == Integer.MIN_VALUE) break;
                assert (o instanceof BigDecimal);
                o = ((BigDecimal)o).setScale(type2.getScale(), this.typeFactory.getTypeSystem().roundingMode());
                if (type2.getScale() >= 0) break;
                o = new BigDecimal(((BigDecimal)o).toPlainString());
                break;
            }
        }
        if (typeName == SqlTypeName.DECIMAL && !SqlTypeUtil.isValidDecimalValue((BigDecimal)o, type2)) {
            throw new IllegalArgumentException("Cannot convert " + o + " to " + type2 + " due to overflow");
        }
        return new RexLiteral(o, type2, typeName);
    }

    public RexLiteral makeLiteral(boolean b) {
        return b ? this.booleanTrue : this.booleanFalse;
    }

    public RexLiteral makeExactLiteral(BigDecimal bd) {
        int precision;
        int scale = bd.scale();
        assert (scale >= 0);
        assert (scale <= this.typeFactory.getTypeSystem().getMaxNumericScale()) : scale;
        RelDataType relType = scale == 0 ? (bd.compareTo(INT_MIN) >= 0 && bd.compareTo(INT_MAX) <= 0 ? this.typeFactory.createSqlType(SqlTypeName.INTEGER) : this.typeFactory.createSqlType(SqlTypeName.BIGINT)) : ((precision = bd.unscaledValue().abs().toString().length()) > scale ? this.typeFactory.createSqlType(SqlTypeName.DECIMAL, precision, scale) : this.typeFactory.createSqlType(SqlTypeName.DECIMAL, scale + 1, scale));
        return this.makeExactLiteral(bd, relType);
    }

    public RexLiteral makeBigintLiteral(@Nullable BigDecimal bd) {
        RelDataType bigintType = this.typeFactory.createSqlType(SqlTypeName.BIGINT);
        return this.makeLiteral(bd, bigintType, SqlTypeName.DECIMAL);
    }

    public RexLiteral makeExactLiteral(@Nullable BigDecimal bd, RelDataType type2) {
        return this.makeLiteral(bd, type2, SqlTypeName.DECIMAL);
    }

    public RexLiteral makeBinaryLiteral(ByteString byteString) {
        return this.makeLiteral(byteString, this.typeFactory.createSqlType(SqlTypeName.BINARY, byteString.length()), SqlTypeName.BINARY);
    }

    public RexLiteral makeApproxLiteral(BigDecimal bd) {
        if (bd.doubleValue() == 0.0) {
            bd = BigDecimal.ZERO;
        }
        return this.makeApproxLiteral(bd, this.typeFactory.createSqlType(SqlTypeName.DOUBLE));
    }

    public RexLiteral makeApproxLiteral(@Nullable BigDecimal bd, RelDataType type2) {
        assert (SqlTypeFamily.APPROXIMATE_NUMERIC.getTypeNames().contains((Object)type2.getSqlTypeName()));
        return this.makeLiteral(bd != null ? Double.valueOf(bd.doubleValue()) : null, type2, SqlTypeName.DOUBLE);
    }

    public RexLiteral makeApproxLiteral(Double val, RelDataType type2) {
        assert (SqlTypeFamily.APPROXIMATE_NUMERIC.getTypeNames().contains((Object)type2.getSqlTypeName()));
        return this.makeLiteral(val, type2, SqlTypeName.DOUBLE);
    }

    public RexLiteral makeSearchArgumentLiteral(Sarg s2, RelDataType type2) {
        return this.makeLiteral(Objects.requireNonNull(s2, "s"), type2, SqlTypeName.SARG);
    }

    public RexLiteral makeLiteral(String s2) {
        return this.makePreciseStringLiteral(Objects.requireNonNull(s2, "s"));
    }

    protected RexLiteral makePreciseStringLiteral(String s2) {
        if (s2.isEmpty()) {
            return this.charEmpty;
        }
        return this.makeCharLiteral(new NlsString(s2, null, null));
    }

    protected RexLiteral makePreciseStringLiteral(ByteString value, String charsetName, SqlCollation collation) {
        return this.makeCharLiteral(new NlsString(value, charsetName, collation));
    }

    public RexNode ensureType(RelDataType type2, RexNode node, boolean matchNullability) {
        return this.ensureType(SqlParserPos.ZERO, type2, node, matchNullability);
    }

    public RexNode ensureType(SqlParserPos pos, RelDataType type2, RexNode node, boolean matchNullability) {
        RelDataType targetType = type2;
        if (matchNullability) {
            targetType = this.matchNullability(type2, node);
        }
        if (!(targetType.getSqlTypeName() != SqlTypeName.ANY || matchNullability && targetType.isNullable() != node.getType().isNullable())) {
            return node;
        }
        if (!node.getType().equals(targetType)) {
            return this.makeCast(pos, targetType, node);
        }
        return node;
    }

    public RelDataType matchNullability(RelDataType type2, RexNode value) {
        boolean valueNullability;
        boolean typeNullability = type2.isNullable();
        if (typeNullability != (valueNullability = value.getType().isNullable())) {
            return this.typeFactory.createTypeWithNullability(type2, valueNullability);
        }
        return type2;
    }

    public RexLiteral makeCharLiteral(NlsString str) {
        RelDataType type2 = SqlUtil.createNlsStringType(this.typeFactory, str);
        return this.makeLiteral(str, type2, SqlTypeName.CHAR);
    }

    @Deprecated
    public RexLiteral makeDateLiteral(Calendar calendar) {
        return this.makeDateLiteral(DateString.fromCalendarFields(calendar));
    }

    public RexLiteral makeDateLiteral(DateString date) {
        return this.makeLiteral(Objects.requireNonNull(date, "date"), this.typeFactory.createSqlType(SqlTypeName.DATE), SqlTypeName.DATE);
    }

    @Deprecated
    public RexLiteral makeTimeLiteral(Calendar calendar, int precision) {
        return this.makeTimeLiteral(TimeString.fromCalendarFields(calendar), precision);
    }

    public RexLiteral makeTimeLiteral(TimeString time, int precision) {
        return this.makeLiteral(Objects.requireNonNull(time, "time"), this.typeFactory.createSqlType(SqlTypeName.TIME, precision), SqlTypeName.TIME);
    }

    public RexLiteral makeTimeWithLocalTimeZoneLiteral(TimeString time, int precision) {
        return this.makeLiteral(Objects.requireNonNull(time, "time"), this.typeFactory.createSqlType(SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE, precision), SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE);
    }

    public RexLiteral makeTimeTzLiteral(TimeWithTimeZoneString time, int precision) {
        return this.makeLiteral(Objects.requireNonNull(time, "time"), this.typeFactory.createSqlType(SqlTypeName.TIME_TZ, precision), SqlTypeName.TIME_TZ);
    }

    @Deprecated
    public RexLiteral makeTimestampLiteral(Calendar calendar, int precision) {
        return this.makeTimestampLiteral(TimestampString.fromCalendarFields(calendar), precision);
    }

    public RexLiteral makeTimestampLiteral(TimestampString timestamp, int precision) {
        return this.makeLiteral(Objects.requireNonNull(timestamp, "timestamp"), this.typeFactory.createSqlType(SqlTypeName.TIMESTAMP, precision), SqlTypeName.TIMESTAMP);
    }

    public RexLiteral makeTimestampWithLocalTimeZoneLiteral(TimestampString timestamp, int precision) {
        return this.makeLiteral(Objects.requireNonNull(timestamp, "timestamp"), this.typeFactory.createSqlType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, precision), SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
    }

    public RexLiteral makeTimestampTzLiteral(TimestampWithTimeZoneString timestamp, int precision) {
        return this.makeLiteral(Objects.requireNonNull(timestamp, "timestamp"), this.typeFactory.createSqlType(SqlTypeName.TIMESTAMP_TZ, precision), SqlTypeName.TIMESTAMP_TZ);
    }

    public RexLiteral makeIntervalLiteral(SqlIntervalQualifier intervalQualifier) {
        Verify.verifyNotNull(intervalQualifier);
        if (intervalQualifier.timeFrameName != null) {
            return this.makePreciseStringLiteral(intervalQualifier.timeFrameName);
        }
        return this.makeFlag(intervalQualifier.timeUnitRange);
    }

    public RexLiteral makeIntervalLiteral(@Nullable BigDecimal v, SqlIntervalQualifier intervalQualifier) {
        return this.makeLiteral(v, this.typeFactory.createSqlIntervalType(intervalQualifier), intervalQualifier.typeName());
    }

    public RexDynamicParam makeDynamicParam(RelDataType type2, int index) {
        return new RexDynamicParam(type2, index);
    }

    public RexLiteral makeNullLiteral(RelDataType type2) {
        if (!type2.isNullable()) {
            type2 = this.typeFactory.createTypeWithNullability(type2, true);
        }
        return (RexLiteral)this.makeCast(type2, this.constantNull);
    }

    @Deprecated
    public RexNode makeNullLiteral(SqlTypeName typeName, int precision) {
        return this.makeNullLiteral(this.typeFactory.createSqlType(typeName, precision));
    }

    @Deprecated
    public RexNode makeNullLiteral(SqlTypeName typeName) {
        return this.makeNullLiteral(this.typeFactory.createSqlType(typeName));
    }

    public RexNode makeIn(RexNode arg, List<? extends RexNode> ranges) {
        Sarg<Comparable> sarg;
        if (RexBuilder.areAssignable(arg, ranges) && (sarg = RexBuilder.toSarg(Comparable.class, ranges, RexUnknownAs.UNKNOWN)) != null) {
            List<RelDataType> types = ranges.stream().map(RexNode::getType).collect(Collectors.toList());
            RelDataType sargType = Objects.requireNonNull(this.typeFactory.leastRestrictive(types), () -> "Can't find leastRestrictive type for SARG among " + types);
            return this.makeCall((SqlOperator)SqlStdOperatorTable.SEARCH, arg, this.makeSearchArgumentLiteral(sarg, sargType));
        }
        return RexUtil.composeDisjunction(this, ranges.stream().map(r -> this.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, arg, (RexNode)r)).collect(ImmutableList.toImmutableList()));
    }

    private static boolean areAssignable(RexNode arg, List<? extends RexNode> bounds) {
        for (RexNode rexNode : bounds) {
            if (SqlTypeUtil.inSameFamily(arg.getType(), rexNode.getType()) || arg.getType().isStruct() && rexNode.getType().isStruct()) continue;
            return false;
        }
        return true;
    }

    public RexNode makeBetween(RexNode arg, RexNode lower, RexNode upper) {
        Comparable lowerValue = RexBuilder.toComparable(Comparable.class, lower);
        Comparable upperValue = RexBuilder.toComparable(Comparable.class, upper);
        if (lowerValue != null && upperValue != null && RexBuilder.areAssignable(arg, Arrays.asList(lower, upper))) {
            Sarg<Comparable> sarg = Sarg.of(RexUnknownAs.UNKNOWN, ImmutableRangeSet.of(Range.closed(lowerValue, upperValue)));
            ImmutableList<RelDataType> types = ImmutableList.of(lower.getType(), upper.getType());
            RelDataType sargType = Objects.requireNonNull(this.typeFactory.leastRestrictive(types), () -> "Can't find leastRestrictive type for SARG among " + types);
            return this.makeCall((SqlOperator)SqlStdOperatorTable.SEARCH, arg, this.makeSearchArgumentLiteral(sarg, sargType));
        }
        return this.makeCall((SqlOperator)SqlStdOperatorTable.AND, this.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, arg, lower), this.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, arg, upper));
    }

    private static <C extends Comparable<C>> @Nullable Sarg<C> toSarg(Class<C> clazz, List<? extends RexNode> ranges, RexUnknownAs unknownAs) {
        if (ranges.isEmpty()) {
            return null;
        }
        TreeRangeSet<C> rangeSet = TreeRangeSet.create();
        for (RexNode rexNode : ranges) {
            C value = RexBuilder.toComparable(clazz, rexNode);
            if (value == null) {
                return null;
            }
            rangeSet.add(Range.singleton(value));
        }
        return Sarg.of(unknownAs, rangeSet);
    }

    private static <C extends Comparable<C>> @Nullable C toComparable(Class<C> clazz, RexNode point) {
        switch (point.getKind()) {
            case LITERAL: {
                RexLiteral literal = (RexLiteral)point;
                return (C)((Comparable)literal.getValueAs(clazz));
            }
            case ROW: {
                RexCall call = (RexCall)point;
                ImmutableList.Builder b = ImmutableList.builder();
                for (RexNode operand : call.operands) {
                    Comparable value = RexBuilder.toComparable(Comparable.class, operand);
                    if (value == null) {
                        return null;
                    }
                    b.add(value);
                }
                return (C)((Comparable)clazz.cast(FlatLists.ofComparable(b.build())));
            }
        }
        return null;
    }

    public RexNode copy(RexNode expr) {
        return expr.accept(new RexCopier(this));
    }

    public RexLiteral makeZeroLiteral(RelDataType type2) {
        return this.makeLiteral(RexBuilder.zeroValue(type2), type2);
    }

    private static Comparable zeroValue(RelDataType type2) {
        switch (type2.getSqlTypeName()) {
            case CHAR: {
                return new NlsString(Spaces.of(type2.getPrecision()), null, null);
            }
            case VARCHAR: {
                return new NlsString("", null, null);
            }
            case BINARY: {
                return new ByteString(new byte[type2.getPrecision()]);
            }
            case VARBINARY: {
                return ByteString.EMPTY;
            }
            case BIGINT: 
            case INTEGER: 
            case SMALLINT: 
            case TINYINT: 
            case DOUBLE: 
            case FLOAT: 
            case REAL: 
            case DECIMAL: {
                return BigDecimal.ZERO;
            }
            case BOOLEAN: {
                return Boolean.valueOf(false);
            }
            case TIME: 
            case TIMESTAMP: 
            case DATE: {
                return DateTimeUtils.ZERO_CALENDAR;
            }
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return new TimeString(0, 0, 0);
            }
            case TIME_TZ: {
                return new TimeWithTimeZoneString(0, 0, 0, "GMT+00");
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return new TimestampString(0, 1, 1, 0, 0, 0);
            }
            case TIMESTAMP_TZ: {
                return new TimestampWithTimeZoneString(0, 1, 1, 0, 0, 0, "GMT+00");
            }
        }
        throw Util.unexpected(type2.getSqlTypeName());
    }

    public RexLiteral makeLiteral(@Nullable Object value, RelDataType type2) {
        return (RexLiteral)this.makeLiteral(value, type2, false, false);
    }

    public RexNode makeLiteral(@Nullable Object value, RelDataType type2, boolean allowCast) {
        return this.makeLiteral(value, type2, allowCast, false);
    }

    public RexNode makeLiteral(@Nullable Object value, RelDataType type2, boolean allowCast, boolean trim) {
        if (value == null) {
            return this.makeCast(type2, this.constantNull);
        }
        if (type2.isNullable()) {
            RelDataType typeNotNull = this.typeFactory.createTypeWithNullability(type2, false);
            if (allowCast) {
                RexNode literalNotNull = this.makeLiteral(value, typeNotNull, allowCast);
                return this.makeAbstractCast(type2, literalNotNull, false);
            }
            type2 = typeNotNull;
        }
        value = this.clean(value, type2);
        SqlTypeName sqlTypeName = type2.getSqlTypeName();
        switch (sqlTypeName) {
            case CHAR: {
                NlsString nlsString = (NlsString)value;
                if (trim) {
                    return this.makeCharLiteral(nlsString.rtrim());
                }
                return this.makeCharLiteral(RexBuilder.padRight(nlsString, type2.getPrecision()));
            }
            case VARCHAR: {
                RexLiteral literal = this.makeCharLiteral((NlsString)value);
                if (allowCast) {
                    return this.makeCast(type2, literal);
                }
                return literal;
            }
            case BINARY: {
                return this.makeBinaryLiteral(RexBuilder.padRight((ByteString)value, type2.getPrecision()));
            }
            case VARBINARY: {
                RexLiteral literal = this.makeBinaryLiteral((ByteString)value);
                if (allowCast) {
                    return this.makeCast(type2, literal);
                }
                return literal;
            }
            case BIGINT: 
            case INTEGER: 
            case SMALLINT: 
            case TINYINT: 
            case DECIMAL: {
                if (value instanceof RexLiteral && ((RexLiteral)value).getTypeName() == SqlTypeName.SARG) {
                    return (RexNode)value;
                }
                return this.makeExactLiteral((BigDecimal)value, type2);
            }
            case DOUBLE: 
            case FLOAT: 
            case REAL: {
                if (value instanceof Double) {
                    return this.makeApproxLiteral((Double)value, type2);
                }
                return this.makeApproxLiteral(((BigDecimal)value).doubleValue(), type2);
            }
            case BOOLEAN: {
                return (Boolean)value != false ? this.booleanTrue : this.booleanFalse;
            }
            case TIME: {
                return this.makeTimeLiteral((TimeString)value, type2.getPrecision());
            }
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return this.makeTimeWithLocalTimeZoneLiteral((TimeString)value, type2.getPrecision());
            }
            case TIME_TZ: {
                return this.makeTimeTzLiteral((TimeWithTimeZoneString)value, type2.getPrecision());
            }
            case DATE: {
                return this.makeDateLiteral((DateString)value);
            }
            case TIMESTAMP: {
                return this.makeTimestampLiteral((TimestampString)value, type2.getPrecision());
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return this.makeTimestampWithLocalTimeZoneLiteral((TimestampString)value, type2.getPrecision());
            }
            case TIMESTAMP_TZ: {
                return this.makeTimestampTzLiteral((TimestampWithTimeZoneString)value, type2.getPrecision());
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return this.makeIntervalLiteral((BigDecimal)value, Nullness.castNonNull(type2.getIntervalQualifier()));
            }
            case SYMBOL: {
                return this.makeFlag((Enum)value);
            }
            case MAP: {
                MapSqlType mapType = (MapSqlType)type2;
                Map map = (Map)value;
                ArrayList<RexNode> operands = new ArrayList<RexNode>();
                for (Map.Entry entry : map.entrySet()) {
                    operands.add(this.makeLiteral(entry.getKey(), mapType.getKeyType(), allowCast));
                    operands.add(this.makeLiteral(entry.getValue(), mapType.getValueType(), allowCast));
                }
                return this.makeCall((SqlOperator)SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR, operands);
            }
            case ARRAY: {
                ArraySqlType arrayType = (ArraySqlType)type2;
                List listValue = (List)value;
                ArrayList<RexNode> operands = new ArrayList<RexNode>();
                for (Object entry : listValue) {
                    operands.add(this.makeLiteral(entry, arrayType.getComponentType(), allowCast));
                }
                return this.makeCall((SqlOperator)SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, operands);
            }
            case MULTISET: {
                MultisetSqlType multisetType = (MultisetSqlType)type2;
                ArrayList<RexNode> operands = new ArrayList<RexNode>();
                for (Object entry : (List)value) {
                    RexNode e = entry instanceof RexLiteral ? (RexNode)entry : this.makeLiteral(entry, multisetType.getComponentType(), allowCast);
                    operands.add(e);
                }
                if (allowCast) {
                    return this.makeCall((SqlOperator)SqlStdOperatorTable.MULTISET_VALUE, operands);
                }
                return new RexLiteral((Comparable)((Object)FlatLists.of(operands)), type2, sqlTypeName);
            }
            case ROW: {
                ArrayList<RexNode> operands = new ArrayList<RexNode>();
                for (Pair pair : Pair.zip(type2.getFieldList(), (List)value)) {
                    RexNode e = pair.right instanceof RexLiteral ? (RexNode)pair.right : this.makeLiteral(pair.right, ((RelDataTypeField)pair.left).getType(), allowCast);
                    operands.add(e);
                }
                return new RexLiteral((Comparable)((Object)FlatLists.of(operands)), type2, sqlTypeName);
            }
            case GEOMETRY: {
                return new RexLiteral((Comparable)value, this.guessType(value), SqlTypeName.GEOMETRY);
            }
            case ANY: {
                return this.makeLiteral(value, this.guessType(value), allowCast);
            }
        }
        throw new IllegalArgumentException("Cannot create literal for type '" + (Object)((Object)sqlTypeName) + "'");
    }

    public RexNode makeLambdaCall(RexNode expr, List<RexLambdaRef> parameters2) {
        return new RexLambda(parameters2, expr);
    }

    private @PolyNull Object clean(@PolyNull Object o, RelDataType type2) {
        if (o == null) {
            return o;
        }
        if (o instanceof Sarg) {
            return this.makeSearchArgumentLiteral((Sarg)o, type2);
        }
        switch (type2.getSqlTypeName()) {
            case BIGINT: 
            case INTEGER: 
            case SMALLINT: 
            case TINYINT: 
            case DECIMAL: 
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                if (o instanceof BigDecimal) {
                    return o;
                }
                assert (!(o instanceof Float) && !(o instanceof Double)) : String.format(Locale.ROOT, "%s is not compatible with %s, try to use makeExactLiteral", new Object[]{o.getClass().getCanonicalName(), type2.getSqlTypeName()});
                return new BigDecimal(((Number)o).longValue());
            }
            case REAL: {
                if (o instanceof BigDecimal) {
                    return o;
                }
                if (o instanceof Float) {
                    return ((Float)o).doubleValue();
                }
                if (o instanceof Double) {
                    return o;
                }
                return new BigDecimal(((Number)o).doubleValue(), MathContext.DECIMAL32).stripTrailingZeros();
            }
            case DOUBLE: 
            case FLOAT: {
                if (o instanceof Double) {
                    return o;
                }
                return ((Number)o).doubleValue();
            }
            case CHAR: 
            case VARCHAR: {
                if (o instanceof NlsString) {
                    return o;
                }
                Charset charset = type2.getCharset();
                if (charset == null) {
                    throw new AssertionError((Object)(type2 + ".getCharset() must not be null"));
                }
                return new NlsString((String)o, charset.name(), type2.getCollation());
            }
            case TIME: {
                if (o instanceof TimeString) {
                    return o;
                }
                if (o instanceof Calendar) {
                    if (!((Calendar)o).getTimeZone().equals(DateTimeUtils.UTC_ZONE)) {
                        throw new AssertionError();
                    }
                    return TimeString.fromCalendarFields((Calendar)o);
                }
                return TimeString.fromMillisOfDay((Integer)o);
            }
            case TIME_TZ: {
                if (o instanceof TimeWithTimeZoneString) {
                    return o;
                }
                if (o instanceof Calendar) {
                    return TimeWithTimeZoneString.fromCalendarFields((Calendar)o);
                }
                throw new AssertionError((Object)"Value does not contain time zone");
            }
            case TIME_WITH_LOCAL_TIME_ZONE: {
                if (o instanceof TimeString) {
                    return o;
                }
                return TimeString.fromMillisOfDay((Integer)o);
            }
            case DATE: {
                if (o instanceof DateString) {
                    return o;
                }
                if (o instanceof Calendar) {
                    if (!((Calendar)o).getTimeZone().equals(DateTimeUtils.UTC_ZONE)) {
                        throw new AssertionError();
                    }
                    return DateString.fromCalendarFields((Calendar)o);
                }
                return DateString.fromDaysSinceEpoch((Integer)o);
            }
            case TIMESTAMP: {
                if (o instanceof TimestampString) {
                    return o;
                }
                if (o instanceof Calendar) {
                    if (!((Calendar)o).getTimeZone().equals(DateTimeUtils.UTC_ZONE)) {
                        throw new AssertionError();
                    }
                    return TimestampString.fromCalendarFields((Calendar)o);
                }
                return TimestampString.fromMillisSinceEpoch((Long)o);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                if (o instanceof TimestampString) {
                    return o;
                }
                return TimestampString.fromMillisSinceEpoch((Long)o);
            }
            case TIMESTAMP_TZ: {
                if (o instanceof TimestampWithTimeZoneString) {
                    return o;
                }
                if (o instanceof Calendar) {
                    return TimestampWithTimeZoneString.fromCalendarFields((Calendar)o);
                }
                throw new AssertionError((Object)"Value does not contain time zone");
            }
        }
        return o;
    }

    private RelDataType guessType(@Nullable Object value) {
        if (value == null) {
            return this.typeFactory.createSqlType(SqlTypeName.NULL);
        }
        if (value instanceof Float || value instanceof Double) {
            return this.typeFactory.createSqlType(SqlTypeName.DOUBLE);
        }
        if (value instanceof Number) {
            return this.typeFactory.createSqlType(SqlTypeName.BIGINT);
        }
        if (value instanceof Boolean) {
            return this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        }
        if (value instanceof String) {
            return this.typeFactory.createSqlType(SqlTypeName.CHAR, ((String)value).length());
        }
        if (value instanceof ByteString) {
            return this.typeFactory.createSqlType(SqlTypeName.BINARY, ((ByteString)value).length());
        }
        if (value instanceof Geometry) {
            return this.typeFactory.createSqlType(SqlTypeName.GEOMETRY);
        }
        throw new AssertionError((Object)("unknown type " + value.getClass()));
    }

    private static NlsString padRight(NlsString s2, int length) {
        if (s2.getValue().length() >= length) {
            return s2;
        }
        return s2.copy(RexBuilder.padRight(s2.getValue(), length));
    }

    private static String padRight(String s2, int length) {
        if (s2.length() >= length) {
            return s2;
        }
        return new StringBuilder().append(s2).append(Spaces.MAX, s2.length(), length).toString();
    }

    private static ByteString padRight(ByteString s2, int length) {
        if (s2.length() >= length) {
            return s2;
        }
        return new ByteString(Arrays.copyOf(s2.getBytes(), length));
    }
}

