/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.rules.FilterJoinRule;
import org.apache.calcite.tools.RelBuilderFactory;
import org.immutables.value.Generated;
import shaded.com.google.common.base.MoreObjects;
import shaded.com.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FilterJoinRule.FilterIntoJoinRule.FilterIntoJoinRuleConfig", generator="Immutables")
@Immutable
final class ImmutableFilterIntoJoinRuleConfig
implements FilterJoinRule.FilterIntoJoinRule.FilterIntoJoinRuleConfig {
    private final RelBuilderFactory relBuilderFactory;
    @Nullable
    private final @org.checkerframework.checker.nullness.qual.Nullable String description;
    private final RelRule.OperandTransform operandSupplier;
    private final boolean smart;
    private final FilterJoinRule.Predicate predicate;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFilterIntoJoinRuleConfig(FilterJoinRule.Predicate predicate) {
        this.predicate = Objects.requireNonNull(predicate, "predicate");
        this.description = null;
        this.relBuilderFactory = this.initShim.relBuilderFactory();
        this.operandSupplier = this.initShim.operandSupplier();
        this.smart = this.initShim.isSmart();
        this.initShim = null;
    }

    private ImmutableFilterIntoJoinRuleConfig(Builder builder) {
        this.description = builder.description;
        this.predicate = builder.predicate;
        if (builder.relBuilderFactory != null) {
            this.initShim.withRelBuilderFactory(builder.relBuilderFactory);
        }
        if (builder.operandSupplier != null) {
            this.initShim.withOperandSupplier(builder.operandSupplier);
        }
        if (builder.smartIsSet()) {
            this.initShim.withSmart(builder.smart);
        }
        this.relBuilderFactory = this.initShim.relBuilderFactory();
        this.operandSupplier = this.initShim.operandSupplier();
        this.smart = this.initShim.isSmart();
        this.initShim = null;
    }

    private ImmutableFilterIntoJoinRuleConfig(RelBuilderFactory relBuilderFactory, @Nullable @org.checkerframework.checker.nullness.qual.Nullable String description2, RelRule.OperandTransform operandSupplier, boolean smart, FilterJoinRule.Predicate predicate) {
        this.relBuilderFactory = relBuilderFactory;
        this.description = description2;
        this.operandSupplier = operandSupplier;
        this.smart = smart;
        this.predicate = predicate;
        this.initShim = null;
    }

    private RelBuilderFactory relBuilderFactoryInitialize() {
        return FilterJoinRule.FilterIntoJoinRule.FilterIntoJoinRuleConfig.super.relBuilderFactory();
    }

    private RelRule.OperandTransform operandSupplierInitialize() {
        return FilterJoinRule.FilterIntoJoinRule.FilterIntoJoinRuleConfig.super.operandSupplier();
    }

    private boolean isSmartInitialize() {
        return FilterJoinRule.FilterIntoJoinRule.FilterIntoJoinRuleConfig.super.isSmart();
    }

    @Override
    public RelBuilderFactory relBuilderFactory() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relBuilderFactory() : this.relBuilderFactory;
    }

    @Override
    @Nullable
    public @org.checkerframework.checker.nullness.qual.Nullable String description() {
        return this.description;
    }

    @Override
    public RelRule.OperandTransform operandSupplier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.operandSupplier() : this.operandSupplier;
    }

    @Override
    public boolean isSmart() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isSmart() : this.smart;
    }

    @Override
    public FilterJoinRule.Predicate getPredicate() {
        return this.predicate;
    }

    @Override
    public final ImmutableFilterIntoJoinRuleConfig withRelBuilderFactory(RelBuilderFactory value) {
        if (this.relBuilderFactory == value) {
            return this;
        }
        RelBuilderFactory newValue = Objects.requireNonNull(value, "relBuilderFactory");
        return new ImmutableFilterIntoJoinRuleConfig(newValue, this.description, this.operandSupplier, this.smart, this.predicate);
    }

    @Override
    public final ImmutableFilterIntoJoinRuleConfig withDescription(@Nullable @org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableFilterIntoJoinRuleConfig(this.relBuilderFactory, value, this.operandSupplier, this.smart, this.predicate);
    }

    @Override
    public final ImmutableFilterIntoJoinRuleConfig withOperandSupplier(RelRule.OperandTransform value) {
        if (this.operandSupplier == value) {
            return this;
        }
        RelRule.OperandTransform newValue = Objects.requireNonNull(value, "operandSupplier");
        return new ImmutableFilterIntoJoinRuleConfig(this.relBuilderFactory, this.description, newValue, this.smart, this.predicate);
    }

    @Override
    public final ImmutableFilterIntoJoinRuleConfig withSmart(boolean value) {
        if (this.smart == value) {
            return this;
        }
        return new ImmutableFilterIntoJoinRuleConfig(this.relBuilderFactory, this.description, this.operandSupplier, value, this.predicate);
    }

    @Override
    public final ImmutableFilterIntoJoinRuleConfig withPredicate(FilterJoinRule.Predicate value) {
        if (this.predicate == value) {
            return this;
        }
        FilterJoinRule.Predicate newValue = Objects.requireNonNull(value, "predicate");
        return new ImmutableFilterIntoJoinRuleConfig(this.relBuilderFactory, this.description, this.operandSupplier, this.smart, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFilterIntoJoinRuleConfig && this.equalTo((ImmutableFilterIntoJoinRuleConfig)another);
    }

    private boolean equalTo(ImmutableFilterIntoJoinRuleConfig another) {
        return this.relBuilderFactory.equals(another.relBuilderFactory) && Objects.equals(this.description, another.description) && this.operandSupplier.equals(another.operandSupplier) && this.smart == another.smart && this.predicate.equals(another.predicate);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.relBuilderFactory.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.description);
        h2 += (h2 << 5) + this.operandSupplier.hashCode();
        h2 += (h2 << 5) + Booleans.hashCode(this.smart);
        h2 += (h2 << 5) + this.predicate.hashCode();
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("FilterIntoJoinRuleConfig").omitNullValues().add("relBuilderFactory", this.relBuilderFactory).add("description", this.description).add("operandSupplier", this.operandSupplier).add("smart", this.smart).add("predicate", this.predicate).toString();
    }

    public static ImmutableFilterIntoJoinRuleConfig of(FilterJoinRule.Predicate predicate) {
        return new ImmutableFilterIntoJoinRuleConfig(predicate);
    }

    public static ImmutableFilterIntoJoinRuleConfig copyOf(FilterJoinRule.FilterIntoJoinRule.FilterIntoJoinRuleConfig instance) {
        if (instance instanceof ImmutableFilterIntoJoinRuleConfig) {
            return (ImmutableFilterIntoJoinRuleConfig)instance;
        }
        return ImmutableFilterIntoJoinRuleConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FilterJoinRule.FilterIntoJoinRule.FilterIntoJoinRuleConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PREDICATE = 1L;
        private static final long OPT_BIT_SMART = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private RelBuilderFactory relBuilderFactory;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String description;
        @Nullable
        private RelRule.OperandTransform operandSupplier;
        private boolean smart;
        @Nullable
        private FilterJoinRule.Predicate predicate;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FilterJoinRule.Config instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RelRule.Config instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(FilterJoinRule.FilterIntoJoinRule.FilterIntoJoinRuleConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RelRule.Config instance;
            if (object instanceof FilterJoinRule.Config) {
                instance = (FilterJoinRule.Config)object;
                this.withPredicate(instance.getPredicate());
                this.withSmart(instance.isSmart());
            }
            if (object instanceof RelRule.Config) {
                instance = (RelRule.Config)object;
                this.withRelBuilderFactory(instance.relBuilderFactory());
                this.withOperandSupplier(instance.operandSupplier());
                @org.checkerframework.checker.nullness.qual.Nullable String descriptionValue = instance.description();
                if (descriptionValue != null) {
                    this.withDescription(descriptionValue);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
            this.relBuilderFactory = Objects.requireNonNull(relBuilderFactory, "relBuilderFactory");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withDescription(@Nullable @org.checkerframework.checker.nullness.qual.Nullable String description2) {
            this.description = description2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withOperandSupplier(RelRule.OperandTransform operandSupplier) {
            this.operandSupplier = Objects.requireNonNull(operandSupplier, "operandSupplier");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withSmart(boolean smart) {
            this.smart = smart;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withPredicate(FilterJoinRule.Predicate predicate) {
            this.predicate = Objects.requireNonNull(predicate, "predicate");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableFilterIntoJoinRuleConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFilterIntoJoinRuleConfig(this);
        }

        private boolean smartIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("predicate");
            }
            return "Cannot build FilterIntoJoinRuleConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="FilterJoinRule.FilterIntoJoinRule.FilterIntoJoinRuleConfig", generator="Immutables")
    private final class InitShim {
        private byte relBuilderFactoryBuildStage = 0;
        private RelBuilderFactory relBuilderFactory;
        private byte operandSupplierBuildStage = 0;
        private RelRule.OperandTransform operandSupplier;
        private byte smartBuildStage = 0;
        private boolean smart;

        private InitShim() {
        }

        RelBuilderFactory relBuilderFactory() {
            if (this.relBuilderFactoryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relBuilderFactoryBuildStage == 0) {
                this.relBuilderFactoryBuildStage = (byte)-1;
                this.relBuilderFactory = Objects.requireNonNull(ImmutableFilterIntoJoinRuleConfig.this.relBuilderFactoryInitialize(), "relBuilderFactory");
                this.relBuilderFactoryBuildStage = 1;
            }
            return this.relBuilderFactory;
        }

        void withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
            this.relBuilderFactory = relBuilderFactory;
            this.relBuilderFactoryBuildStage = 1;
        }

        RelRule.OperandTransform operandSupplier() {
            if (this.operandSupplierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.operandSupplierBuildStage == 0) {
                this.operandSupplierBuildStage = (byte)-1;
                this.operandSupplier = Objects.requireNonNull(ImmutableFilterIntoJoinRuleConfig.this.operandSupplierInitialize(), "operandSupplier");
                this.operandSupplierBuildStage = 1;
            }
            return this.operandSupplier;
        }

        void withOperandSupplier(RelRule.OperandTransform operandSupplier) {
            this.operandSupplier = operandSupplier;
            this.operandSupplierBuildStage = 1;
        }

        boolean isSmart() {
            if (this.smartBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.smartBuildStage == 0) {
                this.smartBuildStage = (byte)-1;
                this.smart = ImmutableFilterIntoJoinRuleConfig.this.isSmartInitialize();
                this.smartBuildStage = 1;
            }
            return this.smart;
        }

        void withSmart(boolean smart) {
            this.smart = smart;
            this.smartBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.relBuilderFactoryBuildStage == -1) {
                attributes.add("relBuilderFactory");
            }
            if (this.operandSupplierBuildStage == -1) {
                attributes.add("operandSupplier");
            }
            if (this.smartBuildStage == -1) {
                attributes.add("smart");
            }
            return "Cannot build FilterIntoJoinRuleConfig, attribute initializers form cycle " + attributes;
        }
    }
}

