/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.uzaygezen.core.FilteredIndexRange;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.Iterables;

public class Query<F, R> {
    private final List<FilteredIndexRange<F, R>> filteredIndexRanges;
    private static final Query<?, ?> EMPTY_QUERY = Query.of(ImmutableList.of());

    private Query(List<FilteredIndexRange<F, R>> filteredIndexRanges) {
        this.filteredIndexRanges = ImmutableList.copyOf(filteredIndexRanges);
    }

    public static <F, R> Query<F, R> of(List<FilteredIndexRange<F, R>> filteredIndexRanges) {
        return new Query<F, R>(filteredIndexRanges);
    }

    public List<FilteredIndexRange<F, R>> getFilteredIndexRanges() {
        return this.filteredIndexRanges;
    }

    public boolean isPotentialOverSelectivity() {
        boolean potentialOverSelectivity = Iterables.any(this.filteredIndexRanges, FilteredIndexRange.potentialOverSelectivityExtractor());
        return potentialOverSelectivity;
    }

    public int hashCode() {
        return 31 * this.filteredIndexRanges.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Query)) {
            return false;
        }
        Query other = (Query)o;
        return this.filteredIndexRanges.equals(other.filteredIndexRanges);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static <F, R> Query<F, R> emptyQuery() {
        return EMPTY_QUERY;
    }
}

