/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth;

import java.security.Principal;
import java.util.concurrent.Callable;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.identity.NamedPrincipal;
import org.opensearch.identity.UserSubject;
import org.opensearch.identity.tokens.AuthToken;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;

public class UserSubjectImpl
implements UserSubject {
    private final NamedPrincipal userPrincipal;
    private final ThreadPool threadPool;
    private final User user;

    UserSubjectImpl(ThreadPool threadPool, User user) {
        this.threadPool = threadPool;
        this.user = user;
        this.userPrincipal = new NamedPrincipal(user.getName());
    }

    public void authenticate(AuthToken authToken) {
    }

    public Principal getPrincipal() {
        return this.userPrincipal;
    }

    public <T> T runAs(Callable<T> callable) throws Exception {
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            this.threadPool.getThreadContext().putTransient("_opendistro_security_user", (Object)this.user);
            T t = callable.call();
            return t;
        }
    }

    public User getUser() {
        return this.user;
    }
}

