/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability.action;

import java.io.IOException;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.commons.utils.XContentHelpersKt;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.observability.model.BaseObjectData;
import org.opensearch.observability.model.ObservabilityObjectDataProperties;
import org.opensearch.observability.model.ObservabilityObjectType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB%\b\u0016\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rJ\u001c\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lorg/opensearch/observability/action/CreateObservabilityObjectRequest;", "Lorg/opensearch/action/ActionRequest;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "objectId", "", "type", "Lorg/opensearch/observability/model/ObservabilityObjectType;", "objectData", "Lorg/opensearch/observability/model/BaseObjectData;", "<init>", "(Ljava/lang/String;Lorg/opensearch/observability/model/ObservabilityObjectType;Lorg/opensearch/observability/model/BaseObjectData;)V", "input", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getObjectId", "()Ljava/lang/String;", "getType", "()Lorg/opensearch/observability/model/ObservabilityObjectType;", "getObjectData", "()Lorg/opensearch/observability/model/BaseObjectData;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "output", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "Companion", "opensearch-observability"})
public final class CreateObservabilityObjectRequest
extends ActionRequest
implements ToXContentObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String objectId;
    @NotNull
    private final ObservabilityObjectType type;
    @Nullable
    private final BaseObjectData objectData;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(CreateObservabilityObjectRequest.class);
    @NotNull
    private static final Writeable.Reader<CreateObservabilityObjectRequest> reader = CreateObservabilityObjectRequest::reader$lambda$0;

    @Nullable
    public final String getObjectId() {
        return this.objectId;
    }

    @NotNull
    public final ObservabilityObjectType getType() {
        return this.type;
    }

    @Nullable
    public final BaseObjectData getObjectData() {
        return this.objectData;
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNull((Object)builder);
        XContentBuilder xContentBuilder = builder.startObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"startObject(...)");
        XContentBuilder xContentBuilder2 = XContentHelpersKt.fieldIfNotNull((XContentBuilder)xContentBuilder, (String)"objectId", (Object)this.objectId).field(this.type.getTag(), (ToXContent)this.objectData).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"endObject(...)");
        return xContentBuilder2;
    }

    public CreateObservabilityObjectRequest(@Nullable String objectId, @NotNull ObservabilityObjectType type, @NotNull BaseObjectData objectData) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)objectData, (String)"objectData");
        this.objectId = objectId;
        this.type = type;
        this.objectData = objectData;
    }

    public /* synthetic */ CreateObservabilityObjectRequest(String string, ObservabilityObjectType observabilityObjectType, BaseObjectData baseObjectData, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string, observabilityObjectType, baseObjectData);
    }

    public CreateObservabilityObjectRequest(@NotNull StreamInput input) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        super(input);
        this.objectId = input.readOptionalString();
        this.type = (ObservabilityObjectType)input.readEnum(ObservabilityObjectType.class);
        Enum enum_ = input.readEnum(ObservabilityObjectType.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"readEnum(...)");
        this.objectData = (BaseObjectData)input.readOptionalWriteable(ObservabilityObjectDataProperties.INSTANCE.getReaderForObjectType((ObservabilityObjectType)enum_));
    }

    public void writeTo(@NotNull StreamOutput output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super.writeTo(output);
        output.writeOptionalString(this.objectId);
        output.writeEnum((Enum)this.type);
        output.writeEnum((Enum)this.type);
        output.writeOptionalWriteable((Writeable)this.objectData);
    }

    @Nullable
    public ActionRequestValidationException validate() {
        return null;
    }

    private static final CreateObservabilityObjectRequest reader$lambda$0(StreamInput it) {
        Intrinsics.checkNotNull((Object)it);
        return new CreateObservabilityObjectRequest(it);
    }

    @JvmStatic
    @NotNull
    public static final CreateObservabilityObjectRequest parse(@NotNull XContentParser parser, @Nullable String id) throws IOException {
        return Companion.parse(parser, id);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001f\u0010\n\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/opensearch/observability/action/CreateObservabilityObjectRequest$Companion;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "reader", "Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "Lorg/opensearch/observability/action/CreateObservabilityObjectRequest;", "kotlin.jvm.PlatformType", "getReader", "()Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "parse", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "id", "", "opensearch-observability"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final Writeable.Reader<CreateObservabilityObjectRequest> getReader() {
            return reader;
        }

        @JvmStatic
        @NotNull
        public final CreateObservabilityObjectRequest parse(@NotNull XContentParser parser, @Nullable String id) throws IOException {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            String objectId = id;
            ObservabilityObjectType type = null;
            BaseObjectData baseObjectData = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = parser.currentName();
                parser.nextToken();
                if (Intrinsics.areEqual((Object)fieldName, (Object)"objectId")) {
                    objectId = parser.text();
                    continue;
                }
                Intrinsics.checkNotNull((Object)fieldName);
                ObservabilityObjectType objectTypeForTag = ObservabilityObjectType.Companion.fromTagOrDefault(fieldName);
                if (objectTypeForTag != ObservabilityObjectType.NONE && baseObjectData == null) {
                    baseObjectData = ObservabilityObjectDataProperties.INSTANCE.createObjectData(objectTypeForTag, parser);
                    type = objectTypeForTag;
                    continue;
                }
                parser.skipChildren();
                this.getLog().info("Unexpected field: " + fieldName + ", while parsing CreateObservabilityObjectRequest");
            }
            if (type == null) {
                throw new IllegalArgumentException("Object type field absent");
            }
            if (baseObjectData == null) {
                throw new IllegalArgumentException("Object data field absent");
            }
            return new CreateObservabilityObjectRequest(objectId, type, baseObjectData);
        }

        public static /* synthetic */ CreateObservabilityObjectRequest parse$default(Companion companion, XContentParser xContentParser, String string, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                string = null;
            }
            return companion.parse(xContentParser, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

