/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.stats;

import java.util.concurrent.atomic.LongAdder;
import lombok.Generated;

public enum KNNRemoteIndexBuildValue {
    WRITE_SUCCESS_COUNT("write_success_count"),
    WRITE_FAILURE_COUNT("write_failure_count"),
    WRITE_TIME("successful_write_time_in_millis"),
    READ_SUCCESS_COUNT("read_success_count"),
    READ_FAILURE_COUNT("read_failure_count"),
    READ_TIME("successful_read_time_in_millis"),
    REMOTE_INDEX_BUILD_CURRENT_MERGE_OPERATIONS("remote_index_build_current_merge_operations"),
    REMOTE_INDEX_BUILD_CURRENT_FLUSH_OPERATIONS("remote_index_build_current_flush_operations"),
    REMOTE_INDEX_BUILD_CURRENT_MERGE_SIZE("remote_index_build_current_merge_size"),
    REMOTE_INDEX_BUILD_CURRENT_FLUSH_SIZE("remote_index_build_current_flush_size"),
    REMOTE_INDEX_BUILD_MERGE_TIME("remote_index_build_merge_time_in_millis"),
    REMOTE_INDEX_BUILD_FLUSH_TIME("remote_index_build_flush_time_in_millis"),
    BUILD_REQUEST_SUCCESS_COUNT("build_request_success_count"),
    BUILD_REQUEST_FAILURE_COUNT("build_request_failure_count"),
    STATUS_REQUEST_SUCCESS_COUNT("status_request_success_count"),
    STATUS_REQUEST_FAILURE_COUNT("status_request_failure_count"),
    INDEX_BUILD_SUCCESS_COUNT("index_build_success_count"),
    INDEX_BUILD_FAILURE_COUNT("index_build_failure_count"),
    WAITING_TIME("waiting_time_in_ms");

    private final String name;
    private final LongAdder value;

    private KNNRemoteIndexBuildValue(String name) {
        this.name = name;
        this.value = new LongAdder();
    }

    public Long getValue() {
        return this.value.longValue();
    }

    public void increment() {
        this.value.increment();
    }

    public void decrement() {
        this.value.decrement();
    }

    public void incrementBy(long delta) {
        this.value.add(delta);
    }

    public void decrementBy(long delta) {
        this.value.add(delta * -1L);
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

