/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.transform;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.indexmanagement.IndexManagementIndices;
import org.opensearch.indexmanagement.common.model.dimension.DateHistogram;
import org.opensearch.indexmanagement.common.model.dimension.Dimension;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.transform.TargetIndexMappingService;
import org.opensearch.indexmanagement.transform.exceptions.TransformIndexException;
import org.opensearch.indexmanagement.transform.model.Transform;
import org.opensearch.indexmanagement.util.IndexUtils;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.IndicesAdminClient;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\r\u001a\u00020\u00052\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000fJ$\u0010\u0010\u001a\u00020\u00052\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\"\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tJ \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u000e\u0010\u001b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000fH\u0002J\u001a\u0010\u001c\u001a\u00020\u00192\u0010\u0010\u001d\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000fH\u0002J$\u0010\u001e\u001a\u00020\u00172\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000f2\u0006\u0010 \u001a\u00020!H\u0002J\u001c\u0010\"\u001a\u00020\u00052\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000fH\u0002JH\u0010#\u001a\u00020\u00172\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000f2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010)2\b\u0010*\u001a\u0004\u0018\u00010\u0005H\u0002J8\u0010+\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010)2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010)H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/opensearch/indexmanagement/transform/TargetIndexMappingService;", "", "()V", "DATE_FIELD_TYPES", "", "", "PROPERTIES", "TYPE", "client", "Lorg/opensearch/transport/client/Client;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "createTargetIndexMapping", "dateFieldMappings", "", "createTargetIndexMappingsAsString", "dynamicMappings", "getTargetMappingsForDates", "transform", "Lorg/opensearch/indexmanagement/transform/model/Transform;", "(Lorg/opensearch/indexmanagement/transform/model/Transform;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initialize", "", "isFieldInMappings", "", "fieldName", "mappings", "isSourceFieldDate", "sourceFieldType", "mapCompositeAggregation", "compositeAggregation", "builder", "Lorg/opensearch/core/xcontent/XContentBuilder;", "mapCompositeAggregationToString", "mapDateAggregation", "aggBuilders", "", "Lorg/opensearch/search/aggregations/AggregationBuilder;", "sourceIndexMapping", "targetIndexMapping", "", "parentPath", "mapDateTermAggregation", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nTargetIndexMappingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetIndexMappingService.kt\norg/opensearch/indexmanagement/transform/TargetIndexMappingService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,251:1\n1855#2,2:252\n*S KotlinDebug\n*F\n+ 1 TargetIndexMappingService.kt\norg/opensearch/indexmanagement/transform/TargetIndexMappingService\n*L\n90#1:252,2\n*E\n"})
public final class TargetIndexMappingService {
    @NotNull
    public static final TargetIndexMappingService INSTANCE = new TargetIndexMappingService();
    private static final Logger logger = LogManager.getLogger(INSTANCE.getClass());
    private static Client client;
    @NotNull
    private static final String TYPE = "type";
    @NotNull
    private static final String PROPERTIES = "properties";
    @NotNull
    private static final Set<String> DATE_FIELD_TYPES;

    private TargetIndexMappingService() {
    }

    public final void initialize(@NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        TargetIndexMappingService.client = client;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getTargetMappingsForDates(@NotNull Transform var1_1, @NotNull Continuation<? super Map<String, ? extends Object>> var2_2) {
        if (!(var2_2 instanceof getTargetMappingsForDates.1)) ** GOTO lbl-1000
        var9_3 = var2_2;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ TargetIndexMappingService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getTargetMappingsForDates(null, (Continuation<? super Map<String, ? extends Object>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                sourceIndex = transform.getSourceIndex();
                v0 = TargetIndexMappingService.client;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                    v0 = null;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = transform;
                $continuation.L$2 = sourceIndex;
                $continuation.label = 1;
                v1 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)v0.admin().indices(), (Function2)new Function2<IndicesAdminClient, ActionListener<GetMappingsResponse>, Unit>(sourceIndex){
                    final /* synthetic */ String $sourceIndex;
                    {
                        this.$sourceIndex = $sourceIndex;
                        super(2);
                    }

                    public final void invoke(IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<GetMappingsResponse> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        String[] stringArray = new String[]{this.$sourceIndex};
                        $this$suspendUntil.getMappings((GetMappingsRequest)new GetMappingsRequest().indices(stringArray), it);
                    }
                }, $continuation);
                ** if (v1 != var10_5) goto lbl26
lbl25:
                // 1 sources

                return var10_5;
lbl26:
                // 1 sources

                ** GOTO lbl35
            }
            case 1: {
                sourceIndex = (String)$continuation.L$2;
                transform = (Transform)$continuation.L$1;
                this = (TargetIndexMappingService)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl35:
                    // 2 sources

                    v2 = (GetMappingsResponse)v1;
                    if (v2 == null) {
                        throw new IllegalStateException(("GetMappingResponse for [" + transform + ".sourceIndex] was null").toString());
                    }
                    result = v2;
                    v3 = (MappingMetadata)result.getMappings().get(sourceIndex);
                    sourceIndexMapping = v3 != null ? v3.getSourceAsMap() : null;
                    targetIndexDateFieldMappings = new LinkedHashMap<K, V>();
                    var7_11 = sourceIndexMapping;
                    if (!(var7_11 == null || var7_11.isEmpty() != false)) {
                        this.mapDateTermAggregation(transform, (Map<String, Object>)sourceIndexMapping, targetIndexDateFieldMappings);
                        var7_11 = transform.getAggregations().getAggregatorFactories();
                        Intrinsics.checkNotNullExpressionValue((Object)var7_11, (String)"getAggregatorFactories(...)");
                        this.mapDateAggregation((Collection<? extends AggregationBuilder>)var7_11, (Map<String, ? extends Object>)sourceIndexMapping, targetIndexDateFieldMappings, null);
                    }
                    return targetIndexDateFieldMappings;
                }
                catch (IndexNotFoundException var4_8) {
                    TargetIndexMappingService.logger.error("Index " + sourceIndex + " doesn't exist");
                    return MapsKt.emptyMap();
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void mapDateTermAggregation(Transform transform2, Map<String, Object> sourceIndexMapping, Map<String, Object> dateFieldMappings) {
        Iterable $this$forEach$iv = transform2.getGroups();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Dimension dimension = (Dimension)element$iv;
            boolean bl = false;
            if (!INSTANCE.isFieldInMappings(dimension.getSourceField(), sourceIndexMapping)) {
                throw new TransformIndexException("Missing field " + dimension.getSourceField() + " in source index", null, 2, null);
            }
            Map<?, ?> sourceFieldType = IndexUtils.Companion.getFieldFromMappings(dimension.getSourceField(), sourceIndexMapping);
            if (dimension instanceof DateHistogram || !INSTANCE.isSourceFieldDate(sourceFieldType)) continue;
            Pair[] pairArray = new Pair[2];
            Map<?, ?> map = sourceFieldType;
            Intrinsics.checkNotNull(map);
            pairArray[0] = TuplesKt.to((Object)TYPE, map.get(TYPE));
            pairArray[1] = TuplesKt.to((Object)"format", (Object)"strict_date_optional_time||epoch_millis");
            Map dateTypeTargetMapping = MapsKt.mapOf((Pair[])pairArray);
            dateFieldMappings.put(dimension.getTargetField(), dateTypeTargetMapping);
        }
    }

    private final boolean isSourceFieldDate(Map<?, ?> sourceFieldType) {
        Map<?, ?> map = sourceFieldType;
        return (map != null ? map.get(TYPE) : null) != null && CollectionsKt.contains((Iterable)DATE_FIELD_TYPES, sourceFieldType.get(TYPE));
    }

    @NotNull
    public final String createTargetIndexMapping(@NotNull Map<String, ? extends Object> dateFieldMappings) {
        String dynamicMappings;
        Intrinsics.checkNotNullParameter(dateFieldMappings, (String)"dateFieldMappings");
        XContentBuilder builder = XContentFactory.jsonBuilder();
        String string = dynamicMappings = IndexManagementIndices.Companion.getTransformTargetMappings();
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        BytesReference bytesReference = BytesReference.fromByteBuffer((ByteBuffer)byteBuffer);
        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)bytesReference, (MediaType)((MediaType)XContentType.JSON));
        block8: while (!xcp.isClosed()) {
            XContentParser.Token token = xcp.currentToken();
            String fieldName = xcp.currentName();
            XContentParser.Token token2 = token;
            switch (token2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[token2.ordinal()]) {
                case 1: {
                    builder.field(fieldName, xcp.intValue());
                    break;
                }
                case 2: {
                    builder.field(fieldName, xcp.text());
                    break;
                }
                case 3: {
                    if (fieldName != null) {
                        builder.startObject(fieldName);
                        break;
                    }
                    builder.startObject();
                    break;
                }
                case 4: {
                    builder.endObject();
                    break;
                }
                case 5: {
                    builder.startArray(fieldName);
                    break;
                }
                case 6: {
                    builder.endArray();
                    if (!(!dateFieldMappings.isEmpty())) break;
                    builder.startObject(PROPERTIES);
                    Intrinsics.checkNotNull((Object)builder);
                    this.mapCompositeAggregation(dateFieldMappings, builder);
                    builder.endObject();
                    break;
                }
                default: {
                    xcp.nextToken();
                    continue block8;
                }
            }
            xcp.nextToken();
        }
        Intrinsics.checkNotNull((Object)builder);
        return OpenSearchExtensionsKt.string(builder);
    }

    private final void mapCompositeAggregation(Map<String, ? extends Object> compositeAggregation, XContentBuilder builder) {
        for (Map.Entry<String, ? extends Object> it : compositeAggregation.entrySet()) {
            if (it.getValue() instanceof Map) {
                builder.startObject(it.getKey());
                Object object = it.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                this.mapCompositeAggregation((Map)object, builder);
                builder.endObject();
                continue;
            }
            if (!CollectionsKt.contains((Iterable)DATE_FIELD_TYPES, (Object)it.getValue())) continue;
            builder.field(it.getKey(), it.getValue().toString());
        }
    }

    private final String createTargetIndexMappingsAsString(Map<String, ? extends Object> dateFieldMappings, String dynamicMappings) {
        String compositeAgg = this.mapCompositeAggregationToString(dateFieldMappings);
        return StringsKt.dropLast((String)StringsKt.trimIndent((String)dynamicMappings), (int)1) + ", \n \"properties\" : \n { \n " + compositeAgg + " \n } \n }";
    }

    private final String mapCompositeAggregationToString(Map<String, ? extends Object> compositeAggregation) {
        StringBuilder stringBuilder;
        StringBuilder $this$mapCompositeAggregationToString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean isFirst = true;
        for (Map.Entry<String, ? extends Object> it : compositeAggregation.entrySet()) {
            if (!isFirst) {
                $this$mapCompositeAggregationToString_u24lambda_u241.append(",");
            }
            isFirst = false;
            if (it.getValue() instanceof Map) {
                $this$mapCompositeAggregationToString_u24lambda_u241.append("\"" + it.getKey() + "\" : {");
                Object object = it.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                $this$mapCompositeAggregationToString_u24lambda_u241.append(INSTANCE.mapCompositeAggregationToString((Map)object));
                $this$mapCompositeAggregationToString_u24lambda_u241.append("\n }");
                continue;
            }
            $this$mapCompositeAggregationToString_u24lambda_u241.append("\n");
            $this$mapCompositeAggregationToString_u24lambda_u241.append("\"" + it.getKey() + "\" : \"" + it.getValue() + "\"");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void mapDateAggregation(Collection<? extends AggregationBuilder> aggBuilders, Map<String, ? extends Object> sourceIndexMapping, Map<String, Object> targetIndexMapping, String parentPath) {
        for (AggregationBuilder aggregationBuilder : aggBuilders) {
            Collection collection;
            Object fullPath;
            String targetIdxFieldName = aggregationBuilder.getName();
            Object object = parentPath;
            if (object == null || (object = (String)object + ".") == null || (object = (String)object + targetIdxFieldName) == null) {
                object = fullPath = targetIdxFieldName;
            }
            if (aggregationBuilder instanceof ValuesSourceAggregationBuilder) {
                Map<?, ?> sourceFieldType;
                String sourceIdxFieldName = ((ValuesSourceAggregationBuilder)aggregationBuilder).field();
                Intrinsics.checkNotNull((Object)sourceIdxFieldName);
                Map<?, ?> map = sourceFieldType = IndexUtils.Companion.getFieldFromMappings(sourceIdxFieldName, sourceIndexMapping);
                if (!(map == null || map.isEmpty()) && Intrinsics.areEqual(sourceFieldType.get(TYPE), (Object)"date")) {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)TYPE, (Object)"date"), TuplesKt.to((Object)"format", (Object)"strict_date_optional_time||epoch_millis")};
                    Map dateTypeTargetMapping = MapsKt.mapOf((Pair[])pairArray);
                    Intrinsics.checkNotNull((Object)fullPath);
                    targetIndexMapping.put((String)fullPath, dateTypeTargetMapping);
                }
            }
            if ((collection = aggregationBuilder.getSubAggregations()) == null || collection.isEmpty()) continue;
            Collection collection2 = aggregationBuilder.getSubAggregations();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getSubAggregations(...)");
            this.mapDateAggregation(collection2, sourceIndexMapping, targetIndexMapping, (String)fullPath);
        }
    }

    private final boolean isFieldInMappings(String fieldName, Map<?, ?> mappings) {
        return IndexUtils.Companion.getFieldFromMappings(fieldName, mappings) != null;
    }

    static {
        Object[] objectArray = new String[]{"date", "date_nanos"};
        DATE_FIELD_TYPES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[XContentParser.Token.values().length];
            try {
                nArray[XContentParser.Token.VALUE_NUMBER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XContentParser.Token.VALUE_STRING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XContentParser.Token.START_OBJECT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XContentParser.Token.END_OBJECT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XContentParser.Token.START_ARRAY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XContentParser.Token.END_ARRAY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

