/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement;

import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.lifecycle.LifecycleListener;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.indexmanagement.indexstatemanagement.SkipExecution;
import org.opensearch.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import org.opensearch.indexmanagement.util.OpenForTesting;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020 H\u0007J\b\u0010&\u001a\u00020\u0016H\u0002R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u0012X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0016\u0010\u0019\u001a\n \u0017*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n \u0017*\u0004\u0018\u00010\u001e0\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/PluginVersionSweepCoordinator;", "Lorg/opensearch/common/lifecycle/LifecycleListener;", "Lkotlinx/coroutines/CoroutineScope;", "Lorg/opensearch/cluster/ClusterStateListener;", "skipExecution", "Lorg/opensearch/indexmanagement/indexstatemanagement/SkipExecution;", "settings", "Lorg/opensearch/common/settings/Settings;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "(Lorg/opensearch/indexmanagement/indexstatemanagement/SkipExecution;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/cluster/service/ClusterService;)V", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "setClusterService", "(Lorg/opensearch/cluster/service/ClusterService;)V", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "indexStateManagementEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "logger", "Lorg/apache/logging/log4j/Logger;", "scheduledSkipExecution", "Lorg/opensearch/threadpool/Scheduler$Cancellable;", "sweepSkipPeriod", "Lorg/opensearch/common/unit/TimeValue;", "afterStart", "", "beforeStop", "clusterChanged", "event", "Lorg/opensearch/cluster/ClusterChangedEvent;", "initBackgroundSweepISMPluginVersionExecution", "isIndexStateManagementEnabled", "opensearch-index-management"})
public final class PluginVersionSweepCoordinator
extends LifecycleListener
implements CoroutineScope,
ClusterStateListener {
    @NotNull
    private final SkipExecution skipExecution;
    @NotNull
    private final ThreadPool threadPool;
    @NotNull
    private ClusterService clusterService;
    private final /* synthetic */ CoroutineScope $$delegate_0;
    private final Logger logger;
    @Nullable
    private Scheduler.Cancellable scheduledSkipExecution;
    private volatile TimeValue sweepSkipPeriod;
    private volatile Boolean indexStateManagementEnabled;

    public PluginVersionSweepCoordinator(@NotNull SkipExecution skipExecution, @NotNull Settings settings, @NotNull ThreadPool threadPool, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)skipExecution, (String)"skipExecution");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.skipExecution = skipExecution;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.$$delegate_0 = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getDefault()).plus((CoroutineContext)new CoroutineName("ISMPluginSweepCoordinator")));
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.sweepSkipPeriod = (TimeValue)ManagedIndexSettings.Companion.getSWEEP_SKIP_PERIOD().get(settings);
        this.indexStateManagementEnabled = (Boolean)ManagedIndexSettings.Companion.getINDEX_STATE_MANAGEMENT_ENABLED().get(settings);
        this.clusterService.addLifecycleListener((LifecycleListener)this);
        this.clusterService.addListener((ClusterStateListener)this);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getSWEEP_SKIP_PERIOD(), arg_0 -> PluginVersionSweepCoordinator._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    public final void setClusterService(@NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"<set-?>");
        this.clusterService = clusterService;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.$$delegate_0.getCoroutineContext();
    }

    public void afterStart() {
        this.initBackgroundSweepISMPluginVersionExecution();
    }

    public void beforeStop() {
        block0: {
            Scheduler.Cancellable cancellable = this.scheduledSkipExecution;
            if (cancellable == null) break block0;
            cancellable.cancel();
        }
    }

    public void clusterChanged(@NotNull ClusterChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.nodesChanged() || event.isNewCluster()) {
            this.skipExecution.sweepISMPluginVersion(this.clusterService);
            this.initBackgroundSweepISMPluginVersionExecution();
        }
    }

    @OpenForTesting
    public final void initBackgroundSweepISMPluginVersionExecution() {
        if (!this.isIndexStateManagementEnabled()) {
            return;
        }
        Scheduler.Cancellable cancellable = this.scheduledSkipExecution;
        if (cancellable != null) {
            cancellable.cancel();
        }
        Runnable scheduledJob2 = () -> PluginVersionSweepCoordinator.initBackgroundSweepISMPluginVersionExecution$lambda$1(this);
        this.scheduledSkipExecution = this.threadPool.scheduleWithFixedDelay(scheduledJob2, this.sweepSkipPeriod, "management");
    }

    private final boolean isIndexStateManagementEnabled() {
        return Intrinsics.areEqual((Object)this.indexStateManagementEnabled, (Object)true);
    }

    private static final void _init_$lambda$0(PluginVersionSweepCoordinator this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.sweepSkipPeriod = it;
        this$0.initBackgroundSweepISMPluginVersionExecution();
    }

    private static final void initBackgroundSweepISMPluginVersionExecution$lambda$1(PluginVersionSweepCoordinator this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        BuildersKt.launch$default((CoroutineScope)this$0, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ PluginVersionSweepCoordinator this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            if (!PluginVersionSweepCoordinator.access$getSkipExecution$p(this.this$0).getFlag()) {
                                PluginVersionSweepCoordinator.access$getLogger$p(this.this$0).info("Canceling sweep ism plugin version job");
                                Scheduler.Cancellable cancellable = PluginVersionSweepCoordinator.access$getScheduledSkipExecution$p(this.this$0);
                                if (cancellable != null) {
                                    Boxing.boxBoolean((boolean)cancellable.cancel());
                                }
                            } else {
                                PluginVersionSweepCoordinator.access$getSkipExecution$p(this.this$0).sweepISMPluginVersion(this.this$0.getClusterService());
                            }
                        }
                        catch (Exception e) {
                            PluginVersionSweepCoordinator.access$getLogger$p(this.this$0).error("Failed to sweep ism plugin version", (Throwable)e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ SkipExecution access$getSkipExecution$p(PluginVersionSweepCoordinator $this) {
        return $this.skipExecution;
    }

    public static final /* synthetic */ Logger access$getLogger$p(PluginVersionSweepCoordinator $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Scheduler.Cancellable access$getScheduledSkipExecution$p(PluginVersionSweepCoordinator $this) {
        return $this.scheduledSkipExecution;
    }
}

