/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.core.pipeline.jersey;

import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestContext;
import com.sun.jersey.api.client.ClientRequest;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JerseyServiceRequestContext
implements ServiceRequestContext {
    private ClientRequest clientRequest;

    public JerseyServiceRequestContext(ClientRequest clientRequest) {
        this.clientRequest = clientRequest;
    }

    @Override
    public Object getProperty(String name) {
        return this.clientRequest.getProperties().get(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.clientRequest.getProperties().put(name, value);
    }

    @Override
    public Map<String, String> getAllHeaders() {
        HashMap<String, String> allHeaders = new HashMap<String, String>();
        for (Map.Entry header : this.clientRequest.getHeaders().entrySet()) {
            if (header == null || ((List)header.getValue()).size() <= 0) continue;
            allHeaders.put((String)header.getKey(), (String)((List)header.getValue()).get(0));
        }
        return allHeaders;
    }

    @Override
    public URI getURI() {
        return this.clientRequest.getURI();
    }

    @Override
    public void setURI(URI uri) {
        this.clientRequest.setURI(uri);
    }

    @Override
    public URI getFullURI() {
        URI result = this.getURI();
        if (JerseyServiceRequestContext.isFullURI(result)) {
            return result;
        }
        throw new UnsupportedOperationException("The full URI is not available");
    }

    private static boolean isFullURI(URI uri) {
        if (uri == null) {
            return false;
        }
        String host = uri.getHost();
        return host != null && host.length() != 0;
    }

    @Override
    public String getMethod() {
        return this.clientRequest.getMethod();
    }

    @Override
    public void setMethod(String method) {
        this.clientRequest.setMethod(method);
    }

    @Override
    public Object getEntity() {
        return this.clientRequest.getEntity();
    }

    @Override
    public void setEntity(Object entity) {
        this.clientRequest.setEntity(entity);
    }

    @Override
    public String getHeader(String name) {
        List headers = (List)this.clientRequest.getHeaders().get((Object)name);
        if (headers != null && headers.size() > 0) {
            return (String)headers.get(0);
        }
        return null;
    }

    @Override
    public void setHeader(String name, String value) {
        this.clientRequest.getHeaders().add((Object)name, (Object)value);
    }

    @Override
    public void removeHeader(String name) {
        this.clientRequest.getHeaders().remove((Object)name);
    }
}

