/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.core.pipeline.jersey;

import com.microsoft.windowsazure.core.pipeline.jersey.EntityStreamingListener;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.CommittingOutputStream;
import com.sun.jersey.api.client.RequestWriter;
import com.sun.jersey.api.client.TerminatingClientHandler;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.core.header.InBoundHeaders;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;

public class HttpURLConnectionClientHandler
extends TerminatingClientHandler {
    private final int connectionTimeoutMillis;
    private final int readTimeoutMillis;
    private static final EntityStreamingListener EMPTY_STREAMING_LISTENER = new EntityStreamingListener(){

        @Override
        public void onBeforeStreamingEntity(ClientRequest clientRequest) {
        }
    };

    public HttpURLConnectionClientHandler(ClientConfig clientConfig) {
        this.connectionTimeoutMillis = HttpURLConnectionClientHandler.readTimeoutFromConfig(clientConfig, "com.sun.jersey.client.property.connectTimeout");
        this.readTimeoutMillis = HttpURLConnectionClientHandler.readTimeoutFromConfig(clientConfig, "com.sun.jersey.client.property.readTimeout");
    }

    private static int readTimeoutFromConfig(ClientConfig config, String propertyName) {
        Integer property = (Integer)config.getProperty(propertyName);
        if (property != null) {
            return property;
        }
        throw new IllegalArgumentException(propertyName);
    }

    public ClientResponse handle(ClientRequest ro) {
        try {
            return this.doHandle(ro);
        }
        catch (Exception e) {
            throw new ClientHandlerException((Throwable)e);
        }
    }

    private ClientResponse doHandle(final ClientRequest clientRequest) throws IOException {
        final HttpURLConnection urlConnection = (HttpURLConnection)clientRequest.getURI().toURL().openConnection();
        urlConnection.setReadTimeout(this.readTimeoutMillis);
        urlConnection.setConnectTimeout(this.connectionTimeoutMillis);
        final EntityStreamingListener entityStreamingListener = this.getEntityStreamingListener(clientRequest);
        urlConnection.setRequestMethod(clientRequest.getMethod());
        this.setURLConnectionHeaders((MultivaluedMap<String, Object>)clientRequest.getHeaders(), urlConnection);
        Object entity = clientRequest.getEntity();
        if (entity == null && "PUT".equals(clientRequest.getMethod())) {
            entity = new byte[0];
            clientRequest.setEntity(entity);
        }
        if (entity != null) {
            urlConnection.setDoOutput(true);
            this.writeRequestEntity(clientRequest, new RequestWriter.RequestEntityWriterListener(){
                private boolean inStreamingMode;

                public void onRequestEntitySize(long size) {
                    if (size != -1L && size < Integer.MAX_VALUE) {
                        this.inStreamingMode = true;
                        HttpURLConnectionClientHandler.this.setContentLengthHeader(clientRequest, (int)size);
                        entityStreamingListener.onBeforeStreamingEntity(clientRequest);
                        urlConnection.setFixedLengthStreamingMode((int)size);
                    } else {
                        Integer chunkedEncodingSize = (Integer)clientRequest.getProperties().get("com.sun.jersey.client.property.chunkedEncodingSize");
                        if (chunkedEncodingSize != null) {
                            this.inStreamingMode = true;
                            entityStreamingListener.onBeforeStreamingEntity(clientRequest);
                            urlConnection.setChunkedStreamingMode(chunkedEncodingSize);
                        }
                    }
                }

                public OutputStream onGetOutputStream() throws IOException {
                    if (this.inStreamingMode) {
                        return new StreamingOutputStream(urlConnection, clientRequest);
                    }
                    return new BufferingOutputStream(urlConnection, clientRequest, entityStreamingListener);
                }
            });
        } else {
            entityStreamingListener.onBeforeStreamingEntity(clientRequest);
            this.setURLConnectionHeaders((MultivaluedMap<String, Object>)clientRequest.getHeaders(), urlConnection);
        }
        return new URLConnectionResponse(urlConnection.getResponseCode(), this.getInBoundHeaders(urlConnection), this.getInputStream(urlConnection), clientRequest.getMethod(), urlConnection);
    }

    private EntityStreamingListener getEntityStreamingListener(ClientRequest clientRequest) {
        EntityStreamingListener result = (EntityStreamingListener)clientRequest.getProperties().get(EntityStreamingListener.class.getName());
        if (result != null) {
            return result;
        }
        return EMPTY_STREAMING_LISTENER;
    }

    private void setContentLengthHeader(ClientRequest clientRequest, int size) {
        if (clientRequest.getHeaders().getFirst((Object)"Content-Length") != null) {
            return;
        }
        if (size < 0) {
            return;
        }
        clientRequest.getHeaders().putSingle((Object)"Content-Length", (Object)size);
    }

    private void setURLConnectionHeaders(MultivaluedMap<String, Object> headers, HttpURLConnection urlConnection) {
        for (Map.Entry e : headers.entrySet()) {
            List vs = (List)e.getValue();
            if (vs.size() == 1) {
                urlConnection.setRequestProperty((String)e.getKey(), ClientRequest.getHeaderValue(vs.get(0)));
                continue;
            }
            CollectionStringBuilder sb = new CollectionStringBuilder();
            for (Object v : (List)e.getValue()) {
                sb.add(ClientRequest.getHeaderValue(v));
            }
            urlConnection.setRequestProperty((String)e.getKey(), sb.toString());
        }
    }

    private InBoundHeaders getInBoundHeaders(HttpURLConnection urlConnection) {
        InBoundHeaders headers = new InBoundHeaders();
        for (Map.Entry<String, List<String>> e : urlConnection.getHeaderFields().entrySet()) {
            if (e.getKey() == null) continue;
            headers.put((Object)e.getKey(), e.getValue());
        }
        return headers;
    }

    private InputStream getInputStream(HttpURLConnection urlConnection) throws IOException {
        if (urlConnection.getResponseCode() < 300) {
            return urlConnection.getInputStream();
        }
        InputStream ein = urlConnection.getErrorStream();
        return ein != null ? ein : new ByteArrayInputStream(new byte[0]);
    }

    private final class URLConnectionResponse
    extends ClientResponse {
        private final String method;
        private final HttpURLConnection urlConnection;

        URLConnectionResponse(int status, InBoundHeaders headers, InputStream entity, String method, HttpURLConnection urlConnection) {
            super(status, headers, entity, HttpURLConnectionClientHandler.this.getMessageBodyWorkers());
            this.method = method;
            this.urlConnection = urlConnection;
        }

        public boolean hasEntity() {
            if (this.method.equals("HEAD") || this.getEntityInputStream() == null) {
                return false;
            }
            int length = this.urlConnection.getContentLength();
            return length > 0 || length == -1;
        }

        public String toString() {
            return this.urlConnection.getRequestMethod() + " " + this.urlConnection.getURL() + " returned a response status of " + this.getStatus() + " " + this.getClientResponseStatus();
        }
    }

    private final class StreamingOutputStream
    extends CommittingOutputStream {
        private final HttpURLConnection urlConnection;
        private final ClientRequest clientRequest;

        private StreamingOutputStream(HttpURLConnection urlConnection, ClientRequest clientRequest) {
            this.urlConnection = urlConnection;
            this.clientRequest = clientRequest;
        }

        protected OutputStream getOutputStream() throws IOException {
            return this.urlConnection.getOutputStream();
        }

        public void commit() throws IOException {
            HttpURLConnectionClientHandler.this.setURLConnectionHeaders((MultivaluedMap<String, Object>)this.clientRequest.getHeaders(), this.urlConnection);
        }
    }

    private final class BufferingOutputStream
    extends OutputStream {
        private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        private final HttpURLConnection urlConnection;
        private final ClientRequest clientRequest;
        private final EntityStreamingListener entityStreamingListener;
        private boolean closed;

        private BufferingOutputStream(HttpURLConnection urlConnection, ClientRequest clientRequest, EntityStreamingListener entityStreamingListener) {
            this.urlConnection = urlConnection;
            this.clientRequest = clientRequest;
            this.entityStreamingListener = entityStreamingListener;
        }

        @Override
        public void close() throws IOException {
            this.outputStream.close();
            if (!this.closed) {
                this.closed = true;
                HttpURLConnectionClientHandler.this.setContentLengthHeader(this.clientRequest, this.outputStream.size());
                this.entityStreamingListener.onBeforeStreamingEntity(this.clientRequest);
                HttpURLConnectionClientHandler.this.setURLConnectionHeaders((MultivaluedMap<String, Object>)this.clientRequest.getHeaders(), this.urlConnection);
                this.urlConnection.setFixedLengthStreamingMode(this.outputStream.size());
                OutputStream httpOutputStream = this.urlConnection.getOutputStream();
                this.outputStream.writeTo(httpOutputStream);
                httpOutputStream.flush();
                httpOutputStream.close();
            }
        }

        @Override
        public void flush() throws IOException {
            this.outputStream.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.outputStream.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.outputStream.write(b);
        }

        @Override
        public void write(int b) {
            this.outputStream.write(b);
        }
    }
}

