"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const unist_util_visit_1 = __importDefault(require("unist-util-visit"));
//jupyter notebook cell attachment spec dictates all attachments start with this prefix.
const ATTACHMENT_PREFIX = "attachment:";
function attachmentTransformer(attachments) {
    return function (tree, props) {
        if (!attachments)
            return tree;
        unist_util_visit_1.default(tree, "image", function (node) {
            const imageUrl = node.url;
            //if image url has reserved attachment prefix and cellAttachments were provided attempt to inline attachment data in markdown.
            if (imageUrl.indexOf(ATTACHMENT_PREFIX) === 0) {
                const key = imageUrl.substring(ATTACHMENT_PREFIX.length, imageUrl.length);
                const dataSrc = attachments[key];
                if (dataSrc) {
                    node.url = dataSrc;
                }
            }
        });
        return tree;
    };
}
exports.default = attachmentTransformer;
