/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.reindex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.reindex.BulkByScrollTask;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.ReindexAction;
import org.opensearch.index.reindex.ReindexSslConfig;
import org.opensearch.index.reindex.RestDeleteByQueryAction;
import org.opensearch.index.reindex.RestReindexAction;
import org.opensearch.index.reindex.RestRethrottleAction;
import org.opensearch.index.reindex.RestUpdateByQueryAction;
import org.opensearch.index.reindex.RethrottleAction;
import org.opensearch.index.reindex.TransportDeleteByQueryAction;
import org.opensearch.index.reindex.TransportReindexAction;
import org.opensearch.index.reindex.TransportRethrottleAction;
import org.opensearch.index.reindex.TransportUpdateByQueryAction;
import org.opensearch.index.reindex.UpdateByQueryAction;
import org.opensearch.index.reindex.spi.RemoteReindexExtension;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.ExtensiblePlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptService;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;
import org.opensearch.watcher.ResourceWatcherService;

public class ReindexModulePlugin
extends Plugin
implements ActionPlugin,
ExtensiblePlugin {
    public static final String NAME = "reindex";
    private static final Logger logger = LogManager.getLogger(ReindexModulePlugin.class);

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)ReindexAction.INSTANCE, TransportReindexAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateByQueryAction.INSTANCE, TransportUpdateByQueryAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteByQueryAction.INSTANCE, TransportDeleteByQueryAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)RethrottleAction.INSTANCE, TransportRethrottleAction.class, new Class[0]));
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Collections.singletonList(new NamedWriteableRegistry.Entry(Task.Status.class, "bulk-by-scroll", BulkByScrollTask.Status::new));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Arrays.asList(new RestHandler[]{new RestReindexAction(), new RestUpdateByQueryAction(), new RestDeleteByQueryAction(), new RestRethrottleAction(nodesInCluster)});
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        return Collections.singletonList(new ReindexSslConfig(environment.settings(), environment, resourceWatcherService));
    }

    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.add(TransportReindexAction.REMOTE_CLUSTER_ALLOWLIST);
        settings.add(TransportReindexAction.REMOTE_REINDEX_RETRY_INITIAL_BACKOFF);
        settings.add(TransportReindexAction.REMOTE_REINDEX_RETRY_MAX_COUNT);
        settings.addAll(ReindexSslConfig.getSettings());
        return settings;
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        logger.info("ReindexPlugin reloadSPI called");
        List iterable = loader.loadExtensions(RemoteReindexExtension.class);
        ArrayList remoteReindexExtensionList = new ArrayList();
        iterable.forEach(remoteReindexExtensionList::add);
        if (remoteReindexExtensionList.isEmpty()) {
            logger.info("Unable to find any implementation for RemoteReindexExtension");
        } else {
            if (remoteReindexExtensionList.size() > 1) {
                logger.warn("More than one implementation found: " + String.valueOf(remoteReindexExtensionList));
            }
            TransportReindexAction.remoteExtension = Optional.ofNullable((RemoteReindexExtension)remoteReindexExtensionList.get(0));
            logger.info("Loaded extension " + String.valueOf(TransportReindexAction.remoteExtension));
        }
    }
}

