/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.javaagent;

import java.io.FilePermission;
import java.lang.reflect.Method;
import java.net.NetPermission;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.spi.FileSystemProvider;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Set;
import net.bytebuddy.asm.Advice;
import org.opensearch.javaagent.StackCallerProtectionDomainChainExtractor;
import org.opensearch.javaagent.bootstrap.AgentPolicy;

public class FileInterceptor {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Advice.OnMethodEnter
    public static void intercept(@Advice.AllArguments Object[] args, @Advice.Origin Method method) throws Exception {
        boolean isDelete;
        Object object;
        Policy policy = AgentPolicy.getPolicy();
        if (policy == null) {
            return;
        }
        FileSystemProvider provider = null;
        String filePath = null;
        if (args.length > 0 && (object = args[0]) instanceof String) {
            String pathStr = (String)object;
            filePath = Paths.get(pathStr, new String[0]).toAbsolutePath().toString();
        } else if (args.length > 0 && (object = args[0]) instanceof Path) {
            Path path = (Path)object;
            filePath = path.toAbsolutePath().toString();
            provider = path.getFileSystem().provider();
        }
        if (filePath == null) {
            return;
        }
        if (provider != null && AgentPolicy.isTrustedFileSystem((String)provider.getScheme())) {
            return;
        }
        StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        Collection<ProtectionDomain> callers = walker.walk(StackCallerProtectionDomainChainExtractor.INSTANCE);
        String name = method.getName();
        boolean isMutating = name.equals("move") || name.equals("write") || name.startsWith("create");
        boolean bl = isDelete = !isMutating ? name.startsWith("delete") : false;
        if (isDelete && walker.getCallerClass().getName().equalsIgnoreCase("sun.nio.ch.PipeImpl$Initializer$LoopbackConnector")) {
            NetPermission permission = new NetPermission("accessUnixDomainSocket");
            for (ProtectionDomain domain : callers) {
                if (policy.implies(domain, permission)) continue;
                throw new SecurityException("Denied access to: " + filePath + ", domain " + String.valueOf(domain));
            }
            return;
        }
        String targetFilePath = null;
        if (!isMutating && !isDelete) {
            if (name.equals("newByteChannel") || name.equals("open")) {
                if (args.length > 1 && args instanceof Object) {
                    if (args instanceof OpenOption[]) {
                        OpenOption[] opts;
                        for (OpenOption openOption : opts = (OpenOption[])args) {
                            if (openOption == StandardOpenOption.READ) continue;
                            isMutating = true;
                            break;
                        }
                    } else {
                        Object object2 = args[1];
                        if (object2 instanceof Set) {
                            Set opts = (Set)object2;
                            Set set = (Set)args[1];
                            for (OpenOption opt : set) {
                                if (opt == StandardOpenOption.READ) continue;
                                isMutating = true;
                                break;
                            }
                        } else {
                            Object[] opts;
                            Object object3 = args[1];
                            if (!(object3 instanceof Object[])) throw new SecurityException("Unsupported argument type: " + args[1].getClass().getName());
                            for (Object object4 : opts = (Object[])object3) {
                                if (object4 == StandardOpenOption.READ) continue;
                                isMutating = true;
                                break;
                            }
                        }
                    }
                }
            } else if (name.equals("copy")) {
                Object object5;
                if (args.length > 1 && (object5 = args[1]) instanceof String) {
                    String pathStr = (String)object5;
                    targetFilePath = Paths.get(pathStr, new String[0]).toAbsolutePath().toString();
                } else if (args.length > 1 && (object5 = args[1]) instanceof Path) {
                    Path path = (Path)object5;
                    targetFilePath = path.toAbsolutePath().toString();
                }
            }
        }
        for (ProtectionDomain domain : callers) {
            if (method.getName().equals("open") || method.getName().equals("newByteChannel")) {
                if (isMutating && !policy.implies(domain, new FilePermission(filePath, "read,write"))) {
                    throw new SecurityException("Denied OPEN (read/write) access to file: " + filePath + ", domain: " + String.valueOf(domain));
                }
                if (!policy.implies(domain, new FilePermission(filePath, "read"))) {
                    throw new SecurityException("Denied OPEN (read) access to file: " + filePath + ", domain: " + String.valueOf(domain));
                }
            }
            if (method.getName().equals("copy")) {
                if (!policy.implies(domain, new FilePermission(filePath, "read"))) {
                    throw new SecurityException("Denied COPY (read) access to file: " + filePath + ", domain: " + String.valueOf(domain));
                }
                if (targetFilePath != null && !policy.implies(domain, new FilePermission(targetFilePath, "write"))) {
                    throw new SecurityException("Denied COPY (write) access to file: " + targetFilePath + ", domain: " + String.valueOf(domain));
                }
            }
            if (isMutating && !policy.implies(domain, new FilePermission(filePath, "write"))) {
                throw new SecurityException("Denied WRITE access to file: " + filePath + ", domain: " + String.valueOf(domain));
            }
            if (!isDelete || policy.implies(domain, new FilePermission(filePath, "delete"))) continue;
            throw new SecurityException("Denied DELETE access to file: " + filePath + ", domain: " + String.valueOf(domain));
        }
    }
}

