/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile.query;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.opensearch.search.profile.ContextualProfileBreakdown;
import org.opensearch.search.profile.Timer;
import org.opensearch.search.profile.query.ProfileScorer;
import org.opensearch.search.profile.query.QueryTimingType;

public final class ProfileWeight
extends Weight {
    private final Weight subQueryWeight;
    private final ContextualProfileBreakdown<QueryTimingType> profile;

    public ProfileWeight(Query query, Weight subQueryWeight, ContextualProfileBreakdown<QueryTimingType> profile) throws IOException {
        super(query);
        this.subQueryWeight = subQueryWeight;
        this.profile = profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
        ScorerSupplier subQueryScorerSupplier;
        final Timer timer = this.profile.context(context).getTimer(QueryTimingType.BUILD_SCORER);
        timer.start();
        try {
            subQueryScorerSupplier = this.subQueryWeight.scorerSupplier(context);
        }
        finally {
            timer.stop();
        }
        if (subQueryScorerSupplier == null) {
            return null;
        }
        return new ScorerSupplier(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Scorer get(long loadCost) throws IOException {
                timer.start();
                try {
                    ProfileScorer profileScorer = new ProfileScorer(subQueryScorerSupplier.get(loadCost), ProfileWeight.this.profile.context(context));
                    return profileScorer;
                }
                finally {
                    timer.stop();
                }
            }

            public long cost() {
                timer.start();
                try {
                    long l = subQueryScorerSupplier.cost();
                    return l;
                }
                finally {
                    timer.stop();
                }
            }
        };
    }

    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        return this.subQueryWeight.explain(context, doc);
    }

    public int count(LeafReaderContext context) throws IOException {
        return this.subQueryWeight.count(context);
    }

    public boolean isCacheable(LeafReaderContext ctx) {
        return false;
    }

    public void associateCollectorToLeaves(LeafReaderContext leaf, Collector collector) {
        this.profile.associateCollectorToLeaves(collector, leaf);
    }
}

