/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ratelimitting.admissioncontrol.stats;

import java.io.IOException;
import java.util.Map;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ratelimitting.admissioncontrol.controllers.AdmissionController;

public class AdmissionControllerStats
implements Writeable,
ToXContentFragment {
    public Map<String, Long> rejectionCount;
    public String admissionControllerName;

    public AdmissionControllerStats(AdmissionController admissionController) {
        this.rejectionCount = admissionController.getRejectionStats();
        this.admissionControllerName = admissionController.getName();
    }

    public AdmissionControllerStats(StreamInput in) throws IOException {
        this.rejectionCount = in.readMap(StreamInput::readString, StreamInput::readLong);
        this.admissionControllerName = in.readString();
    }

    public String getAdmissionControllerName() {
        return this.admissionControllerName;
    }

    public Map<String, Long> getRejectionCount() {
        return this.rejectionCount;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.rejectionCount, StreamOutput::writeString, StreamOutput::writeLong);
        out.writeString(this.admissionControllerName);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("transport");
        builder.startObject("rejection_count");
        for (Map.Entry<String, Long> rejectionCountEntry : this.rejectionCount.entrySet()) {
            builder.field(rejectionCountEntry.getKey(), rejectionCountEntry.getValue());
        }
        builder.endObject();
        builder.endObject();
        return builder.endObject();
    }
}

