/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.filecache;

import java.io.IOException;
import java.util.EnumSet;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.store.remote.filecache.FileCacheStats;

@ExperimentalApi
public class AggregateFileCacheStats
implements Writeable,
ToXContentFragment {
    private final long timestamp;
    private final FileCacheStats overallFileCacheStats;
    private final FileCacheStats fullFileCacheStats;
    private final FileCacheStats blockFileCacheStats;
    private final FileCacheStats pinnedFileCacheStats;

    public AggregateFileCacheStats(long timestamp, FileCacheStats overallFileCacheStats, FileCacheStats fullFileCacheStats, FileCacheStats blockFileCacheStats, FileCacheStats pinnedFileCacheStats) {
        this.timestamp = timestamp;
        this.overallFileCacheStats = overallFileCacheStats;
        this.fullFileCacheStats = fullFileCacheStats;
        this.blockFileCacheStats = blockFileCacheStats;
        this.pinnedFileCacheStats = pinnedFileCacheStats;
    }

    public AggregateFileCacheStats(StreamInput in) throws IOException {
        this.timestamp = in.readLong();
        this.overallFileCacheStats = new FileCacheStats(in);
        this.fullFileCacheStats = new FileCacheStats(in);
        this.blockFileCacheStats = new FileCacheStats(in);
        this.pinnedFileCacheStats = new FileCacheStats(in);
    }

    public static short calculatePercentage(long used, long max) {
        return max <= 0L ? (short)0 : (short)Math.round(100.0 * (double)used / (double)max);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.timestamp);
        this.overallFileCacheStats.writeTo(out);
        this.fullFileCacheStats.writeTo(out);
        this.blockFileCacheStats.writeTo(out);
        this.pinnedFileCacheStats.writeTo(out);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ByteSizeValue getTotal() {
        return new ByteSizeValue(this.overallFileCacheStats.getTotal());
    }

    public ByteSizeValue getActive() {
        return new ByteSizeValue(this.overallFileCacheStats.getActive());
    }

    public short getActivePercent() {
        return AggregateFileCacheStats.calculatePercentage(this.overallFileCacheStats.getActive(), this.overallFileCacheStats.getUsed());
    }

    public ByteSizeValue getUsed() {
        return new ByteSizeValue(this.overallFileCacheStats.getUsed());
    }

    public ByteSizeValue getPinnedUsage() {
        return new ByteSizeValue(this.overallFileCacheStats.getPinnedUsage());
    }

    public short getUsedPercent() {
        return AggregateFileCacheStats.calculatePercentage(this.getUsed().getBytes(), this.getTotal().getBytes());
    }

    public ByteSizeValue getEvicted() {
        return new ByteSizeValue(this.overallFileCacheStats.getEvicted());
    }

    public long getCacheHits() {
        return this.overallFileCacheStats.getCacheHits();
    }

    public long getCacheMisses() {
        return this.overallFileCacheStats.getCacheMisses();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("aggregate_file_cache");
        builder.field("timestamp", this.getTimestamp());
        builder.humanReadableField("active_in_bytes", "active", (Object)this.getActive());
        builder.humanReadableField("total_in_bytes", "total", (Object)this.getTotal());
        builder.humanReadableField("used_in_bytes", "used", (Object)this.getUsed());
        builder.humanReadableField("pinned_in_bytes", "pinned", (Object)this.getPinnedUsage());
        builder.humanReadableField("evictions_in_bytes", "evictions", (Object)this.getEvicted());
        builder.field("active_percent", this.getActivePercent());
        builder.field("used_percent", this.getUsedPercent());
        builder.field("hit_count", this.getCacheHits());
        builder.field("miss_count", this.getCacheMisses());
        this.overallFileCacheStats.toXContent(builder, params);
        this.fullFileCacheStats.toXContent(builder, params);
        this.blockFileCacheStats.toXContent(builder, params);
        this.pinnedFileCacheStats.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String AGGREGATE_FILE_CACHE = "aggregate_file_cache";
        static final String TIMESTAMP = "timestamp";
        static final String ACTIVE = "active";
        static final String ACTIVE_IN_BYTES = "active_in_bytes";
        static final String USED = "used";
        static final String USED_IN_BYTES = "used_in_bytes";
        static final String PINNED = "pinned";
        static final String PINNED_IN_BYTES = "pinned_in_bytes";
        static final String EVICTIONS = "evictions";
        static final String EVICTIONS_IN_BYTES = "evictions_in_bytes";
        static final String TOTAL = "total";
        static final String TOTAL_IN_BYTES = "total_in_bytes";
        static final String ACTIVE_PERCENT = "active_percent";
        static final String USED_PERCENT = "used_percent";
        static final String HIT_COUNT = "hit_count";
        static final String MISS_COUNT = "miss_count";

        Fields() {
        }
    }

    @ExperimentalApi
    public static enum FileCacheStatsType {
        FULL_FILE_STATS("full_file_stats"),
        BLOCK_FILE_STATS("block_file_stats"),
        OVER_ALL_STATS("over_all_stats"),
        PINNED_FILE_STATS("pinned_file_stats");

        private final String fileCacheStatsType;

        private FileCacheStatsType(String fileCacheStatsType) {
            this.fileCacheStatsType = fileCacheStatsType;
        }

        public String toString() {
            return this.fileCacheStatsType;
        }

        public static FileCacheStatsType fromString(String fileCacheStatsType) {
            return EnumSet.allOf(FileCacheStatsType.class).stream().filter(f -> f.fileCacheStatsType.equals(fileCacheStatsType)).findFirst().orElseThrow(() -> new IllegalArgumentException("Found invalid fileCacheStatsType."));
        }
    }
}

