/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree.aggregators;

import org.opensearch.index.compositeindex.datacube.startree.aggregators.ValueAggregator;
import org.opensearch.index.mapper.FieldValueConverter;
import org.opensearch.index.mapper.NumberFieldMapper;

public class CountValueAggregator
implements ValueAggregator<Long> {
    public static final long DEFAULT_INITIAL_VALUE = 1L;
    private static final FieldValueConverter VALUE_AGGREGATOR_TYPE = NumberFieldMapper.NumberType.LONG;

    @Override
    public FieldValueConverter getAggregatedValueType() {
        return VALUE_AGGREGATOR_TYPE;
    }

    @Override
    public Long getInitialAggregatedValueForSegmentDocValue(Long segmentDocValue) {
        if (segmentDocValue == null) {
            return this.getIdentityMetricValue();
        }
        return 1L;
    }

    @Override
    public Long mergeAggregatedValueAndSegmentValue(Long value, Long segmentDocValue) {
        assert (value != null);
        if (segmentDocValue != null) {
            return value + 1L;
        }
        return value;
    }

    @Override
    public Long mergeAggregatedValues(Long value, Long aggregatedValue) {
        if (value == null) {
            value = this.getIdentityMetricValue();
        }
        if (aggregatedValue == null) {
            aggregatedValue = this.getIdentityMetricValue();
        }
        return value + aggregatedValue;
    }

    @Override
    public Long toAggregatedValueType(Long value) {
        return value;
    }

    @Override
    public Long getIdentityMetricValue() {
        return 0L;
    }
}

