/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.TotalHits;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchRequestOperationsListener;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.ShardStatsFieldNames;
import org.opensearch.common.annotation.InternalApi;
import org.opensearch.core.index.Index;
import org.opensearch.core.tasks.resourcetracker.TaskResourceInfo;

@InternalApi
public class SearchRequestContext {
    private static final Logger logger = LogManager.getLogger();
    private final SearchRequestOperationsListener searchRequestOperationsListener;
    private long absoluteStartNanos;
    private final Map<String, Long> phaseTookMap;
    private TotalHits totalHits;
    private final EnumMap<ShardStatsFieldNames, Integer> shardStats;
    private Set<Index> successfulSearchShardIndices;
    private final SearchRequest searchRequest;
    private final LinkedBlockingQueue<TaskResourceInfo> phaseResourceUsage;
    private final Supplier<TaskResourceInfo> taskResourceUsageSupplier;

    SearchRequestContext(SearchRequestOperationsListener searchRequestOperationsListener, SearchRequest searchRequest, Supplier<TaskResourceInfo> taskResourceUsageSupplier) {
        this.searchRequestOperationsListener = searchRequestOperationsListener;
        this.absoluteStartNanos = System.nanoTime();
        this.phaseTookMap = new HashMap<String, Long>();
        this.shardStats = new EnumMap(ShardStatsFieldNames.class);
        this.searchRequest = searchRequest;
        this.phaseResourceUsage = new LinkedBlockingQueue();
        this.taskResourceUsageSupplier = taskResourceUsageSupplier;
    }

    SearchRequestOperationsListener getSearchRequestOperationsListener() {
        return this.searchRequestOperationsListener;
    }

    void updatePhaseTookMap(String phaseName, Long tookTime) {
        this.phaseTookMap.put(phaseName, tookTime);
    }

    public Map<String, Long> phaseTookMap() {
        return this.phaseTookMap;
    }

    SearchResponse.PhaseTook getPhaseTook() {
        if (this.searchRequest != null && this.searchRequest.isPhaseTook() != null && this.searchRequest.isPhaseTook().booleanValue()) {
            return new SearchResponse.PhaseTook(this.phaseTookMap);
        }
        return null;
    }

    void setAbsoluteStartNanos(long absoluteStartNanos) {
        this.absoluteStartNanos = absoluteStartNanos;
    }

    public long getAbsoluteStartNanos() {
        return this.absoluteStartNanos;
    }

    void setTotalHits(TotalHits totalHits) {
        this.totalHits = totalHits;
    }

    public TotalHits totalHits() {
        return this.totalHits;
    }

    void setShardStats(int total, int successful, int skipped, int failed) {
        this.shardStats.put(ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_TOTAL, total);
        this.shardStats.put(ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_SUCCESSFUL, successful);
        this.shardStats.put(ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_SKIPPED, skipped);
        this.shardStats.put(ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_FAILED, failed);
    }

    String formattedShardStats() {
        if (this.shardStats.isEmpty()) {
            return "";
        }
        return String.format(Locale.ROOT, "{%s:%s, %s:%s, %s:%s, %s:%s}", ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_TOTAL.toString(), this.shardStats.get((Object)ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_TOTAL), ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_SUCCESSFUL.toString(), this.shardStats.get((Object)ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_SUCCESSFUL), ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_SKIPPED.toString(), this.shardStats.get((Object)ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_SKIPPED), ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_FAILED.toString(), this.shardStats.get((Object)ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_FAILED));
    }

    public Supplier<TaskResourceInfo> getTaskResourceUsageSupplier() {
        return this.taskResourceUsageSupplier;
    }

    public void recordPhaseResourceUsage(TaskResourceInfo usage) {
        if (usage != null) {
            this.phaseResourceUsage.add(usage);
        }
    }

    public List<TaskResourceInfo> getPhaseResourceUsage() {
        return new ArrayList<TaskResourceInfo>(this.phaseResourceUsage);
    }

    public SearchRequest getRequest() {
        return this.searchRequest;
    }

    void setSuccessfulSearchShardIndices(Set<Index> successfulSearchShardIndices) {
        this.successfulSearchShardIndices = successfulSearchShardIndices;
    }

    public Set<Index> getSuccessfulSearchShardIndices() {
        return this.successfulSearchShardIndices;
    }
}

