/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.repositories.verify;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

@PublicApi(since="1.0.0")
public class VerifyRepositoryResponse
extends ActionResponse
implements ToXContentObject {
    static final String NODES = "nodes";
    static final String NAME = "name";
    private List<NodeView> nodes;
    private static final ObjectParser<VerifyRepositoryResponse, Void> PARSER = new ObjectParser(VerifyRepositoryResponse.class.getName(), true, VerifyRepositoryResponse::new);

    public VerifyRepositoryResponse() {
    }

    public VerifyRepositoryResponse(StreamInput in) throws IOException {
        super(in);
        this.nodes = in.readList(NodeView::new);
    }

    public VerifyRepositoryResponse(DiscoveryNode[] nodes) {
        this.nodes = Arrays.stream(nodes).map(dn -> new NodeView(dn.getId(), dn.getName())).collect(Collectors.toList());
    }

    public VerifyRepositoryResponse(List<NodeView> nodes) {
        this.nodes = nodes;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.nodes);
    }

    public List<NodeView> getNodes() {
        return this.nodes;
    }

    protected void setNodes(List<NodeView> nodes) {
        this.nodes = nodes;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(NODES);
        for (NodeView node : this.nodes) {
            node.toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static VerifyRepositoryResponse fromXContent(XContentParser parser) {
        return (VerifyRepositoryResponse)((Object)PARSER.apply(parser, null));
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        VerifyRepositoryResponse that = (VerifyRepositoryResponse)((Object)o);
        return Objects.equals(this.nodes, that.nodes);
    }

    public int hashCode() {
        return Objects.hash(this.nodes);
    }

    static {
        PARSER.declareNamedObjects(VerifyRepositoryResponse::setNodes, NodeView.PARSER, new ParseField(NODES, new String[0]));
    }

    @PublicApi(since="1.0.0")
    public static class NodeView
    implements Writeable,
    ToXContentObject {
        private static final ObjectParser.NamedObjectParser<NodeView, Void> PARSER;
        final String nodeId;
        String name;

        public NodeView(String nodeId) {
            this.nodeId = nodeId;
        }

        public NodeView(String nodeId, String name) {
            this(nodeId);
            this.name = name;
        }

        public NodeView(StreamInput in) throws IOException {
            this(in.readString(), in.readString());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeId);
            out.writeString(this.name);
        }

        void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.nodeId);
            builder.field(VerifyRepositoryResponse.NAME, this.name);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeView other = (NodeView)obj;
            return Objects.equals(this.nodeId, other.nodeId) && Objects.equals(this.name, other.name);
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.name);
        }

        static {
            ObjectParser internalParser = new ObjectParser(VerifyRepositoryResponse.NODES, true, null);
            internalParser.declareString(NodeView::setName, new ParseField(VerifyRepositoryResponse.NAME, new String[0]));
            PARSER = (p, v, name) -> (NodeView)internalParser.parse(p, (Object)new NodeView(name), null);
        }
    }
}

