/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u0014\u0010\u0003\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0014\u0010\u0007\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\tH\u0002\u001a\u0018\u0010\n\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\f\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a!\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000e0\u0011H\u0082\b\u00a8\u0006\u0012"}, d2={"isIgnorable", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "isMustUseReturnValue", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isIgnorableValue", "isLocalPropertyOrParameterOrThis", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "isExcluded", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "isSubjectToCheck", "ifMappedTypeCollection", "", "Lorg/jetbrains/kotlin/name/CallableId;", "nonIgnorableCollectionMethod", "Lkotlin/Function1;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnusedReturnValueChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnusedReturnValueChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnusedReturnValueCheckerKt\n*L\n1#1,183:1\n150#1,33:184\n*S KotlinDebug\n*F\n+ 1 FirUnusedReturnValueChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnusedReturnValueCheckerKt\n*L\n141#1:184,33\n*E\n"})
public final class FirUnusedReturnValueCheckerKt {
    private static final boolean isIgnorable(ConeKotlinType $this$isIgnorable) {
        return ConeBuiltinTypeUtilsKt.isNothingOrNullableNothing($this$isIgnorable) || ConeBuiltinTypeUtilsKt.isUnit($this$isIgnorable);
    }

    private static final boolean isMustUseReturnValue(FirAnnotation $this$isMustUseReturnValue, FirSession session2) {
        return Intrinsics.areEqual(FirAnnotationUtilsKt.toAnnotationClassId($this$isMustUseReturnValue, session2), StandardClassIds.Annotations.INSTANCE.getMustUseReturnValue());
    }

    private static final boolean isIgnorableValue(FirAnnotation $this$isIgnorableValue, FirSession session2) {
        return Intrinsics.areEqual(FirAnnotationUtilsKt.toAnnotationClassId($this$isIgnorableValue, session2), StandardClassIds.Annotations.INSTANCE.getIgnorableReturnValue());
    }

    private static final boolean isExcluded(FirCallableSymbol<?> $this$isExcluded, FirSession session2) {
        return FirAnnotationUtilsKt.hasAnnotation((FirBasedSymbol)$this$isExcluded, StandardClassIds.Annotations.INSTANCE.getIgnorableReturnValue(), session2);
    }

    private static final boolean isSubjectToCheck(FirCallableSymbol<?> $this$isSubjectToCheck, FirSession session2) {
        Object object;
        if (Intrinsics.areEqual($this$isSubjectToCheck.getCallableId().getPackageName().asString(), "kotlin")) {
            return true;
        }
        CallableId $this$ifMappedTypeCollection$iv = $this$isSubjectToCheck.getCallableId();
        boolean $i$f$ifMappedTypeCollection = false;
        String packageName$iv = $this$ifMappedTypeCollection$iv.getPackageName().asString();
        if ((Intrinsics.areEqual(packageName$iv, "kotlin.collections") || Intrinsics.areEqual(packageName$iv, "java.util")) && (object = $this$ifMappedTypeCollection$iv.getClassName()) != null && (object = ((FqName)object).asString()) != null) {
            Object className$iv = object;
            String[] stringArray = new String[]{"Collection", "MutableCollection", "List", "MutableList", "ArrayList", "Set", "MutableSet", "HashSet", "LinkedHashSet", "Map", "MutableMap", "HashMap", "LinkedHashMap", "ArrayDeque"};
            if (SetsKt.setOf(stringArray).contains(className$iv)) {
                stringArray = new String[]{"add", "addAll", "remove", "removeAt", "set", "put", "retainAll", "removeLast"};
                boolean it = !SetsKt.setOf(stringArray).contains($this$ifMappedTypeCollection$iv.getCallableName().asString());
                boolean bl = false;
                return it;
            }
        }
        FirBasedSymbol<?> firBasedSymbol = FirHelpersKt.getContainingSymbol($this$isSubjectToCheck, session2);
        if (firBasedSymbol == null) {
            return false;
        }
        FirBasedSymbol<?> classOrFile = firBasedSymbol;
        return FirAnnotationUtilsKt.hasAnnotation(classOrFile, StandardClassIds.Annotations.INSTANCE.getMustUseReturnValue(), session2);
    }

    public static final /* synthetic */ boolean access$isMustUseReturnValue(FirAnnotation $receiver, FirSession session2) {
        return FirUnusedReturnValueCheckerKt.isMustUseReturnValue($receiver, session2);
    }

    public static final /* synthetic */ boolean access$isIgnorableValue(FirAnnotation $receiver, FirSession session2) {
        return FirUnusedReturnValueCheckerKt.isIgnorableValue($receiver, session2);
    }

    public static final /* synthetic */ boolean access$isIgnorable(ConeKotlinType $receiver) {
        return FirUnusedReturnValueCheckerKt.isIgnorable($receiver);
    }

    public static final /* synthetic */ boolean access$isSubjectToCheck(FirCallableSymbol $receiver, FirSession session2) {
        return FirUnusedReturnValueCheckerKt.isSubjectToCheck($receiver, session2);
    }

    public static final /* synthetic */ boolean access$isExcluded(FirCallableSymbol $receiver, FirSession session2) {
        return FirUnusedReturnValueCheckerKt.isExcluded($receiver, session2);
    }
}

